---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：21-PMU lid close

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。特に優先レビューが必要な項目はない。

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/powerpc/powermac/pmu.c` 行745-747（devctl_notify呼び出し）
- E-02: `sys/powerpc/powermac/pmuvar.h` 行101（PMU_ENV_LID_CLOSED定義）
- E-03: `sys/powerpc/powermac/pmuvar.h` 行84（PMU_INT_ENVIRONMENT定義）
- E-04: `sys/powerpc/powermac/pmuvar.h` 行163（lid_closedフィールド）
- E-05: `sys/powerpc/powermac/pmu.c` 行696-757（pmu_intr関数全体）
- E-06: `sys/powerpc/powermac/pmu.c` 行72-74（PMU_DEFAULTSマクロ）
- E-07: `sys/powerpc/powermac/pmu.c` 行312-313（割り込みハンドラ登録）
- E-08: `sys/powerpc/powermac/pmu.c` 行710-711（割り込み応答処理）
- E-09: `sys/powerpc/powermac/pmu.c` 行743（PMU_INT_ENVIRONMENTチェック）
- E-10: `sys/powerpc/powermac/pmuvar.h` 行102（PMU_ENV_POWER定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devctl_notifyの引数は"PMU","lid","close",NULL | E-01 | ○ |
| C-02 | PMU_ENV_LID_CLOSEDは0x01 | E-02 | ○ |
| C-03 | PMU_INT_ENVIRONMENTは0x40 | E-03 | ○ |
| C-04 | sc->lid_closedフラグで状態遷移を管理 | E-01, E-04 | ○ |
| C-05 | 環境割り込みかつLID_CLOSEDビットかつ前回開状態で通知 | E-05, E-01 | ○ |
| C-06 | PMU_DEFAULTSにPMU_INT_ENVIRONMENTが含まれる | E-06 | ○ |
| C-07 | bus_setup_intrでpmu_intrが割り込みハンドラに登録 | E-07 | ○ |
| C-08 | 割り込み応答はPMU_INT_ACKコマンドで取得 | E-08 | ○ |
| C-09 | resp[1]でPMU_INT_ENVIRONMENTをチェック | E-09 | ○ |
| C-10 | 追加データはNULL | E-01 | ○ |
| C-11 | 蓋が既に閉じている場合は重複通知を抑止 | E-01 | ○ |
| C-12 | Apple PowerMac99プラットフォーム専用 | E-05, E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全ての主張についてソースコードから直接根拠を確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 全主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] pmu_intr関数（pmu.c:696-757）のlid_closed制御ロジックが設計書と一致するか確認
- [ ] devctl_notify呼び出しの引数が正確か確認
- [ ] PMU_ENV_LID_CLOSEDの値（0x01）がpmuvar.hと一致するか確認
