---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-PMU POWER ACLINE

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/powerpc/powermac/pmu.c` 行950-963（pmu_battery_notify関数）
- E-02: `sys/powerpc/powermac/pmu.c` 行966-985（pmu_battquery_proc関数）
- E-03: `sys/powerpc/powermac/pmu.c` 行886-947（pmu_query_battery関数）
- E-04: `sys/powerpc/powermac/pmuvar.h` 行116（PMU_PWR_AC_PRESENT定義）
- E-05: `sys/powerpc/powermac/pmuvar.h` 行167-174（pmu_battstate構造体）
- E-06: `sys/powerpc/powermac/pmu.c` 行434（バッテリー監視スレッド起動条件）
- E-07: `sys/powerpc/powermac/pmu.c` 行988-1006（pmu_battmon sysctl）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devctl_notifyの引数は"PMU","POWER","ACLINE",notify_buf | E-01 | ○ |
| C-02 | notify_bufは"notify=0x%02x"形式でAC状態値を含む | E-01 | ○ |
| C-03 | PMU_PWR_AC_PRESENTはビット0 | E-04 | ○ |
| C-04 | 1秒間隔のポーリングで検出 | E-02 | ○ |
| C-05 | new_acline != old_aclineの場合のみ通知 | E-01 | ○ |
| C-06 | PMU_SMART_BATTERY_STATEコマンドで状態取得 | E-03 | ○ |
| C-07 | pmu_battstateのstateフィールドにバッテリーフラグ格納 | E-03, E-05 | ○ |
| C-08 | バッテリー0個の場合は監視スレッド未起動 | E-06 | ○ |
| C-09 | sysctl monitor_batteriesで有効/無効切替可能 | E-07 | ○ |
| C-10 | バッテリー取得失敗時は通知スキップ | E-02 | ○ |
| C-11 | pause("pmu_batt", hz)で1秒スリープ | E-02 | ○ |
| C-12 | Apple PowerMacプラットフォーム専用 | E-01, E-02 | ○ |
| C-13 | AC状態値は0x00(未接続)または0x01(接続) | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 全主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] pmu_battery_notify関数（pmu.c:950-963）のACLINE通知ロジックが正確か確認
- [ ] pmu_battquery_proc関数のポーリング間隔が1秒か確認
- [ ] notify_bufのフォーマット文字列が正確か確認
