---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-PMU USB overvoltage/undervoltage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/arm/allwinner/axp209.c` 行838-839（USB overvoltage devctl_notify）
- E-02: `sys/arm/allwinner/axp209.c` 行840-841（USB undervoltage devctl_notify）
- E-03: `sys/arm/allwinner/axp209reg.h` 行90（AXP2XX_IRQ1_VBUS_OVERVOLT定義）
- E-04: `sys/arm/allwinner/axp209reg.h` 行93（AXP2XX_IRQ1_VBUS_LOW定義）
- E-05: `sys/arm/allwinner/axp209.c` 行1228-1234（IRQ1有効化）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 過電圧時のdevctl_notify引数は"PMU","USB","overvoltage",NULL | E-01 | ○ |
| C-02 | 低電圧時のdevctl_notify引数は"PMU","USB","undervoltage",NULL | E-02 | ○ |
| C-03 | AXP2XX_IRQ1_VBUS_OVERVOLTはビット4（0x10） | E-03 | ○ |
| C-04 | AXP2XX_IRQ1_VBUS_LOWはビット1（0x02） | E-04 | ○ |
| C-05 | IRQ1_ENABLEでVBUS_OVERVOLTが有効化される | E-05 | ○ |
| C-06 | 追加データはNULL | E-01, E-02 | ○ |
| C-07 | ハードウェア割り込み駆動 | E-01 | ○ |
| C-08 | AXP209とAXP221の両方で共通定義 | E-03, E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] axp2xx_intr関数のVBUS_OVERVOLT/VBUS_LOWチェックが正確か確認
- [ ] ビットマスク値がaxp209reg.hと一致するか確認
