---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：31-Battery connected/disconnected

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **devctlキュー溢れ時の挙動**：カーネル内部実装の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sys/arm/allwinner/axp209.c` 859行目 - devctl_notify("PMU", "Battery", "connected", NULL)
- E-02: `sys/arm/allwinner/axp209.c` 861行目 - devctl_notify("PMU", "Battery", "disconnected", NULL)
- E-03: `sys/arm/allwinner/axp209.c` 827-886行目 - axp2xx_intr割り込みハンドラ全体
- E-04: `sys/arm/allwinner/axp209.c` 1235-1243行目 - IRQ2割り込みイネーブル設定
- E-05: `sys/arm/allwinner/axp209.c` 1274-1276行目 - bus_setup_intr呼び出し
- E-06: `sys/arm/allwinner/axp209.c` 598-619行目 - axp2xx_softc構造体定義
- E-07: `sys/arm/allwinner/axp209.c` 867行目 - IRQ ACK書き込み
- E-08: `sys/arm/allwinner/axp209.c` 853行目 - IRQ2ステータスレジスタ読み取り
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 32行目 - 通知一覧での定義
- E-10: `sys/arm/allwinner/axp81x.c` 1106-1109行目 - AXP803/813での類似通知（比較用）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devctl_notify("PMU", "Battery", "connected", NULL)で通知発行 | E-01 | ○ |
| C-02 | devctl_notify("PMU", "Battery", "disconnected", NULL)で通知発行 | E-02 | ○ |
| C-03 | axp2xx_intr割り込みハンドラ内で処理 | E-03 | ○ |
| C-04 | IRQ2のBATT_CONN/BATT_DISCONNビットで検出 | E-03, E-04 | ○ |
| C-05 | axp2xx_start関数でIRQ2割り込みを有効化 | E-04 | ○ |
| C-06 | bus_setup_intrで割り込みハンドラを登録 | E-05 | ○ |
| C-07 | data引数はNULL | E-01, E-02 | ○ |
| C-08 | IRQ処理後にACK書き込み | E-07 | ○ |
| C-09 | AXP209はAllwinner A10/A13/A20向けPMIC | E-06, E-09 | ○ |
| C-10 | AXP803/813では異なるタイプ名を使用 | E-10 | ○ |
| C-11 | /dev/devctlアクセスはrootのみ | **根拠なし** | △ |
| C-12 | I2Cバス読み取りエラー時は暗黙的に無視 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-11: /dev/devctlのパーミッション設定はカーネルのdevfs設定に依存する。具体的なパーミッション設定コードは本調査範囲外
  - 候補：`sys/fs/devfs/` / `etc/devfs.conf` / devfs.rules(5)マニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知の基本仕様はソースコードから直接確認可能
- 0: 低リスク - devctl_notifyの引数はハードコードされており変動なし

## 6) レビュアーチェックリスト（最小）
- [ ] axp209reg.hのAXP2XX_IRQ2_BATT_CONN/BATT_DISCONNビットマスクの値を確認
- [ ] AXP221でも同一の割り込みハンドラが使用されることを確認
- [ ] devdでの受信設定例が正しいか確認
