---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-Battery low-temp/high-temp

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/arm/allwinner/axp209.c` 863行目 - devctl_notify("PMU", "Battery", "low-temp", NULL)
- E-02: `sys/arm/allwinner/axp209.c` 865行目 - devctl_notify("PMU", "Battery", "high-temp", NULL)
- E-03: `sys/arm/allwinner/axp209.c` 853-868行目 - axp2xx_intr IRQ2処理ブロック
- E-04: `sys/arm/allwinner/axp209.c` 1235-1243行目 - IRQ2イネーブル設定
- E-05: `sys/arm/allwinner/axp209.c` 867行目 - IRQ ACK書き込み
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 33行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devctl_notify("PMU","Battery","low-temp",NULL)で低温通知 | E-01 | ○ |
| C-02 | devctl_notify("PMU","Battery","high-temp",NULL)で高温通知 | E-02 | ○ |
| C-03 | axp2xx_intr割り込みハンドラ内で処理 | E-03 | ○ |
| C-04 | IRQ2のBATT_TEMP_LOW/BATT_TEMP_OVERビットで検出 | E-03 | ○ |
| C-05 | IRQ2イネーブルにBATT_TEMP_OVER/BATT_TEMP_LOWを設定 | E-04 | ○ |
| C-06 | data引数はNULL | E-01, E-02 | ○ |
| C-07 | IRQ処理後にACK書き込み | E-05 | ○ |
| C-08 | ハードウェア割り込みレベルで発行 | E-03 | ○ |
| C-09 | NTCサーミスタによる温度測定 | E-06 | ○ |
| C-10 | 通知一覧で定義済み | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] axp209reg.hでAXP2XX_IRQ2_BATT_TEMP_LOW/BATT_TEMP_OVERの値を確認
- [ ] NTC温度閾値のデフォルト値を確認（PMICデータシート参照）
