---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-Battery warning-threshold

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/arm/allwinner/axp81x.c` 1132-1133行目 - devctl_notify("PMU", "Battery", "warning-threshold", NULL)
- E-02: `sys/arm/allwinner/axp81x.c` 1123-1136行目 - axp8xx_intr IRQ4処理ブロック
- E-03: `sys/arm/allwinner/axp81x.c` 1593-1595行目 - AXP_IRQEN4設定
- E-04: `sys/arm/allwinner/axp81x.c` 1567-1579行目 - 閾値読み取り
- E-05: `sys/arm/allwinner/axp81x.c` 133-134行目 - AXP_IRQEN4_BATLVL_LO1定数
- E-06: `sys/arm/allwinner/axp81x.c` 192-194行目 - AXP_BAT_CAP_WARN定数
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 34行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devctl_notify("PMU","Battery","warning-threshold",NULL)で通知 | E-01 | ○ |
| C-02 | AXP_IRQSTAT4_BATLVL_LO1ビットで検出 | E-02, E-05 | ○ |
| C-03 | axp8xx_intr割り込みハンドラ内で処理 | E-02 | ○ |
| C-04 | AXP_IRQEN4にBATLVL_LO1を有効化 | E-03 | ○ |
| C-05 | LV1閾値は5-20%で1%ステップ | E-06 | ○ |
| C-06 | LV0到達時は"shutdown-threshold"通知 | E-02 | ○ |
| C-07 | warn_thresはAXP_BAT_CAP_WARNから読み取り | E-04 | ○ |
| C-08 | data引数はNULL | E-01 | ○ |
| C-09 | I2C読み取りエラー時はreturn | E-02 | ○ |
| C-10 | AXP209/221にはこの通知は未実装 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから全主張を直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] AXP_BAT_CAP_WARNレジスタのデフォルト値をPMICデータシートで確認
- [ ] "shutdown-threshold" 通知との使い分けが適切か確認
