---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-ACPI ACAD power

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/arm/ti/am335x/am335x_pmic.c` 115行目 - devctl_notify("ACPI", "ACAD", "power", notify_buf)
- E-02: `sys/arm/ti/am335x/am335x_pmic.c` 86-117行目 - am335x_pmic_intr割り込みハンドラ
- E-03: `sys/arm/ti/am335x/am335x_pmic.c` 113-114行目 - snprintfでnotify_buf生成
- E-04: `sys/arm/ti/am335x/am335x_pmic.c` 96行目 - INT_REG読み取り
- E-05: `sys/arm/ti/am335x/am335x_pmic.c` 102行目 - STATUS_REG読み取り
- E-06: `sys/arm/ti/am335x/am335x_pmic.c` 271-273行目 - bus_setup_intr呼び出し
- E-07: `sys/arm/ti/am335x/am335x_pmic.c` 110-111行目 - pbi処理
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 35行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devctl_notify("ACPI","ACAD","power",notify_buf)で通知 | E-01 | ○ |
| C-02 | am335x_pmic_intr割り込みハンドラ内で処理 | E-02 | ○ |
| C-03 | notify_bufに"notify=0x%02x"フォーマットでacpwr値を格納 | E-03 | ○ |
| C-04 | int_reg.aciで条件判定 | E-02 | ○ |
| C-05 | status_reg.acpwrが通知データ | E-03, E-05 | ○ |
| C-06 | I2C読み取りエラー時はdevice_printfでエラー出力後return | E-04, E-05 | ○ |
| C-07 | pbi && status_reg.pb でshutdown_nice | E-07 | ○ |
| C-08 | bus_setup_intrでハンドラ登録 | E-06 | ○ |
| C-09 | TPS65217はAM335xプラットフォーム向けPMIC | E-08 | ○ |
| C-10 | "ACPI" "ACAD"はACPIのACアダプターデバイス名に由来 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから全主張を直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] tps65217x.hのレジスタ定義を確認
- [ ] "ACPI" "ACAD" の命名がdevdルールと整合するか確認
