---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-keys brightness/mute/volume/eject

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/dev/adb/adb_buttons.c` 118-119行目 - brightness down通知
- E-02: `sys/dev/adb/adb_buttons.c` 123行目 - brightness up通知
- E-03: `sys/dev/adb/adb_buttons.c` 128行目 - mute通知
- E-04: `sys/dev/adb/adb_buttons.c` 132行目 - volume down通知
- E-05: `sys/dev/adb/adb_buttons.c` 136行目 - volume up通知
- E-06: `sys/dev/adb/adb_buttons.c` 142行目 - eject通知
- E-07: `sys/dev/adb/adb_buttons.c` 108-156行目 - abtn_receive_packet全体
- E-08: `sys/dev/adb/adb_buttons.c` 88行目 - ADB_DEVICE_MISCタイプチェック
- E-09: `sys/dev/adb/adb_buttons.c` 138-139行目 - 0x0cミラーディスプレイ（未実装コメント）
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 36行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 0x0aでbrightness down通知 | E-01 | ○ |
| C-02 | 0x09でbrightness up通知 | E-02 | ○ |
| C-03 | 0x08/0x01でmute通知 | E-03 | ○ |
| C-04 | 0x07/0x02でvolume down通知 | E-04 | ○ |
| C-05 | 0x06/0x03でvolume up通知 | E-05 | ○ |
| C-06 | 0x0bでeject通知 | E-06 | ○ |
| C-07 | abtn_receive_packetでswitch文による判定 | E-07 | ○ |
| C-08 | ADB_DEVICE_MISCタイプのデバイスのみ対応 | E-08 | ○ |
| C-09 | 0x0c/0x7fはdevctl通知未実装 | E-09 | ○ |
| C-10 | brightness/volumeはnotify=up/down付き | E-01, E-02, E-04, E-05 | ○ |
| C-11 | mute/ejectはdata=NULL | E-03, E-06 | ○ |
| C-12 | 通知一覧で定義済み | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ADBコマンドバイト一覧がAppleハードウェア仕様と整合するか確認
- [ ] 0x01-0x03のAVハードウェアバリアント対応が適切か確認
