---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 8
  claims_with_evidence: 7
  claims_without_evidence: 1
confidence_derived: 0.88
---

# 根拠レポート：36-kernel power resume

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：7 / 8、根拠なし：1
- 優先レビュー（高）
  1. **サスペンド通知の未実装**：対応するサスペンド通知がないことの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/kern/subr_bus.c` 5131行目 - devctl_notify("kernel", "power", "resume", NULL)
- E-02: `sys/kern/subr_bus.c` 5124-5134行目 - root_resume関数全体
- E-03: `sys/kern/subr_bus.c` 5129行目 - bus_generic_resume呼び出し
- E-04: `sys/kern/subr_bus.c` 5123行目 - コメント "Resume all devices and then notify userland"
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 37行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devctl_notify("kernel","power","resume",NULL)で通知 | E-01 | ○ |
| C-02 | root_resume関数内で発行 | E-02 | ○ |
| C-03 | bus_generic_resume成功後に発行 | E-02, E-03 | ○ |
| C-04 | error == 0 の条件で発行 | E-02 | ○ |
| C-05 | data引数はNULL | E-01 | ○ |
| C-06 | ルートバスデバイスのレジュームメソッド | E-04 | ○ |
| C-07 | サスペンド通知は未実装 | **根拠なし** | △ |
| C-08 | 通知一覧で定義済み | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-07: subr_bus.c内のroot_suspend関数にdevctl_notifyがないことを確認する必要がある
  - 候補：`sys/kern/subr_bus.c` root_suspend関数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本仕様はソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] root_suspend関数にdevctl_notifyが含まれないことを確認
- [ ] ACPIサブシステムからroot_resumeが呼び出される経路を確認
