---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-kernel signal coredump

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/kern/coredump_vnode.c` 550行目 - devctl_notify("kernel", "signal", "coredump", sbuf_data(sb))
- E-02: `sys/kern/coredump_vnode.c` 113-115行目 - coredump_devctl sysctl定義
- E-03: `sys/kern/coredump_vnode.c` 518行目 - error != 0 || coredump_devctl == 0 チェック
- E-04: `sys/kern/coredump_vnode.c` 521行目 - vn_fullpath_global呼び出し
- E-05: `sys/kern/coredump_vnode.c` 523-524行目 - comm フィールド構築
- E-06: `sys/kern/coredump_vnode.c` 547-548行目 - jid/pid/ppid/signo フィールド
- E-07: `sys/kern/coredump_vnode.c` 451-453行目 - ppid/sig/jid取得
- E-08: `sys/kern/coredump_vnode.c` 524行目 - devctl_safe_quote_sb使用
- E-09: `sys/kern/coredump_vnode.c` 120行目 - corefilename定義
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 38行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devctl_notify("kernel","signal","coredump",...)で通知 | E-01 | ○ |
| C-02 | kern.coredump_devctlのデフォルト値は0 | E-02 | ○ |
| C-03 | error == 0 かつ coredump_devctl != 0 で通知 | E-03 | ○ |
| C-04 | vn_fullpath_globalで実行ファイルパス取得 | E-04 | ○ |
| C-05 | comm, core, jid, pid, ppid, signoを含む | E-05, E-06 | ○ |
| C-06 | p->p_oppid, p->p_sig, cr_prison->pr_idから取得 | E-07 | ○ |
| C-07 | devctl_safe_quote_sbでパスをエスケープ | E-08 | ○ |
| C-08 | コアファイル名フォーマットは%N.coreがデフォルト | E-09 | ○ |
| C-09 | sbuf_finish成功時のみ通知発行 | E-01 | ○ |
| C-10 | vn_fullpath_global失敗時はgoto out2 | E-04 | ○ |
| C-11 | 相対パスの場合CWDを前置 | E-05 | ○ |
| C-12 | 通知一覧で定義済み | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] kern.coredump_devctlの設定方法をドキュメントで確認
- [ ] devctl_safe_quote_sbのエスケープ仕様を確認
