---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-CAM iosched latency

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/cam/cam_iosched.c` 1954行目 - devctl_notify("CAM", "iosched", "latency", sbuf_data(&sb))
- E-02: `sys/cam/cam_iosched.c` 1936-1957行目 - cam_iosched_devctl_outlier関数
- E-03: `sys/cam/cam_iosched.c` 1960-1973行目 - cam_iosched_update関数
- E-04: `sys/cam/cam_iosched.c` 1970行目 - sim_latency > iop->bad_latency 判定
- E-05: `sys/cam/cam_iosched.c` 1949-1952行目 - sbuf_printfでデータ構築
- E-06: `sys/cam/cam_iosched.c` 2050-2067行目 - cam_iosched_io_metric_update
- E-07: `sys/cam/cam_iosched.c` 69-74行目 - CAM_IOSCHED_DYNAMIC定義
- E-08: `sys/cam/cam_iosched.c` 1933行目 - CAM_IOSCHED_DEVD_MSG_SIZE定義
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 39行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devctl_notify("CAM","iosched","latency",...)で通知 | E-01 | ○ |
| C-02 | sim_latency > bad_latencyで閾値判定 | E-04 | ○ |
| C-03 | cam_iosched_devctl_outlierで通知構築 | E-02 | ○ |
| C-04 | device, lba, blocks, latencyを含む | E-05 | ○ |
| C-05 | cam_iosched_io_metric_updateから呼び出し | E-06 | ○ |
| C-06 | read/write/trim 3種類のI/Oタイプ対応 | E-06 | ○ |
| C-07 | CAM_IOSCHED_DYNAMIC必須 | E-07 | ○ |
| C-08 | バッファサイズ256バイト | E-08 | ○ |
| C-09 | malloc(M_NOWAIT)失敗時はreturn | E-02 | ○ |
| C-10 | sbuf_finish成功時のみ通知 | E-01 | ○ |
| C-11 | 通知一覧で定義済み | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 高負荷時に大量の通知が発生する可能性がある（レート制限なし）

## 6) レビュアーチェックリスト（最小）
- [ ] bad_latencyのデフォルト値とsysctl設定方法を確認
- [ ] 高負荷時の通知量がdevctlキューに影響しないか確認
