---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-DEV_SIZECHANGE

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/geom/geom_dev.c` 行318-329（g_dev_resize関数）
- E-02: `sys/geom/geom_dev.c` 行328（devctl_notify呼出）
- E-03: `sys/geom/geom_dev.c` 行327（snprintf cdev=cp->provider->name）
- E-04: `sys/geom/geom_dev.c` 行325（KNOTE_UNLOCKED NOTE_ATTRIB）
- E-05: `sys/geom/geom_disk.c` 行1053-1061（disk_resize関数）
- E-06: `sys/geom/geom_disk.c` 行670-694（g_disk_resize関数）
- E-07: `sys/geom/geom_dev.c` 行106（g_dev_class.resize = g_dev_resize）
- E-08: `sys/geom/geom_dev.c` 行60-70（g_dev_softc構造体）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | g_dev_resize()でSIZECHANGE通知が発行される | E-01, E-02 | ○ |
| C-02 | 通知データは「cdev=プロバイダ名」形式 | E-03 | ○ |
| C-03 | KNOTE_UNLOCKEDでNOTE_ATTRIBイベントも発行される | E-04 | ○ |
| C-04 | disk_resize()が上位エントリーポイント | E-05 | ○ |
| C-05 | g_disk_resize()でg_resize_provider()が呼ばれる | E-06 | ○ |
| C-06 | g_dev_classのresizeフィールドにg_dev_resizeが設定されている | E-07 | ○ |
| C-07 | デバイス名はcp->provider->nameから取得される | E-03 | ○ |
| C-08 | sc_selinfoのknoteリストに通知される | E-04, E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] g_dev_resize()の処理フローが正確か確認
- [ ] デバイス名の取得元がcp->provider->nameであることを確認
