---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-NVMe controller event

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/dev/nvme/nvme_ctrlr.c` 77行目 - devctl_notify("nvme", "controller", type, sbuf_data(&sb))
- E-02: `sys/dev/nvme/nvme_ctrlr.c` 65-79行目 - nvme_ctrlr_devctl_va関数
- E-03: `sys/dev/nvme/nvme_ctrlr.c` 82-89行目 - nvme_ctrlr_devctl関数
- E-04: `sys/dev/nvme/nvme_ctrlr.c` 92-110行目 - nvme_ctrlr_devctl_log関数
- E-05: `sys/dev/nvme/nvme_ctrlr.c` 1153行目 - RESET start通知
- E-06: `sys/dev/nvme/nvme_ctrlr.c` 1156行目 - RESET success通知
- E-07: `sys/dev/nvme/nvme_ctrlr.c` 1159行目 - RESET timed_out通知
- E-08: `sys/dev/nvme/nvme_ctrlr.c` 682行目 - SMART_ERROR通知
- E-09: `sys/dev/nvme/nvme_ctrlr.c` 1204-1206行目 - AEN通知
- E-10: `sys/dev/nvme/nvme_ctrlr.c` 73行目 - name=デバイス名の自動付加
- E-11: `sys/dev/nvme/nvme_ctrlr.c` 1191行目 - is_resetting判定
- E-12: `sys/dev/nvme/nvme_ctrlr.c` 1194行目 - is_log_page_id_valid判定
- E-13: `sys/dev/nvme/nvme_ctrlr.c` 650-683行目 - SMART警告処理全体
- E-14: `docs/code-to-docs/通知一覧/通知一覧.csv` 41行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devctl_notify("nvme","controller",type,...)で通知 | E-01 | ○ |
| C-02 | nvme_ctrlr_devctl_vaが共通基盤 | E-02 | ○ |
| C-03 | nvme_ctrlr_devctlが可変引数ラッパー | E-03 | ○ |
| C-04 | nvme_ctrlr_devctl_logがログ出力付き | E-04 | ○ |
| C-05 | RESET start/success/timed_outの3段階 | E-05, E-06, E-07 | ○ |
| C-06 | SMART_ERRORでstate=0x%02x形式 | E-08 | ○ |
| C-07 | AENでtype/info/pageを含む | E-09 | ○ |
| C-08 | name=デバイス名を自動付加 | E-10 | ○ |
| C-09 | リセット中はAENタスクをスキップ | E-11 | ○ |
| C-10 | ログページID無効時はdevctl通知スキップ | E-12 | ○ |
| C-11 | sbuf_new(SBUF_NOWAIT)で確保 | E-02 | ○ |
| C-12 | SMART警告にはtemperature/reliability/readonly/volatile/persistent | E-13 | ○ |
| C-13 | sbuf_finish成功時のみ通知 | E-01, E-02 | ○ |
| C-14 | 通知一覧で定義済み | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] NVME_CRIT_WARN_STの各ビット定義を確認
- [ ] AENイベントタイプの完全なリストを確認
- [ ] nvmf（NVMe over Fabrics）のRECONNECT通知との関連を確認
