---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：41-NVMeコントローラRECONNECT通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **devd.conf の自動再接続設定**：具体的な設定例の根拠が不足

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/dev/nvmf/host/nvmf.c` 行749 - devctl_notify("nvme", "controller", "RECONNECT", buf) 呼び出し
- E-02: `sys/dev/nvmf/host/nvmf.c` 行742-752 - nvmf_request_reconnect() 関数定義
- E-03: `sys/dev/nvmf/host/nvmf.c` 行640-707 - nvmf_disconnect_task() 関数定義
- E-04: `sys/dev/nvmf/host/nvmf.c` 行755-768 - nvmf_request_reconnect_task() 関数定義
- E-05: `sys/dev/nvmf/host/nvmf.c` 行699-704 - reconnect_delay と controller_loss_timeout の条件分岐
- E-06: `sys/dev/nvmf/host/nvmf.c` 行748 - snprintf(buf, sizeof(buf), "name=\"%s\"", device_get_nameunit(sc->dev))
- E-07: `sys/dev/nvmf/host/nvmf.c` 行771-843 - nvmf_reconnect_host() 関数定義
- E-08: `sys/dev/nvmf/host/nvmf.c` 行301-303 - reconnect_delay, controller_loss_timeout の nvlist からの取得
- E-09: `sys/dev/nvmf/host/nvmf.c` 行760 - 再接続済み/デタッチ中/タイムアウトの抑止条件
- E-10: `sys/dev/nvmf/host/nvmf.c` 行710-739 - nvmf_controller_loss_task() による自動デタッチ
- E-11: `sys/dev/nvmf/host/nvmf.c` 行634-637 - nvmf_disconnect() 関数定義
- E-12: `sys/dev/nvmf/host/nvmf.c` 行837-838 - 再接続成功時のタスクキャンセル

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知は devctl_notify("nvme", "controller", "RECONNECT", ...) として発行される | E-01 | ○ |
| C-02 | 通知データには name="nvmeN" が含まれる | E-06 | ○ |
| C-03 | 切断検知時に nvmf_disconnect_task が実行される | E-03, E-11 | ○ |
| C-04 | reconnect_delay != 0 の場合に通知が発行される | E-05 | ○ |
| C-05 | reconnect_delay 秒間隔で定期的に再送信される | E-02, E-04 | ○ |
| C-06 | admin != NULL の場合は送信抑止される | E-09 | ○ |
| C-07 | detaching == true の場合は送信抑止される | E-09 | ○ |
| C-08 | controller_timedout == true の場合は送信抑止される | E-09 | ○ |
| C-09 | controller_loss_timeout 到達時にデバイスが自動デタッチされる | E-10 | ○ |
| C-10 | 再接続成功時に定期通知タスクがキャンセルされる | E-12 | ○ |
| C-11 | reconnect_delay, controller_loss_timeout は nvlist から取得される | E-08 | ○ |
| C-12 | nvmf_reconnect_host() が NVMF_RECONNECT_HOST ioctl のハンドラである | E-07 | ○ |
| C-13 | nvmecontrol が再接続を行う | E-07 | ○ |
| C-14 | devd.conf に適切なルールを設定することで自動再接続ワークフローを構築可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- devd.conf での具体的な NVMf 再接続設定例がソースコードからは確認できない
  - 候補：devd.conf のサンプル / nvmecontrol のマニュアルページ / FreeBSD ハンドブック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知の発行メカニズム自体はソースコードで明確に確認済み
- 1: 中リスク - devd.conf との連携部分は実装例の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] devctl_notify の引数（system="nvme", subsystem="controller", type="RECONNECT"）がソースコードと一致しているか
- [ ] 送信抑止条件が nvmf_request_reconnect_task() の条件分岐と一致しているか
- [ ] reconnect_delay と controller_loss_timeout の説明が実装と整合しているか
