---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：42-VFS_FSマウントイベント通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が存在する

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/kern/vfs_mount.c` 行3009 - devctl_notify("VFS", "FS", type, sbuf_data(&sb))
- E-02: `sys/kern/vfs_mount.c` 行1290 - mount_devctl_event("MOUNT", mp, false)
- E-03: `sys/kern/vfs_mount.c` 行1553 - mount_devctl_event("REMOUNT", mp, true)
- E-04: `sys/kern/vfs_mount.c` 行2403 - mount_devctl_event("UNMOUNT", mp, false)
- E-05: `sys/kern/vfs_mount.c` 行2981-2998 - sbuf への情報構築（mount-point, mount-dev, mount-type, fsid, owner, flags）
- E-06: `sys/kern/vfs_mount.c` 行2977-2978 - M_NOWAIT でのメモリ割り当て
- E-07: `sys/kern/vfs_mount.c` 行2980 - SBUF_FIXEDLEN での sbuf 初期化
- E-08: `sys/kern/vfs_mount.c` 行2967 - DEVCTL_LEN 1024 の定義
- E-09: `sys/kern/vfs_mount.c` 行2982-2986 - devctl_safe_quote_sb によるエスケープ
- E-10: `sys/kern/vfs_mount.c` 行3001-3006 - オプションが意図的に除外されている旨のコメント

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知は devctl_notify("VFS", "FS", type, ...) として発行される | E-01 | ○ |
| C-02 | MOUNT イベントは mount 成功時に発行 | E-02 | ○ |
| C-03 | REMOUNT イベントは remount 成功時に発行 | E-03 | ○ |
| C-04 | UNMOUNT イベントは unmount 成功時に発行 | E-04 | ○ |
| C-05 | 通知データに mount-point, mount-dev, mount-type, fsid, owner, flags が含まれる | E-05 | ○ |
| C-06 | M_NOWAIT でのメモリ割り当て失敗時は通知がスキップされる | E-06 | ○ |
| C-07 | sbuf エラー時は通知がスキップされる | E-07 | ○ |
| C-08 | DEVCTL_LEN は 1024 バイト | E-08 | ○ |
| C-09 | パス名は devctl_safe_quote_sb でエスケープされる | E-09 | ○ |
| C-10 | オプションは意図的に通知に含まれない | E-10 | ○ |
| C-11 | マウントフラグは optnames テーブルで変換される | E-05 | ○ |
| C-12 | FSID は 16 進数で出力される | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] devctl_notify の引数がソースコードと一致しているか
- [ ] 3 種類のイベントタイプ（MOUNT, REMOUNT, UNMOUNT）が漏れなく記載されているか
- [ ] 通知データフィールドの一覧が mount_devctl_event() の実装と一致しているか
