---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：43-RCTLルールマッチ通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が存在する

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/kern/kern_rctl.c` 行589-590 - devctl_notify("RCTL", "rule", "matched", sbuf_data(&sb))
- E-02: `sys/kern/kern_rctl.c` 行566-594 - RCTL_ACTION_DEVCTL 処理ブロック
- E-03: `sys/kern/kern_rctl.c` 行567-568 - rrl_exceeded による重複抑止
- E-04: `sys/kern/kern_rctl.c` 行570-571 - p->p_state != PRS_NORMAL による抑止
- E-05: `sys/kern/kern_rctl.c` 行573-575 - ppsratecheck による レート制限
- E-06: `sys/kern/kern_rctl.c` 行577-580 - M_NOWAIT でのメモリ割り当て
- E-07: `sys/kern/kern_rctl.c` 行582-590 - sbuf への rule, pid, ruid, jail の構築
- E-08: `sys/kern/kern_rctl.c` 行593 - rrl_exceeded = 1 の設定
- E-09: `sys/kern/kern_rctl.c` 行100-101 - rctl_devctl_rate_limit デフォルト値 10
- E-10: `sys/kern/kern_rctl.c` 行73 - RCTL_LOG_BUFSIZE = 128
- E-11: `sys/kern/kern_rctl.c` 行208 - actionnames に "devctl" が RCTL_ACTION_DEVCTL として定義
- E-12: `sys/kern/kern_rctl.c` 行494-695 - rctl_enforce() 関数全体

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知は devctl_notify("RCTL", "rule", "matched", ...) として発行される | E-01 | ○ |
| C-02 | RCTL_ACTION_DEVCTL アクション時に通知が発行される | E-02, E-11 | ○ |
| C-03 | rrl_exceeded != 0 の場合は重複抑止される | E-03 | ○ |
| C-04 | p_state != PRS_NORMAL の場合は抑止される | E-04 | ○ |
| C-05 | ppsratecheck による レート制限がある | E-05 | ○ |
| C-06 | M_NOWAIT でのメモリ割り当て失敗時はスキップ | E-06 | ○ |
| C-07 | 通知データに rule, pid, ruid, jail が含まれる | E-07 | ○ |
| C-08 | 通知後に rrl_exceeded = 1 が設定される | E-08 | ○ |
| C-09 | デフォルトのレート制限は 10 回/秒 | E-09 | ○ |
| C-10 | RCTL_LOG_BUFSIZE は 128 バイト | E-10 | ○ |
| C-11 | rctl_enforce() がリソース超過チェックのメイン関数 | E-12 | ○ |
| C-12 | rctl_rule_to_sbuf() がルール文字列を構築する | E-07 | ○ |
| C-13 | レート制限は sysctl で動的変更可能 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] devctl_notify の引数がソースコードと一致しているか
- [ ] 送信抑止条件（rrl_exceeded, p_state, ppsratecheck）が漏れなく記載されているか
- [ ] RCTL_LOG_BUFSIZE の値が正しいか
