---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：44-VTベル鳴動通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が存在する

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/dev/vt/vt_core.c` 行1116 - devctl_notify("VT", "BELL", "RING", sbuf_data(&sb))
- E-02: `sys/dev/vt/vt_core.c` 行1100 - #define DEVCTL_LEN 64
- E-03: `sys/dev/vt/vt_core.c` 行1107-1108 - malloc(DEVCTL_LEN, M_VT, M_NOWAIT)
- E-04: `sys/dev/vt/vt_core.c` 行1111-1113 - sbuf_printf に enabled, hushed, hz, duration_ms
- E-05: `sys/dev/vt/vt_core.c` 行1127 - vtterm_bell から vtterm_devctl の呼び出し
- E-06: `sys/dev/vt/vt_core.c` 行1167 - ioctl ハンドラから vtterm_devctl の呼び出し
- E-07: `sys/dev/vt/vt_core.c` 行1115 - sbuf_error チェック

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知は devctl_notify("VT", "BELL", "RING", ...) として発行される | E-01 | ○ |
| C-02 | DEVCTL_LEN は 64 バイト | E-02 | ○ |
| C-03 | M_NOWAIT でメモリ割り当て | E-03 | ○ |
| C-04 | データに enabled, hushed, hz, duration_ms が含まれる | E-04 | ○ |
| C-05 | BEL 文字受信時に vtterm_bell から呼ばれる | E-05 | ○ |
| C-06 | ioctl（KDMKTONE等）から呼ばれる | E-06 | ○ |
| C-07 | sbuf_error チェックで通知スキップ | E-07 | ○ |
| C-08 | vt_enable_bell が false でも devctl 通知は発行される | E-04, E-05 | ○ |
| C-09 | hushed フラグは VDF_QUIET_BELL から取得 | E-05 | ○ |
| C-10 | duration_ms は SBT_1MS で割って算出 | E-04 | ○ |
| C-11 | メモリ割り当て失敗時は通知スキップ | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] devctl_notify の引数がソースコードと一致しているか
- [ ] テンプレート変数 4 項目がすべて記載されているか
- [ ] 2 つの呼び出し元（vtterm_bell, ioctl）が漏れなく記載されているか
