---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-ZFSイベント通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が存在する

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/contrib/openzfs/module/os/freebsd/spl/spl_sysevent.c` 行219 - devctl_notify("ZFS", "ZFS", type, sbuf_data(sb))
- E-02: `sys/contrib/openzfs/module/os/freebsd/spl/spl_sysevent.c` 行226-263 - sysevent_worker() メインループ
- E-03: `sys/contrib/openzfs/module/os/freebsd/spl/spl_sysevent.c` 行46-223 - log_sysevent() 関数
- E-04: `sys/contrib/openzfs/module/os/freebsd/spl/spl_sysevent.c` 行215-218 - ESC_ZFS_ から misc.fs.zfs. への変換
- E-05: `sys/contrib/openzfs/module/os/freebsd/spl/spl_sysevent.c` 行53 - sbuf_new_auto()
- E-06: `sys/contrib/openzfs/module/os/freebsd/spl/spl_sysevent.c` 行236 - dst_size = 131072
- E-07: `sys/contrib/openzfs/module/os/freebsd/spl/spl_sysevent.c` 行199-200 - NVLIST 型は未実装コメント
- E-08: `sys/contrib/openzfs/module/os/freebsd/spl/spl_sysevent.c` 行119 - FM_CLASS の検出
- E-09: `sys/contrib/openzfs/module/os/freebsd/spl/spl_sysevent.c` 行266-269 - ddi_sysevent_init()
- E-10: `sys/contrib/openzfs/module/os/freebsd/spl/spl_sysevent.c` 行243-244 - ESHUTDOWN でスレッド終了

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知は devctl_notify("ZFS", "ZFS", type, ...) として発行される | E-01 | ○ |
| C-02 | sysevent_worker が専用カーネルスレッドとして動作する | E-02, E-09 | ○ |
| C-03 | log_sysevent() が nvlist を devctl 通知に変換する | E-03 | ○ |
| C-04 | ESC_ZFS_ プレフィックスが misc.fs.zfs. に変換される | E-04 | ○ |
| C-05 | sbuf_new_auto() でバッファが自動拡張される | E-05 | ○ |
| C-06 | dst_size は 131072 バイト | E-06 | ○ |
| C-07 | NVLIST 型は未実装 | E-07 | ○ |
| C-08 | FM_CLASS 属性が type として使用される | E-08 | ○ |
| C-09 | type が NULL の場合は空文字列として処理される | E-03 | ○ |
| C-10 | ESHUTDOWN でワーカースレッドが終了する | E-10 | ○ |
| C-11 | nvlist の全属性がスペース区切りで出力される | E-03 | ○ |
| C-12 | zfskern プロセスの sysevent スレッドとして起動 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] devctl_notify の引数がソースコードと一致しているか
- [ ] ESC_ZFS_ から misc.fs.zfs. への変換ロジックが正しいか
- [ ] nvlist の型別変換処理が漏れなく記載されているか
