---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-HDAコネクタイベント通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が存在する

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/dev/sound/pci/hda/hdaa.c` 行591-592 - devctl_notify("SND", "CONN", asp->dir == HDAA_CTL_IN ? "IN" : "OUT", buf)
- E-02: `sys/dev/sound/pci/hda/hdaa.c` 行589-590 - snprintf(buf, sizeof(buf), "cdev=dsp%d", device_get_unit(asp->pdevinfo->dev))
- E-03: `sys/dev/sound/pci/hda/hdaa.c` 行576-579 - アクティブコーデックチェック
- E-04: `sys/dev/sound/pci/hda/hdaa.c` 行583-595 - アソシエーション走査と通知発行
- E-05: `sys/dev/sound/pci/hda/hdaa.c` 行585-586 - asp->enable チェック

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知は devctl_notify("SND", "CONN", "IN"/"OUT", ...) として発行される | E-01 | ○ |
| C-02 | 通知データに cdev=dspN が含まれる | E-02 | ○ |
| C-03 | 非アクティブなコーデックのイベントは無視される | E-03 | ○ |
| C-04 | アソシエーション配列を走査して対応を検索 | E-04 | ○ |
| C-05 | asp->enable が false のアソシエーションはスキップされる | E-05 | ○ |
| C-06 | IN は入力方向、OUT は出力方向を示す | E-01 | ○ |
| C-07 | device_get_unit で DSP デバイス番号を取得 | E-02 | ○ |
| C-08 | unsolicited response がトリガーとなる | E-03 | ○ |
| C-09 | 接続変化に関連するアソシエーションが通知対象 | E-04 | ○ |
| C-10 | 同じ方向のアソシエーションもフォールバックで通知される | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] devctl_notify の引数がソースコードと一致しているか
- [ ] IN/OUT の判定ロジック（HDAA_CTL_IN）が正しいか
- [ ] cdev=dspN の構築方法が正しいか
