---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-CPU温度閾値超過通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が存在する

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/dev/coretemp/coretemp.c` 行402-403 - devctl_notify("coretemp", "Thermal", stemp, "notify=0xcc")
- E-02: `sys/dev/coretemp/coretemp.c` 行395-398 - THERM_CRITICAL_STATUS 検出と温度計算
- E-03: `sys/dev/coretemp/coretemp.c` 行380-382 - THERM_STATUS_LOG ビット検出
- E-04: `sys/dev/coretemp/coretemp.c` 行401 - snprintf(stemp, sizeof(stemp), "%d", tmp)
- E-05: `sys/dev/coretemp/coretemp.c` 行64-68 - struct coretemp_softc 定義
- E-06: `sys/dev/coretemp/coretemp.c` 行51 - TZ_ZEROC = 2731
- E-07: `sys/dev/coretemp/coretemp.c` 行342-408 - coretemp_get_val_sysctl() 全体
- E-08: `sys/dev/coretemp/coretemp.c` 行203 - sc_tjmax デフォルト値 100
- E-09: `sys/dev/coretemp/coretemp.c` 行399-400 - device_printf クリティカル警告
- E-10: `sys/dev/coretemp/coretemp.c` 行353 - coretemp_get_thermal_msr() 呼び出し
- E-11: `sys/dev/coretemp/coretemp.c` 行357 - THERM_STATUS_VALID_MASK チェック

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知は devctl_notify("coretemp", "Thermal", stemp, "notify=0xcc") として発行 | E-01 | ○ |
| C-02 | THERM_CRITICAL_STATUS ビットで クリティカル温度を判定 | E-02 | ○ |
| C-03 | THERM_STATUS_LOG ビットが温度ログの検出に使用される | E-03 | ○ |
| C-04 | 温度値は文字列として type に渡される | E-04 | ○ |
| C-05 | TZ_ZEROC は 2731 | E-06 | ○ |
| C-06 | coretemp_get_val_sysctl が sysctl ハンドラ | E-07 | ○ |
| C-07 | sc_tjmax のデフォルト値は 100 | E-08 | ○ |
| C-08 | クリティカル温度時に device_printf で警告が出力される | E-09 | ○ |
| C-09 | coretemp_get_thermal_msr() で MSR を読み取る | E-10 | ○ |
| C-10 | THERM_STATUS_VALID_MASK で有効性をチェック | E-11 | ○ |
| C-11 | notify=0xcc は固定値 | E-01 | ○ |
| C-12 | 温度読み取りは sysctl からトリガーされる | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] devctl_notify の引数がソースコードと一致しているか
- [ ] 温度計算式（(tjmax - delta) * 10 + TZ_ZEROC）が正しいか
- [ ] THERM_CRITICAL_STATUS と THERM_STATUS_LOG の区別が正確か
