---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-HyperVネットワークVF状態通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が存在する

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/dev/hyperv/netvsc/if_hn.c` 行1224-1225 - devctl_notify("HYPERV_NIC_VF", if_name(hn_ifp), rxvf ? "VF_UP" : "VF_DOWN", NULL)
- E-02: `sys/dev/hyperv/netvsc/if_hn.c` 行1209 - HN_NVS_DATAPATH_VF / HN_NVS_DATAPATH_SYNTH 切り替え
- E-03: `sys/dev/hyperv/netvsc/if_hn.c` 行1211 - hn_rxvf_set() 呼び出し
- E-04: `sys/dev/hyperv/netvsc/if_hn.c` 行1213-1221 - rxvf に応じた条件分岐
- E-05: `sys/dev/hyperv/netvsc/if_hn.c` 行1214 - hn_vf_rss_fixup(sc, true) (VF_UP 時)
- E-06: `sys/dev/hyperv/netvsc/if_hn.c` 行1215 - hn_suspend_mgmt(sc) (VF_UP 時)
- E-07: `sys/dev/hyperv/netvsc/if_hn.c` 行1216-1217 - LINKUP/NETCHG フラグクリア
- E-08: `sys/dev/hyperv/netvsc/if_hn.c` 行1218 - if_link_state_change(LINK_STATE_DOWN) (VF_UP 時)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知は devctl_notify("HYPERV_NIC_VF", if_name, "VF_UP"/"VF_DOWN", NULL) | E-01 | ○ |
| C-02 | VF データパスと合成 NW の切り替えがトリガー | E-02 | ○ |
| C-03 | hn_rxvf_set() で VF インターフェースを設定 | E-03 | ○ |
| C-04 | rxvf フラグで VF_UP/VF_DOWN が決定される | E-04 | ○ |
| C-05 | VF_UP 時に RSS 設定が修正される | E-05 | ○ |
| C-06 | VF_UP 時に管理タスクが中断される | E-06 | ○ |
| C-07 | VF_UP 時に LINKUP/NETCHG フラグがクリアされる | E-07 | ○ |
| C-08 | VF_UP 時にリンク状態が DOWN に変更される | E-08 | ○ |
| C-09 | data は NULL | E-01 | ○ |
| C-10 | subsystem は if_name(hn_ifp) | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] devctl_notify の引数がソースコードと一致しているか
- [ ] VF_UP/VF_DOWN の切り替えロジックが正しいか
- [ ] VF_UP 時のリンク状態変更の記述が正しいか
