---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-AmigaOne電源ボタン通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が存在する

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/powerpc/amigaone/platform_amigaone.c` 行96 - devctl_notify("AEON", "power", "press", NULL)
- E-02: `sys/powerpc/amigaone/platform_amigaone.c` 行93-97 - aeon_pbutton_intr() 関数定義
- E-03: `sys/powerpc/amigaone/platform_amigaone.c` 行60 - static bool is_aeon
- E-04: `sys/powerpc/amigaone/platform_amigaone.c` 行87 - is_aeon = true
- E-05: `sys/powerpc/amigaone/platform_amigaone.c` 行111 - irq = 4
- E-06: `sys/powerpc/amigaone/platform_amigaone.c` 行115 - INTR_TRIGGER_EDGE, INTR_POLARITY_LOW
- E-07: `sys/powerpc/amigaone/platform_amigaone.c` 行116-117 - powerpc_setup_intr("power_button", ...)
- E-08: `sys/powerpc/amigaone/platform_amigaone.c` 行70-72 - model プロパティの "varisys," プレフィックスチェック
- E-09: `sys/powerpc/amigaone/platform_amigaone.c` 行56 - DEFINE_CLASS_1(aeon, ..., mpc85xx_platform)
- E-10: `sys/powerpc/amigaone/platform_amigaone.c` 行120 - SYSINIT(aeon_setup_intr, SI_SUB_CONFIGURE, SI_ORDER_ANY, ...)
- E-11: `sys/powerpc/amigaone/platform_amigaone.c` 行92 - コメント "Notify devd(8) that the power button was pressed"

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知は devctl_notify("AEON", "power", "press", NULL) として発行される | E-01 | ○ |
| C-02 | aeon_pbutton_intr() が割り込みハンドラ | E-02 | ○ |
| C-03 | is_aeon グローバルフラグでプラットフォームを判定 | E-03, E-04 | ○ |
| C-04 | IRQ#4 が電源ボタンの割り込み | E-05 | ○ |
| C-05 | エッジトリガー、ロウアクティブに設定 | E-06 | ○ |
| C-06 | "power_button" という名前で割り込みハンドラが登録される | E-07 | ○ |
| C-07 | model プロパティが "varisys," で始まるプラットフォームで有効 | E-08 | ○ |
| C-08 | mpc85xx_platform を継承している | E-09 | ○ |
| C-09 | SYSINIT で SI_SUB_CONFIGURE / SI_ORDER_ANY で登録 | E-10 | ○ |
| C-10 | data は NULL | E-01 | ○ |
| C-11 | devd(8) への通知が目的であることがコメントに明記 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠がある。コードも短く、全体を網羅的に確認済み。

## 6) レビュアーチェックリスト（最小）
- [ ] devctl_notify の引数がソースコードと一致しているか
- [ ] IRQ#4 の割り込み設定（エッジトリガー、ロウアクティブ）が正しいか
- [ ] プラットフォーム検出ロジック（"varisys," プレフィックス）が正しいか
