---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 9
  claims_with_evidence: 9
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-disk属性変更

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：9 / 9、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/geom/geom_disk.c` 行1006-1019（disk_attr_changed関数）
- E-02: `sys/geom/geom_disk.c` 行1018（devctl_notify呼出）
- E-03: `sys/geom/geom_disk.c` 行1016-1017（snprintf devnamebuf）
- E-04: `sys/geom/geom_disk.c` 行1012-1013（gp == NULL判定）
- E-05: `sys/geom/geom_disk.c` 行1014-1015（g_attr_changed呼出ループ）
- E-06: `sys/geom/geom_dev.c` 行303-316（g_dev_attrchanged関数）
- E-07: `sys/geom/geom_disk.c` 行1010（devnamebuf[128]）
- E-08: `sys/geom/geom_disk.c` 行1008（gp = dp->d_geom）
- E-09: `sys/geom/geom_disk.c` 行64-73（g_disk_softc構造体）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | disk_attr_changed()でGEOM disk属性通知が発行される | E-01, E-02 | ○ |
| C-02 | 通知データは「devname=デバイス名」形式 | E-03 | ○ |
| C-03 | gp == NULLの場合は通知が発行されない | E-04 | ○ |
| C-04 | g_attr_changed()でプロバイダに属性変更が伝播される | E-05 | ○ |
| C-05 | DEVクラスのg_dev_attrchanged()にも伝播される | E-06 | ○ |
| C-06 | devnamebufのサイズは128バイト | E-07 | ○ |
| C-07 | ジオメトリはdp->d_geomから取得される | E-08 | ○ |
| C-08 | subsystemが"disk"（"DEV"ではない） | E-02 | ○ |
| C-09 | 属性名がtypeとしてそのまま使用される | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] disk_attr_changed()の処理フローが正確か確認
- [ ] subsystemが"disk"であることを確認（"DEV"と混同しないこと）
- [ ] g_attr_changed()経由のGEOM伝播パスを確認
