---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-CDEV_MEDIACHANGE

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/geom/geom_dev.c` 行283-301（g_dev_set_media関数）
- E-02: `sys/geom/geom_dev.c` 行293（devctl_notify DEVFS CDEV MEDIACHANGE呼出）
- E-03: `sys/geom/geom_dev.c` 行294（devctl_notify GEOM DEV MEDIACHANGE呼出）
- E-04: `sys/geom/geom_dev.c` 行292（snprintf buf構築）
- E-05: `sys/geom/geom_dev.c` 行295-300（エイリアスデバイスの処理）
- E-06: `sys/geom/geom_dev.c` 行298（エイリアスのDEVFS通知）
- E-07: `sys/geom/geom_dev.c` 行303-316（g_dev_attrchanged関数）
- E-08: `sys/geom/geom_dev.c` 行60-70（g_dev_softc構造体）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | g_dev_set_media()でDEVFS CDEV MEDIACHANGE通知が発行される | E-01, E-02 | ○ |
| C-02 | GEOM DEV MEDIACHANGEとペアで発行される | E-02, E-03 | ○ |
| C-03 | DEVFS通知がGEOM通知の前に発行される | E-02, E-03 | ○ |
| C-04 | 通知データは「cdev=デバイス名」形式 | E-04 | ○ |
| C-05 | エイリアスデバイスにも通知が発行される | E-05, E-06 | ○ |
| C-06 | GEOM::media属性変更がトリガー | E-07 | ○ |
| C-07 | sc_devとsc_aliasの両方を参照する | E-08 | ○ |
| C-08 | g_dev_set_media()はvoid関数 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] DEVFS通知とGEOM通知の発行順序が正確か確認
- [ ] No.3（GEOM DEV MEDIACHANGE）との関連性を確認
