---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 26
  claims_without_evidence: 4
confidence_derived: 0.87
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：26 / 30、根拠なし：4
- 優先レビュー（高）
  1. **最小メモリ要件の記載（96MB以上）**：根拠不足 -- ソースコード内に明示的なメモリ要件の記載が確認できなかった
  2. **ブートローダ起動手順の詳細**：根拠不足 -- bsdinstallの外部（standディレクトリ）の仕様であり、画面設計書の対象外
  3. **ドキュメントインストール先パス**：根拠不足 -- `/usr/local/share/doc/freebsd/` パスは一般的な知識に基づく推定
  4. **USB/キーボード関連のトラブルシューティング**：根拠不足 -- xhci_stream_disable等の設定は一般的なFreeBSD知識に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv` -- 33画面の一覧定義
- E-02: `docs/code-to-docs/画面一覧/画面遷移図.md` -- メインフロー・サブフローの遷移定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` -- 画面と機能の対応関係
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` -- 110機能の一覧定義
- E-05: `docs/code-to-docs/画面設計書/1-キーマップ選択画面.md` -- キーマップ選択画面の詳細仕様
- E-06: `docs/code-to-docs/画面設計書/2-ホスト名設定画面.md` -- ホスト名設定画面の詳細仕様
- E-07: `docs/code-to-docs/画面設計書/3-インストール種別選択画面.md` -- インストール種別選択の仕様
- E-08: `docs/code-to-docs/画面設計書/15-パーティションモード選択画面.md` -- パーティションモード選択の仕様
- E-09: `docs/code-to-docs/画面設計書/16-ZFSブート設定画面.md` -- ZFSブート設定の仕様
- E-10: `docs/code-to-docs/画面設計書/30-最終設定メニュー画面.md` -- 最終設定メニューの仕様
- E-11: `docs/code-to-docs/画面設計書/21-rootパスワード設定画面.md` -- rootパスワード設定の仕様
- E-12: `docs/code-to-docs/画面設計書/25-サービス選択画面.md` -- サービス選択の仕様
- E-13: `docs/code-to-docs/画面設計書/26-セキュリティ強化設定画面.md` -- セキュリティ強化設定の仕様
- E-14: `docs/code-to-docs/画面設計書/29-ユーザ追加画面.md` -- ユーザ追加画面の仕様
- E-15: `docs/code-to-docs/画面設計書/33-インストール中断エラー画面.md` -- エラー画面の仕様
- E-16: `docs/code-to-docs/README.md` -- プロジェクト概要（FreeBSD Source Tree）
- E-17: `docs/code-to-docs/画面設計書/7-無線LAN設定画面.md` -- 無線LAN設定の仕様
- E-18: `docs/code-to-docs/画面設計書/8-IPv4設定確認画面.md` -- IPv4設定の仕様
- E-19: `docs/code-to-docs/画面設計書/12-DNS設定画面.md` -- DNS設定の仕様
- E-20: `docs/code-to-docs/画面設計書/22-タイムゾーン選択画面.md` -- タイムゾーン設定の仕様
- E-21: `docs/code-to-docs/画面設計書/27-ファームウェアインストール画面.md` -- ファームウェアインストールの仕様
- E-22: `docs/code-to-docs/画面設計書/31-ドキュメントインストール画面.md` -- ドキュメントインストールの仕様
- E-23: `docs/code-to-docs/画面設計書/13-ミラーサイト選択画面.md` -- ミラーサイト選択の仕様

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bsdinstallはFreeBSDの公式インストーラであり、TUIベースでbsddialogを使用 | E-01, E-05, E-16 | ○ |
| C-02 | インストーラは33画面で構成される | E-01 | ○ |
| C-03 | キーマップ選択画面はインストーラ起動後最初に表示される | E-05, E-02 | ○ |
| C-04 | キーマップ選択画面ではテスト入力が可能 | E-05 | ○ |
| C-05 | BSDINSTALL_SKIP_KEYMAPでキーマップ選択をスキップ可能 | E-01, E-05 | ○ |
| C-06 | ホスト名はrc.confに保存される | E-01, E-06 | ○ |
| C-07 | インストール種別としてDistribution SetsとPackages(pkgbase)が選択可能 | E-01, E-07 | ○ |
| C-08 | MANIFESTファイルが存在しない場合は自動的にpkgbaseが選択される | E-01 | ○ |
| C-09 | 配布セット選択画面ではMANIFESTファイルからオプション一覧が生成される | E-01, E-03 | ○ |
| C-10 | ネットワーク設定は無線・有線インターフェースを自動検出する | E-01, E-03 | ○ |
| C-11 | 無線LAN設定ではWPA-PSK/WPA-EAP/WEP/Openに対応 | E-17, E-01 | ○ |
| C-12 | IPv4設定ではDHCPまたはスタティック設定が可能 | E-18, E-02 | ○ |
| C-13 | DNS設定はresolv.confに保存される | E-19 | ○ |
| C-14 | パーティションモードはAuto(ZFS)/Auto(UFS)/Manual/Shellの4種類 | E-08, E-01 | ○ |
| C-15 | ZFSオプションはamd64/arm64/i386/riscvアーキテクチャでのみ表示 | E-08 | ○ |
| C-16 | ZFSブート設定でstripe/mirror/raid-z1/raid-z2/raid-z3が選択可能 | E-09 | ○ |
| C-17 | 配布ファイルダウンロードはlibfetchを使用 | E-03 | ○ |
| C-18 | チェックサム検証はSHA256を使用 | E-01 | ○ |
| C-19 | 配布ファイル展開はlibarchiveを使用 | E-03 | ○ |
| C-20 | rootパスワード設定はpwコマンドで実行される | E-03 | ○ |
| C-21 | サービス選択ではsshd/ntpd/powerd等が選択可能 | E-12, E-03 | ○ |
| C-22 | セキュリティ強化設定はsysctl.conf/rc.conf/loader.confに保存される | E-13 | ○ |
| C-23 | ファームウェアインストールはfwgetとpkgを使用 | E-21, E-03 | ○ |
| C-24 | ユーザ追加はadduserコマンドをchroot環境で実行 | E-14, E-01 | ○ |
| C-25 | 最終設定メニューは10個のメニュー項目を持つ | E-10 | ○ |
| C-26 | Lenovo ThinkPad/Dell Latitude等でハードウェア互換性ワークアラウンドがある | E-08 | ○ |
| C-27 | 最小メモリ要件は96MB以上 | **根拠なし** | △ |
| C-28 | ブートローダ起動時の詳細手順 | **根拠なし** | △ |
| C-29 | ドキュメントインストール先パスが/usr/local/share/doc/freebsd/ | **根拠なし** | △ |
| C-30 | hw.usb.xhci.xhci_stream_disable設定によるキーボード問題の解決 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-27: メモリ要件の記載はbsdinstallのソースコードおよび既存設計書に明示的な定義が見つからなかった
  - 候補：FreeBSD Handbook / リリースノート / HARDWARE.md
- C-28: ブートローダの詳細仕様はstandディレクトリ配下のソースに存在するが、画面設計書の対象外
  - 候補：stand/efi/ / stand/i386/ / FreeBSD Handbook
- C-29: ドキュメントのインストール先パスはpkgパッケージの構成に依存する
  - 候補：docsinstallスクリプトの実装 / pkg-plistファイル
- C-30: USBキーボード問題のトラブルシューティングは一般的なFreeBSD運用知識に基づく推定
  - 候補：FreeBSD Handbook / FreeBSDフォーラム / kern.evdev関連のドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 主要な画面操作手順（C-01〜C-26）は画面設計書・画面一覧・機能一覧・画面遷移図に基づいており信頼性が高い
- 1: 中リスク -- トラブルシューティング節（C-28, C-30）は一般的な知識に基づく記載であり、特定バージョンのFreeBSDでは異なる可能性がある
- 1: 中リスク -- メモリ要件（C-27）およびドキュメントパス（C-29）は実環境での検証が望ましい
- 0: 低リスク -- テンプレートのSTEP形式をbsdinstallのインストールフローに適応した構成は、画面遷移図（E-02）と整合性がある

## 6) レビュアーチェックリスト（最小）
- [ ] 画面遷移図（E-02）と運用マニュアルのSTEP構成が一致しているか確認
- [ ] 各画面の操作手順が画面設計書の入出力項目と整合しているか確認
- [ ] 環境変数によるスキップオプション一覧が画面一覧のCSVデータと一致しているか確認
- [ ] トラブルシューティング節の内容がFreeBSD最新バージョンで有効か確認
- [ ] メモリ要件（C-27）を実環境またはFreeBSD公式ドキュメントで検証
- [ ] ドキュメントインストール先パス（C-29）をdocsinstallスクリプトで検証
