# FreeBSD bsdinstall インストーラ 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [インストーラの起動](#2-インストーラの起動)
3. [初期設定画面（キーマップ・ホスト名）](#3-初期設定画面キーマップホスト名)

**【業務フローに沿った機能】**
4. [【STEP1】インストール方式の選択（種別・配布セット・ミラー）](#4-step1インストール方式の選択種別配布セットミラー)
5. [【STEP2-3】ネットワーク設定（接続の構成）](#5-step2-3ネットワーク設定接続の構成)
6. [【STEP3-4】ディスクパーティション設定（ストレージの準備）](#6-step3-4ディスクパーティション設定ストレージの準備)
7. [【STEP4-5】インストール実行・システム設定（管理者設定）](#7-step4-5インストール実行システム設定管理者設定)

**【サポート機能】**
8. [ユーザ管理機能](#8-ユーザ管理機能)
9. [最終設定メニュー](#9-最終設定メニュー)
10. [ドキュメントインストール](#10-ドキュメントインストール)

**【運用ガイド】**
11. [日常業務の流れ（インストール全体フロー）](#11-日常業務の流れインストール全体フロー)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 bsdinstallとは

bsdinstallは、FreeBSDオペレーティングシステムの公式インストーラです。テキストユーザインターフェース（TUI）を採用しており、bsddialogライブラリによるメニュー・ダイアログ形式で操作します。FreeBSDのインストールメディア（USB、CD/DVD、ネットワーク）から起動し、OSのインストールからシステムの初期設定までを一貫して行うことができます。

bsdinstallは以下の特徴を持ちます:
- TUI（テキストベースのユーザインターフェース）による対話的な操作
- シェルスクリプトとC言語による実装（拡張性が高い）
- 環境変数によるカスタマイズ・自動化対応
- amd64、arm64、i386、riscv等の複数アーキテクチャに対応

### 1.2 本システムで行う主要業務

本インストーラは、主に以下の業務を支援します:

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **初期設定** | キーマップ選択、ホスト名設定 |
| **インストール方式選択** | Distribution Sets/Packages(pkgbase)の選択、配布セット選択、ミラーサイト選択 |
| **ネットワーク構成** | インターフェース選択、無線LAN設定、IPv4/IPv6設定、DNS設定 |
| **ストレージ構成** | パーティションモード選択（ZFS/UFS/手動/シェル）、ZFSプール設定、手動パーティション編集 |
| **システム基盤設定** | rootパスワード設定、タイムゾーン・日時設定、サービス選択、セキュリティ強化、ファームウェア導入 |
| **ユーザ管理** | ユーザアカウント追加 |

### 1.3 業務フロー概要

本インストーラにおけるインストール作業は、以下の流れで進行します:

```
+------------------------------------------------------------------+
|                    インストール業務フロー                            |
+------------------------------------------------------------------+
|                                                                    |
|  【STEP 1】初期設定とインストール方式の選択                          |
|    キーマップ選択 → ホスト名設定 → インストール種別選択               |
|    → 配布セット選択 / ミラーサイト選択                               |
|      ↓                                                            |
|  【STEP 2】ネットワーク設定                                        |
|    インターフェース選択 → 無線LAN設定(該当時)                        |
|    → IPv4/IPv6設定 → DNS設定                                      |
|      ↓                                                            |
|  【STEP 3】ディスクパーティション設定                                |
|    パーティションモード選択 → ZFS/UFS/手動設定                       |
|      ↓                                                            |
|  【STEP 4】インストール実行                                        |
|    配布ファイルダウンロード → チェックサム検証 → ファイル展開          |
|      ↓                                                            |
|  【STEP 5】システム設定・最終確認                                   |
|    rootパスワード → タイムゾーン → サービス → セキュリティ            |
|    → ファームウェア → ユーザ追加 → 最終設定メニュー → 完了           |
|                                                                    |
+------------------------------------------------------------------+
```

**役割別の業務概要:**

| 役割 | 主な業務 |
|------|---------|
| **システム管理者** | FreeBSDのインストール全工程の実施、ディスク構成の決定、ネットワーク設定、セキュリティポリシーの適用、初期ユーザアカウントの作成 |
| **上級ユーザ** | 手動パーティション設定、ZFS高度設定、シェルによるカスタム設定 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| キーマップ選択 | キーボードレイアウトの選択・テスト入力 | STEP 1 |
| ホスト名設定 | マシンのホスト名を入力 | STEP 1 |
| インストール種別選択 | Distribution Sets/Packages(pkgbase)の選択 | STEP 1 |
| 配布セット選択 | オプション配布セットの選択 | STEP 1 |
| ミラーサイト選択 | ダウンロード先ミラーの選択 | STEP 1 |
| ネットワーク設定 | インターフェース・IP・DNS設定 | STEP 2 |
| パーティション設定 | ディスクパーティションの構成 | STEP 3 |
| インストール実行 | 配布ファイルのダウンロード・検証・展開 | STEP 4 |
| システム設定 | rootパスワード・タイムゾーン・サービス・セキュリティ | STEP 5 |
| ユーザ管理 | ユーザアカウントの追加 | STEP 5 |
| 最終設定メニュー | 全設定の再確認・変更 | STEP 5 |

### 1.5 ユーザー種別

bsdinstallは以下のユーザー種別を想定しています:

| ユーザー種別 | 説明 |
|-------------|------|
| システム管理者 | FreeBSDのインストールを実施する管理者。全画面・全機能へのアクセス権限を持つ |
| 上級ユーザ | 手動パーティション設定やシェルによるカスタム設定を行うユーザ |
| 一般ユーザ | Auto(ZFS)やAuto(UFS)による自動設定でインストールを行うユーザ |

> **注意**: bsdinstallはインストーラコンテキストでroot権限で実行されるため、画面上の権限による表示制御はありません。ただし、アーキテクチャによってZFSオプションの表示有無が変わります。

### 1.6 対応環境

bsdinstallは以下の環境で動作します:
- **対応アーキテクチャ**: amd64、arm64、i386、riscv、powerpc
- **起動メディア**: USB、CD/DVD、ネットワークブート（PXE）
- **インターフェース**: TUI（テキストユーザインターフェース）-- bsddialogベース
- **最小メモリ要件**: 96MB以上（推奨512MB以上）

---

## 2. インストーラの起動

### 2.1 起動方法

1. FreeBSDのインストールメディア（USB/CD/DVD）をマシンに接続します
2. マシンを起動し、ブートメニューからインストールメディアを選択します
3. FreeBSDブートローダが表示されます
4. ブートローダのメニューから「Install」を選択するか、自動的にbsdinstallが起動します
5. 最初の画面として「キーマップ選択画面」が表示されます

### 2.2 自動化オプション

以下の環境変数を設定することで、特定の画面をスキップできます:

| 環境変数 | 効果 |
|---------|------|
| `BSDINSTALL_SKIP_KEYMAP` | キーマップ選択画面をスキップ |
| `BSDINSTALL_SKIP_HOSTNAME` | ホスト名設定画面をスキップ |
| `BSDINSTALL_SKIP_SERVICES` | サービス選択画面をスキップ |
| `BSDINSTALL_SKIP_HARDENING` | セキュリティ強化設定画面をスキップ |
| `BSDINSTALL_SKIP_FIRMWARE` | ファームウェアインストール画面をスキップ |
| `BSDINSTALL_SKIP_USERS` | ユーザ追加確認画面をスキップ |
| `BSDINSTALL_SKIP_FINALCONFIG` | 最終設定メニュー画面をスキップ |
| `BSDINSTALL_SKIP_MANUAL` | 手動設定確認画面をスキップ |

### 2.3 インストーラの終了

インストーラを終了するには、以下のいずれかの方法を使用します:
1. 最終設定メニュー画面で「Finish」を選択し、手動設定確認画面を経て完了
2. 各画面で「Cancel」ボタンを押下してインストーラを中断
3. エラー発生時にインストール中断エラー画面で「Exit」を選択

---

## 3. 初期設定画面（キーマップ・ホスト名）

### 3.1 キーマップ選択画面

> **業務シーン**: インストール開始時に、使用するキーボードのレイアウトを選択します。USキーボード以外を使用する場合は、正しいキーマップを選択しないと後続の入力操作で意図しない文字が入力されます。

**操作手順:**

1. インストーラが起動すると「Keymap Selection」画面が表示されます
2. 利用可能なキーマップがメニュー形式で一覧表示されます
3. 使用するキーボードのレイアウトを選択します（上下キーで移動、Enterで選択）
4. 選択したキーマップを確認するために「Test keymap」を選択できます
   - テスト入力用のダイアログが表示されます
   - 実際にキーを押して、正しい文字が入力されるか確認します
5. 正しいキーマップであることを確認したら「Continue with keymap」を選択します

**注意点:**
- USキーボードを使用している場合はデフォルトのまま「Continue with keymap」を選択できます
- キーマップの設定は`rc.conf.keymap`ファイルに保存され、`kbdcontrol`コマンドで適用されます
- 「Cancel」を押した場合、キーマップ設定ファイルが削除され、インストーラが再起動されます

### 3.2 ホスト名設定画面

> **業務シーン**: インストール先マシンのネットワーク上でのホスト名を設定します。

**操作手順:**

1. キーマップ選択完了後、「Set Hostname」画面が表示されます
2. テキスト入力フィールドにホスト名を入力します
   - 例: `myserver.example.com` または `myserver`
3. 「OK」ボタンを押して確定します

**注意点:**
- ホスト名は `rc.conf` の `hostname` パラメータに保存されます
- FQDN（完全修飾ドメイン名）形式での入力を推奨します
- 環境変数 `BSDINSTALL_SKIP_HOSTNAME` が設定されている場合はこの画面はスキップされます

---

## 4. 【STEP1】インストール方式の選択（種別・配布セット・ミラー）

> **業務フローでの位置**: インストーラの最初の重要なステップとして、どのようなインストール方式を使用するかを決定します。

### 4.1 インストール種別選択画面

> **業務シーン**: FreeBSDのインストール方式として、従来のDistribution Sets方式かPackages(pkgbase)方式かを選択します。

**操作手順:**

1. ホスト名設定後、「インストール種別選択画面」が表示されます
2. 以下の選択肢から選びます:
   - **Distribution Sets**: 従来のtarball方式でインストール（base.txz, kernel.txz等）
   - **Packages (pkgbase)**: パッケージベースのインストール方式
3. 選択肢をハイライトして「OK」を押します

**注意点:**
- MANIFESTファイルが存在しない場合は自動的にpkgbaseが選択されます
- pkgbaseを選択した場合、次にネットワーク/オフラインインストールの選択画面が表示されます

### 4.2 ネットワーク/オフラインインストール選択画面

> **業務シーン**: pkgbase方式を選択した場合に、ネットワーク経由でパッケージをダウンロードするか、ローカルのパッケージを使用するかを選択します。

**操作手順:**

1. pkgbase選択後、「ネットワーク/オフラインインストール選択画面」が表示されます
2. 以下から選択します:
   - **Network**: ネットワーク経由でパッケージをダウンロードしてインストール
   - **Offline**: ローカルのパッケージを使用してインストール
3. 「OK」を押して確定します

**注意点:**
- この画面はローカルパッケージが利用可能な場合のみ表示されます
- 「Network」を選択した場合、後続でネットワーク設定画面に遷移します

### 4.3 配布セット選択画面

> **業務シーン**: Distribution Sets方式を選択した場合に、base.txz・kernel.txz以外のオプション配布セットを選択します。

**操作手順:**

1. Distribution Sets選択後、「配布セット選択画面」が表示されます
2. チェックリスト形式でオプション配布セットが表示されます
3. インストールしたいセットにチェックを入れます（スペースキーで切替）
   - 例: `lib32.txz`（32ビットライブラリ）、`ports.txz`（Portsコレクション）、`src.txz`（ソースコード）
4. 「OK」を押して確定します

**注意点:**
- `base.txz` と `kernel.txz` は必須で、選択解除できません
- MANIFESTファイルからオプション一覧が生成されます

### 4.4 ミラーサイト選択画面

> **業務シーン**: 配布ファイルをダウンロードするためのミラーサイトを選択します。

**操作手順:**

1. 配布ファイルのネットワークダウンロードが必要な場合、「ミラーサイト選択画面」が表示されます
2. 世界各国のミラーサイトがメニュー形式で一覧表示されます
3. 最寄りのミラーサイトを選択します
4. 「Other」を選択するとカスタムURLを入力できます
5. 「OK」を押して確定します

**注意点:**
- 地理的に近いミラーサイトを選択するとダウンロード速度が向上します
- 「Other」選択時はカスタムミラーURL入力画面でURLを直接入力できます（デフォルトURLがプリセットされています）

---

## 5. 【STEP2-3】ネットワーク設定（接続の構成）

> **業務フローでの位置**: ネットワーク経由のインストールやシステムのネットワーク接続に必要な設定を行うステップです。インストール種別によっては配布セット選択後に表示されます。

### 5.1 ネットワークインターフェース選択画面

> **業務シーン**: システムで利用するネットワークインターフェースを選択し、設定モードを決定します。

**操作手順:**

1. 利用可能なネットワークインターフェースが一覧表示されます（無線・有線を自動検出）
2. 使用するインターフェースを選択します
3. Auto（自動設定）またはManual（手動設定）を選択します
4. 「OK」を押して確定します

### 5.2 無線LAN設定画面

> **業務シーン**: 無線LANインターフェースを選択した場合に、無線ネットワークの接続設定を行います。

**操作手順:**

1. 無線インターフェース選択後、「無線LAN設定画面」が表示されます
2. 利用可能な無線ネットワークがスキャンされ、一覧表示されます
3. 接続先のSSIDを選択します
4. 認証方式を選択します:
   - **WPA-PSK**: パスワード認証（一般的な家庭・小規模ネットワーク向け）
   - **WPA-EAP**: 企業向け認証
   - **WEP**: 旧式の暗号化（非推奨）
   - **Open**: 暗号化なし
5. パスワード等の認証情報を入力します
6. 必要に応じてリージョン/国コードを設定します
7. 「OK」を押して接続します

**注意点:**
- wpa_supplicantを使用して接続を管理します
- 利用可能なネットワークが見つからない場合は、SSIDを手動入力できます

### 5.3 IPv4設定

> **業務シーン**: IPv4ネットワークの設定を行います。

**操作手順:**

1. 「IPv4設定確認画面」で「Yes」（IPv4を使用する）を選択します
2. DHCP使用の確認画面が表示されます:
   - **DHCP（自動取得）**: 「Yes」を選択するとIPアドレスが自動取得されます
   - **スタティック（手動設定）**: 「No」を選択すると手動設定画面に遷移します
3. スタティック設定の場合、以下の情報を入力します:

| 項目 | 入力内容 | 例 |
|------|---------|-----|
| IPアドレス | マシンのIPアドレス | 192.168.1.100 |
| サブネットマスク | ネットワークのサブネットマスク | 255.255.255.0 |
| デフォルトルータ | デフォルトゲートウェイのIPアドレス | 192.168.1.1 |

4. 「OK」を押して確定します

**注意点:**
- Autoモード時はDHCPが自動選択されます
- DHCPサーバが見つからない場合はエラーが表示されます

### 5.4 IPv6設定

> **業務シーン**: IPv6ネットワークの設定を行います。

**操作手順:**

1. 「IPv6設定確認画面」で「Yes」（IPv6を使用する）を選択します
2. SLAAC使用の確認画面が表示されます:
   - **SLAAC（自動構成）**: 「Yes」を選択するとアドレスが自動構成されます
   - **スタティック（手動設定）**: 「No」を選択すると手動設定画面に遷移します
3. スタティック設定の場合、以下の情報を入力します:

| 項目 | 入力内容 | 例 |
|------|---------|-----|
| IPv6アドレス | マシンのIPv6アドレス | 2001:db8::100/64 |
| デフォルトルータ | デフォルトゲートウェイのIPv6アドレス | 2001:db8::1 |

4. 「OK」を押して確定します

### 5.5 DNS設定画面

> **業務シーン**: DNSサーバとサーチドメインの設定を行います。

**操作手順:**

1. 「DNS設定画面」が表示されます
2. 以下の情報を入力します:

| 項目 | 入力内容 | 例 |
|------|---------|-----|
| サーチドメイン | DNSサーチドメイン | example.com |
| IPv4ネームサーバ | IPv4 DNSサーバのアドレス | 8.8.8.8 |
| IPv6ネームサーバ | IPv6 DNSサーバのアドレス | 2001:4860:4860::8888 |

3. 「OK」を押して確定します

**注意点:**
- 設定内容は `resolv.conf` に保存されます
- Autoモードかつネームサーバが既にDHCP/SLAACで取得されている場合、この画面は省略されます

---

## 6. 【STEP3-4】ディスクパーティション設定（ストレージの準備）

> **業務フローでの位置**: インストール先ディスクのパーティション構成を決定するステップです。システムの基盤となる重要な設定です。

### 6.1 パーティションモード選択画面

> **業務シーン**: ディスクパーティションの設定方式を選択します。

**操作手順:**

1. 「Partitioning」画面が表示されます
2. 以下のモードから選択します:

| モード | 説明 | 推奨ユーザ |
|--------|------|-----------|
| **Auto (ZFS)** | ZFSファイルシステムによる自動パーティション | 一般ユーザ（推奨） |
| **Auto (UFS)** | UFSファイルシステムによる自動パーティション | 伝統的な構成を好むユーザ |
| **Manual** | 手動でパーティションを作成・編集 | 上級ユーザ |
| **Shell** | シェルを起動して完全手動でパーティション設定 | エキスパートユーザ |

3. モードを選択して「OK」を押します

**注意点:**
- ZFSオプションはamd64、arm64、i386、riscvアーキテクチャでのみ表示されます
- 一部のハードウェア（Lenovo ThinkPad、Dell Latitude等）では互換性問題のワークアラウンドが自動的に確認されます

### 6.2 ZFSブート設定画面

> **業務シーン**: Auto(ZFS)を選択した場合に、ZFSプールの詳細設定を行います。

**操作手順:**

1. 「ZFS Configuration」画面が表示されます
2. 以下の項目を設定します:

| 設定項目 | 説明 | 初期値 |
|---------|------|--------|
| プール名 | ZFSプールの名前 | zroot |
| vdevタイプ | RAID構成の種類 | stripe |
| 暗号化 | GELI暗号化の有無 | 無効 |
| スワップサイズ | スワップ領域のサイズ | 2G |
| ディスク選択 | 使用するディスクの選択 | -- |

3. vdevタイプは以下から選択できます:
   - **stripe**: 単一ディスクまたはストライピング
   - **mirror**: ミラーリング（2台以上のディスク必要）
   - **raid-z1**: RAID-Z1（3台以上のディスク必要）
   - **raid-z2**: RAID-Z2（4台以上のディスク必要）
   - **raid-z3**: RAID-Z3（5台以上のディスク必要）

4. 使用するディスクを選択します
5. 設定を確認して「Install」を選択します

**注意点:**
- 暗号化を有効にするとGELI暗号化が使用されます。パスフレーズの入力が必要です
- ディスク上のデータはすべて消去されます。必ず事前にバックアップを取ってください

### 6.3 手動パーティション編集画面

> **業務シーン**: 手動でディスクパーティションを作成・編集します。上級ユーザ向けの機能です。

**操作手順:**

1. 「Manual」モード選択後、GEOMベースのパーティションエディタが表示されます
2. 利用可能なディスクとパーティションが一覧表示されます
3. 以下の操作が可能です:
   - **Create**: 新しいパーティションを作成
   - **Delete**: 既存のパーティションを削除
   - **Modify**: パーティションのサイズやマウントポイントを変更
   - **Revert**: 変更を元に戻す
4. 必要なパーティション（最低限 `/`、推奨で `/boot`、`swap`）を作成します
5. 設定が完了したら「Finish」を選択します

**注意点:**
- この画面はbsddialogを使用したC言語実装です
- UFSまたはZFSパーティションを作成できます
- マウントポイントの設定を忘れないようにしてください

---

## 7. 【STEP4-5】インストール実行・システム設定（管理者設定）

> **業務フローでの位置**: パーティション設定完了後、実際のインストールを実行し、システムの基本設定を行うステップです。

### 7.1 配布ファイルのダウンロード・検証・展開

> **業務シーン**: FreeBSDの配布ファイルをダウンロードし、整合性を検証した後、インストール先に展開します。

**操作手順:**

1. **配布ファイルダウンロード画面**: ネットワークから配布ファイルをダウンロードする進捗がプログレスバーで表示されます（libfetchを使用）
2. **チェックサム検証画面**: ダウンロードされた配布ファイルのSHA256チェックサムが自動検証されます
3. **配布ファイル展開画面**: 検証済みの配布ファイルがインストール先に展開されます（libarchiveを使用）。プログレスバーで進捗が表示されます

**注意点:**
- これらの画面は自動的に進行します。操作は不要です
- ダウンロードやチェックサム検証でエラーが発生した場合は、エラーダイアログが表示されます
- ネットワーク速度によりダウンロード時間が大きく異なります

### 7.2 rootパスワード設定画面

> **業務シーン**: システム管理者（root）アカウントのパスワードを設定します。

**操作手順:**

1. 「Root Password」画面が表示されます
2. 新しいパスワードを入力します
3. 確認のためもう一度同じパスワードを入力します
4. 「OK」を押して確定します

**注意点:**
- 「Skip」ボタンでパスワード設定をスキップできますが、セキュリティ上推奨されません
- パスワードはpwコマンドにより設定されます
- 十分な強度のパスワードを設定してください

### 7.3 タイムゾーン・日時設定

> **業務シーン**: システムのタイムゾーンと日時を正しく設定します。

**操作手順:**

1. **タイムゾーン選択画面**: tzsetupを使用してタイムゾーンを選択します
   - 大陸/地域 → 国 → タイムゾーンの順に選択します
   - 例: Asia → Japan
2. **日付設定画面**: カレンダーUIで日付を設定します
   - 「Skip」で省略可能です
3. **時刻設定画面**: 時刻を入力して設定します
   - 「Skip」で省略可能です

**注意点:**
- タイムゾーンの設定は `/etc/localtime` に保存されます
- NTPを使用する場合は、日時設定をスキップしてサービス選択でntpdを有効にすることを推奨します

### 7.4 サービス選択画面

> **業務シーン**: システム起動時に自動的に有効にするサービスを選択します。

**操作手順:**

1. 「System Configuration」画面が表示されます
2. チェックリスト形式でサービスが表示されます
3. 有効にするサービスにチェックを入れます（スペースキーで切替）:

| サービス | 説明 | デフォルト |
|---------|------|-----------|
| sshd | SSHリモートアクセスデーモン | ON |
| ntpd | ネットワーク時刻同期デーモン | OFF |
| ntpd_sync_on_start | 起動時のNTP時刻同期 | OFF |
| powerd | CPU電源管理デーモン | OFF |
| dumpdev | コアダンプデバイス(AUTO) | OFF |

4. 「OK」を押して確定します

**注意点:**
- 設定は `rc.conf` に保存されます
- sshdを有効にするとリモートからSSHでログインできるようになります
- サーバ用途の場合はsshdとntpdの有効化を推奨します

### 7.5 セキュリティ強化設定画面

> **業務シーン**: システムのセキュリティを強化するためのオプションを選択します。

**操作手順:**

1. 「System Hardening」画面が表示されます
2. チェックリスト形式でセキュリティオプションが表示されます:

| オプション | 説明 |
|-----------|------|
| プロセス隠蔽 | 他ユーザのプロセスを見えなくする |
| PIDランダム化 | プロセスIDをランダム化 |
| /tmp クリア | 起動時に /tmp を自動クリア |
| syslogd制限 | syslogdのネットワーク受信を無効化 |
| DTrace破壊モード無効化 | DTraceの破壊的操作を無効化 |

3. 適用するオプションにチェックを入れます
4. 「OK」を押して確定します

**注意点:**
- 設定は `sysctl.conf`、`rc.conf`、`loader.conf` に分散して保存されます
- セキュリティを重視する環境では全オプションの有効化を推奨します

### 7.6 ファームウェアインストール画面

> **業務シーン**: ハードウェアに必要なファームウェアパッケージを検出しインストールします。

**操作手順:**

1. 「Firmware」画面が表示されます
2. fwgetコマンドにより検出されたファームウェアパッケージがチェックリストで表示されます
3. インストールするファームウェアにチェックを入れます
4. 「OK」を押してインストールを実行します

**注意点:**
- ファームウェアのインストールにはネットワーク接続が必要です
- pkg経由でパッケージがインストールされます
- 主にネットワークデバイスやGPUのファームウェアが対象です

---

## 8. ユーザ管理機能

### 8.1 ユーザ追加確認画面

> **業務シーン**: rootアカウント以外の一般ユーザアカウントを追加するかどうかを確認します。

**操作手順:**

1. 「Add User Accounts」の確認ダイアログが表示されます
2. ユーザを追加する場合は「Yes」、スキップする場合は「No」を選択します

### 8.2 ユーザ追加画面

> **業務シーン**: 一般ユーザアカウントを対話的に作成します。

**操作手順:**

1. 「Yes」を選択すると、adduserコマンドが起動します
2. 以下の情報を対話的に入力します:

| 入力項目 | 説明 | 例 |
|---------|------|-----|
| Username | ログインユーザ名 | john |
| Full name | ユーザのフルネーム | John Smith |
| Uid | ユーザID（空でデフォルト） | （空欄） |
| Login group | プライマリグループ | john |
| Login group is john. Invite john into other groups? | 追加グループ | wheel |
| Login class | ログインクラス | default |
| Shell | デフォルトシェル | /bin/sh |
| Home directory | ホームディレクトリ | /home/john |
| Home directory permissions | ホームディレクトリの権限 | （デフォルト） |
| Use password-based authentication? | パスワード認証使用 | yes |
| Use an empty password? | 空パスワード使用 | no |
| Use a random password? | ランダムパスワード使用 | no |
| Enter password | パスワード | （パスワード入力） |

3. 入力内容を確認し、「yes」で作成を確定します
4. 追加のユーザを作成する場合は繰り返します
5. 作成完了後、「no」で終了します

**注意点:**
- wheelグループに追加すると`su`コマンドでrootになれます
- adduserコマンドはchroot環境内で実行されます
- TUIではなくCLI（コマンドライン）形式の対話入力です

---

## 9. 最終設定メニュー

### 9.1 最終設定メニュー画面

> **業務シーン**: インストール完了前に、これまでの設定を再確認・変更できる統合メニューです。

**操作手順:**

1. 「Final Configuration」画面が表示されます
2. 以下のメニュー項目から選択できます:

| メニュー項目 | 説明 |
|-------------|------|
| **Finish** | 設定を適用してインストーラを終了 |
| **Add User** | ユーザアカウントを追加 |
| **Root Password** | rootパスワードを再設定 |
| **Hostname** | ホスト名を変更 |
| **Network** | ネットワーク設定を変更 |
| **Services** | サービス設定を変更 |
| **System Hardening** | セキュリティ設定を変更 |
| **Time Zone** | タイムゾーン・日時設定を変更 |
| **Firmware** | ファームウェアをインストール |
| **Handbook** | FreeBSDドキュメントをインストール |

3. 変更したい項目を選択すると対応する設定画面に遷移します
4. 設定完了後、自動的にこのメニューに戻ります
5. すべての設定が完了したら「Finish」を選択します

**注意点:**
- 各設定画面で変更を行った後は、必ずこのメニューに戻ります
- 「Finish」選択後に手動設定確認画面が表示されます

### 9.2 手動設定確認画面

> **業務シーン**: インストール完了後にchroot環境でシェルを開いて追加の手動設定を行うかどうかを確認します。

**操作手順:**

1. 「Manual Configuration」の確認ダイアログが表示されます
2. 追加設定が必要な場合は「Yes」を選択するとchroot環境のシェルが起動します
3. シェルで必要な設定を行った後、`exit`コマンドで終了します
4. 「No」を選択するとインストールが完了します

---

## 10. ドキュメントインストール

### 10.1 ドキュメントインストール画面

> **業務シーン**: FreeBSDのHandbook、FAQ、各種記事等のドキュメントをインストールします。

**操作手順:**

1. 最終設定メニューで「Handbook」を選択します
2. インストール可能なドキュメントパッケージが各言語版ごとにチェックリストで表示されます
   - FreeBSD Handbook（英語）
   - FreeBSD Handbook（日本語、中国語等各言語）
   - FreeBSD FAQ
   - FreeBSD Articles
3. インストールするドキュメントにチェックを入れます
4. 「OK」を押してインストールを実行します

**注意点:**
- ドキュメントはpkg経由でインストールされるため、ネットワーク接続が必要です
- インストール後は `/usr/local/share/doc/freebsd/` 等で参照できます

---

## 11. 日常業務の流れ（インストール全体フロー）

本セクションでは、FreeBSDインストール作業の全体的な流れをSTEP形式で説明します。

```
インストール業務フロー概要（再掲）
---------------------------------------------------------------
【STEP 1】初期設定とインストール方式の選択        → 3章, 4章参照
    ↓
【STEP 2】ネットワーク設定                       → 5章参照
    ↓
【STEP 3】ディスクパーティション設定              → 6章参照
    ↓
【STEP 4】インストール実行                       → 7.1節参照
    ↓
【STEP 5】システム設定・ユーザ管理・最終確認      → 7章, 8章, 9章参照
---------------------------------------------------------------
```

### 11.1 【管理者】STEP1: 初期設定とインストール方式の選択

インストーラ起動後、以下の手順で初期設定とインストール方式を決定します。

1. **キーマップ選択**: 使用するキーボードレイアウトを選択します（USキーボードの場合はデフォルトのまま続行）
2. **ホスト名設定**: マシンのホスト名を入力します
3. **インストール種別選択**: Distribution SetsまたはPackages(pkgbase)を選択します
4. **配布セット選択**（Distribution Setsの場合）: 必要なオプションセットを選択します
5. **ミラーサイト選択**（ネットワークダウンロードの場合）: 最寄りのミラーサイトを選択します

### 11.2 【管理者】STEP2: ネットワーク設定

ネットワーク経由のインストールやシステムのネットワーク接続設定を行います。

1. **インターフェース選択**: 使用するネットワークインターフェースを選択します
2. **無線LAN設定**（無線の場合）: SSIDの選択と認証情報の入力を行います
3. **IPv4設定**: DHCP自動取得またはスタティック設定を行います
4. **IPv6設定**: SLAAC自動構成またはスタティック設定を行います
5. **DNS設定**: DNSサーバとサーチドメインを設定します

### 11.3 【管理者】STEP3: ディスクパーティション設定

インストール先ディスクのパーティション構成を決定します。

1. **パーティションモード選択**: Auto(ZFS)、Auto(UFS)、Manual、Shellから選択します
2. **詳細設定**:
   - ZFSの場合: プール名、vdevタイプ、暗号化、ディスク選択を設定します
   - UFSの場合: 自動的にパーティションが作成されます
   - Manualの場合: パーティションを手動で作成・編集します

### 11.4 【管理者】STEP4-5: インストール実行・システム設定

インストールの実行と初期システム設定を行います。

1. **インストール実行**: 配布ファイルのダウンロード・検証・展開が自動的に行われます
2. **rootパスワード設定**: root管理者パスワードを設定します
3. **タイムゾーン・日時設定**: タイムゾーンの選択と日時の設定を行います
4. **サービス選択**: 起動時に有効にするサービス（sshd、ntpd等）を選択します
5. **セキュリティ強化**: セキュリティオプションを選択します
6. **ファームウェアインストール**: 必要なファームウェアをインストールします
7. **ユーザ追加**: 一般ユーザアカウントを作成します
8. **最終設定メニュー**: 全設定を再確認し、必要に応じて変更します
9. **手動設定確認**: 追加の手動設定が必要な場合はシェルを起動します
10. **完了**: マシンを再起動してFreeBSDの初回起動を行います

---

## 12. よくある質問と対処法

### 12.1 インストーラ起動に関するQ&A

**Q: インストールメディアから起動できません**

A: 以下を確認してください:
- BIOSまたはUEFIのブート順序でインストールメディア（USB/CD/DVD）が優先されているか確認します
- SecureBoot が有効な場合は無効にしてください
- USBメディアの場合、別のUSBポートに接続してみてください

**Q: キーマップ選択画面で日本語キーボードが見つかりません**

A: メニューを下にスクロールして「Japanese 106」または「Japanese 109」を探してください。「Test keymap」で実際のキー入力をテストして正しいレイアウトか確認できます。

### 12.2 ネットワーク設定に関するQ&A

**Q: 無線LANが検出されません**

A: 以下を確認してください:
- 無線LANアダプタがFreeBSDでサポートされているか確認します
- ファームウェアが必要なデバイスの場合、有線接続で先にファームウェアをインストールする必要がある場合があります
- `ifconfig -a` でインターフェースが表示されるか確認します

**Q: DHCPでIPアドレスが取得できません**

A: 以下を確認してください:
- LANケーブルが正しく接続されているか確認します
- DHCPサーバがネットワーク上で稼動しているか確認します
- スタティック設定に切り替えて手動でIPアドレスを設定してみてください

### 12.3 パーティション設定に関するQ&A

**Q: ZFSオプションが表示されません**

A: ZFSブートオプションはamd64、arm64、i386、riscvアーキテクチャでのみ利用可能です。お使いのアーキテクチャが対応しているか確認してください。

**Q: ディスクが認識されません**

A: 以下を確認してください:
- ディスクが正しく接続されているか確認します
- BIOSまたはUEFIでディスクが認識されているか確認します
- NVMeディスクの場合、対応するドライバがロードされているか確認します

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラー・状況 | 原因 | 対処法 |
|-------------|------|--------|
| インストール中断エラー画面が表示される | インストールステップが中断された | 「Restart」でインストーラを再起動するか、「Exit」で終了して原因を調査する |
| チェックサム検証エラー | ダウンロードした配布ファイルが破損している | ミラーサイトを変更して再ダウンロードする。インストールメディア自体の破損も確認する |
| ディスク書き込みエラー | ディスクの不良またはアクセス権の問題 | ディスクの健全性を確認する。別のディスクを使用してみる |
| ネットワーク接続タイムアウト | ネットワーク設定の誤りまたはミラーサイトのダウン | ネットワーク設定を再確認する。別のミラーサイトを選択する |
| パーティション作成エラー | ディスクの既存パーティションテーブルとの競合 | 手動モードまたはShellモードで既存パーティションを削除してからやり直す |
| ファームウェアインストール失敗 | ネットワーク未接続またはpkgリポジトリへの接続失敗 | ネットワーク設定を確認し、リポジトリに接続できるか確認する |

### 13.2 よくあるトラブルと解決方法

**トラブル: インストール後に起動しない**

解決方法:
1. ブートローダが正しくインストールされているか確認します
2. UEFIモードとBIOSモードのブート設定が正しいか確認します
3. インストールメディアから再起動し、「Live CD」モードでシステムにアクセスして修復します

**トラブル: インストーラ内でキー入力が反応しない**

解決方法:
1. USBキーボードの場合、別のUSBポートに接続してみます
2. PS/2キーボードに切り替えてみます
3. ブートローダで `hw.usb.xhci.xhci_stream_disable=1` を設定してみます

**トラブル: インストール完了後にネットワークが繋がらない**

解決方法:
1. `ifconfig` でネットワークインターフェースの状態を確認します
2. `/etc/rc.conf` のネットワーク設定を確認します
3. `/etc/resolv.conf` のDNS設定を確認します
4. ファームウェアが必要なデバイスの場合は `fwget` でファームウェアをインストールします

### 13.3 サポートへの連絡方法

FreeBSDのインストールに関する問題については、以下のリソースを参照してください:

- **FreeBSD Handbook**: https://docs.freebsd.org/en/books/handbook/
- **FreeBSD フォーラム**: https://forums.freebsd.org/
- **FreeBSD メーリングリスト**: https://lists.freebsd.org/
- **FreeBSD Bugzilla**: https://bugs.freebsd.org/

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-02-01 | 初版作成 |

---

*本マニュアルは、FreeBSD bsdinstallインストーラのエンドユーザー向け業務運用マニュアルです。*
*FreeBSDのバージョンアップにより、画面や操作方法が変更される場合があります。*
