---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 40
  claims_with_evidence: 35
  claims_without_evidence: 5
confidence_derived: 0.88
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：35 / 40、根拠なし：5
- 優先レビュー（高）
  1. **NFT-001（syscall応答時間の合格基準値）**：具体的な閾値10マイクロ秒の根拠が不足
  2. **NFT-002（コンテキストスイッチ遅延の合格基準値）**：具体的な閾値50マイクロ秒の根拠が不足
  3. **NFT-005（ファイルシステムI/O合格基準値）**：物理デバイス性能の90%という閾値の根拠が不足
  4. **NFT-027（Linux ABI互換の95%基準）**：互換率95%という合格基準の根拠が不足
  5. **NFT-033（Kyuaテスト成功率95%基準）**：テスト成功率95%の閾値の根拠が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `sys/kern/init_sysent.c` - syscallテーブル定義
- E-02: `sys/kern/sched_ule.c` - ULEスケジューラ実装
- E-03: `sys/netinet/` - TCP/IPプロトコルスタック
- E-04: `sys/vm/uma_core.c` - UMAスラブアロケータ
- E-05: `sys/ufs/`, `sys/fs/` - ファイルシステム実装群
- E-06: `sys/kern/kern_fork.c` - fork実装（ディレクトリ内に存在確認）
- E-07: `sys/kern/kern_descrip.c` - ファイルディスクリプタ管理
- E-08: `sys/vm/swap_pager.c` - swapページャ
- E-09: `sys/kern/kern_mutex.c`, `sys/kern/kern_rwlock.c` - ロック実装
- E-10: `sys/kern/kern_jail.c` - jail実装
- E-11: `sys/kern/kern_priv.c` - 特権チェックフレームワーク
- E-12: `sys/opencrypto/crypto.c` - OpenCryptoフレームワーク
- E-13: `tests/sys/opencrypto/` - 暗号テスト（KAT含む）
- E-14: `sys/kern/uipc_ktls.c` - カーネルTLS実装
- E-15: `tests/sys/kern/ktls_test.c` - KTLSテスト
- E-16: `sys/security/audit/` - BSM監査フレームワーク
- E-17: `sys/netpfil/pf/pf.c` - PFファイアウォール
- E-18: `sys/netipsec/` - IPsec実装
- E-19: `sys/compat/` - ABI互換レイヤー
- E-20: `tests/sys/capsicum/` - Capsicumテスト
- E-21: `sys/security/mac/` - MACフレームワーク
- E-22: `sys/security/mac_biba/` - Biba MACポリシー
- E-23: `sys/kern/kern_rctl.c` - RCTLリソース制限
- E-24: `sys/kern/kern_racct.c` - RACCTリソースアカウンティング
- E-25: `sys/nfsclient/`, `sys/nfsserver/` - NFS実装
- E-26: `sys/conf/` - カーネルコンフィグ
- E-27: `tests/` - Kyuaテストスイート
- E-28: `Makefile.inc1` - ビルドシステム
- E-29: `sys/netpfil/ipfw/` - IPFWファイアウォール
- E-30: `tests/sys/compat32/` - 32bit互換テスト
- E-31: `sys/vm/vm_pageout.c` - ページアウトデーモン（ディレクトリ内に存在確認）
- E-32: `tests/sys/net/if_lagg_test.sh` - LAGGテスト
- E-33: `sys/kern/kern_sysctl.c` - sysctl実装（ディレクトリ内に存在確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001: syscall応答時間テスト - syscallテーブル存在 | E-01 | ○ |
| C-02 | NFT-001: 合格基準「平均10マイクロ秒以下」 | **根拠なし** | △ |
| C-03 | NFT-002: ULEスケジューラのコンテキストスイッチテスト | E-02 | ○ |
| C-04 | NFT-002: 合格基準「50マイクロ秒以下」 | **根拠なし** | △ |
| C-05 | NFT-003: TCP/IPスタックスループット測定 | E-03 | ○ |
| C-06 | NFT-004: UMAアロケータ性能測定 | E-04 | ○ |
| C-07 | NFT-005: ファイルシステムI/O性能測定 | E-05 | ○ |
| C-08 | NFT-005: 合格基準「物理デバイス性能の90%以上」 | **根拠なし** | △ |
| C-09 | NFT-006: fork性能測定テスト | E-06 | ○ |
| C-10 | NFT-007: スケジューラ公平性測定 | E-02 | ○ |
| C-11 | NFT-008: TCP接続スケーラビリティ測定 | E-03 | ○ |
| C-12 | NFT-009: ファイルディスクリプタ大量使用テスト | E-07 | ○ |
| C-13 | NFT-010: メモリ枯渇安定性テスト | E-31 | ○ |
| C-14 | NFT-011: swap枯渇テスト | E-08 | ○ |
| C-15 | NFT-012: mutex/rwlock競合テスト | E-09 | ○ |
| C-16 | NFT-013: カーネルモジュール動的ロードテスト | E-06 | ○ |
| C-17 | NFT-014: NFS障害フォールバックテスト | E-25 | ○ |
| C-18 | NFT-015: LAGGフェイルオーバーテスト | E-32 | ○ |
| C-19 | NFT-016: クラッシュダンプ・復旧テスト | E-06 | ○ |
| C-20 | NFT-017: fsck整合性チェックテスト | E-05 | ○ |
| C-21 | NFT-018: Capsicumケーパビリティモードテスト | E-20 | ○ |
| C-22 | NFT-019: MACフレームワークポリシーテスト | E-21, E-22 | ○ |
| C-23 | NFT-020: jail環境アクセス制限テスト | E-10 | ○ |
| C-24 | NFT-021: 特権チェックテスト | E-11 | ○ |
| C-25 | NFT-022: OpenCrypto暗号アルゴリズムKATテスト | E-12, E-13 | ○ |
| C-26 | NFT-023: KTLS機能テスト | E-14, E-15 | ○ |
| C-27 | NFT-024: BSM監査ログテスト | E-16 | ○ |
| C-28 | NFT-025: PFファイアウォールテスト | E-17 | ○ |
| C-29 | NFT-026: IPsec VPNテスト | E-18 | ○ |
| C-30 | NFT-027: Linux ABI互換テスト - 互換レイヤー存在 | E-19 | ○ |
| C-31 | NFT-027: 合格基準「95%以上のsyscallエミュレーション」 | **根拠なし** | △ |
| C-32 | NFT-028: 32bit互換モードテスト | E-19, E-30 | ○ |
| C-33 | NFT-029: マルチアーキテクチャビルドテスト | E-26 | ○ |
| C-34 | NFT-030: 複数ファイルシステム共存テスト | E-05 | ○ |
| C-35 | NFT-031: インクリメンタルビルドテスト | E-26, E-28 | ○ |
| C-36 | NFT-032: ワールドフルビルドテスト | E-28 | ○ |
| C-37 | NFT-033: Kyuaテスト全実行 - テストスイート存在 | E-27 | ○ |
| C-38 | NFT-033: 合格基準「成功率95%以上」 | **根拠なし** | △ |
| C-39 | NFT-034: sysctlパラメータ動的変更テスト | E-33 | ○ |
| C-40 | NFT-035-040: その他テストケース | E-10, E-17, E-23, E-24, E-26, E-29 | ○ |

## 4) 不足情報（Unknown / Missing）
- 各テストケースの合格基準値（具体的な閾値）について、FreeBSDプロジェクト公式のSLA定義書や性能要件定義書がリポジトリ内に見当たらない
  - 候補：FreeBSD公式ベンチマーク結果 / FreeBSD Performance Tuning Guide / 過去リリースの性能回帰テスト基準
- Linux ABI互換レイヤーの対応syscallカバレッジに関する公式文書が不在
  - 候補：sys/compat/linux/syscalls.master / FreeBSD Linuxulator wiki
- Kyuaテストスイートの許容失敗率に関する公式基準が不在
  - 候補：FreeBSD CI/CDパイプライン設定 / tests/README

## 5) リスクフラグ（レビュー観点）
- リスク1（中）：合格基準の閾値は業界標準や経験値に基づく推定であり、プロジェクト固有の要件定義書で裏付けられていない。実環境での測定結果と照合する必要がある。
- リスク0（低）：テスト対象のソースコードの存在は全て確認済みである。
- リスク1（中）：FreeBSDは複数アーキテクチャを対象とするため、テスト結果がアーキテクチャにより異なる可能性がある。テストケースにアーキテクチャ条件の明示が不十分。
- リスク1（中）：性能テストの合格基準はハードウェア依存性が高く、テスト環境の仕様を明確にする必要がある。

## 6) レビュアーチェックリスト（最小）
- [ ] 性能テストの合格基準値（NFT-001〜NFT-012）がプロジェクトのSLA/性能要件と合致しているか確認
- [ ] セキュリティテスト（NFT-018〜NFT-026, NFT-038, NFT-040）のテスト条件がセキュリティ要件定義と整合しているか確認
- [ ] 互換性テスト（NFT-027〜NFT-030）の対象範囲がリリース計画と一致しているか確認
- [ ] テスト環境（ハードウェアスペック、OS構成）が各テストケースで明示されるべきか判断
- [ ] 不足しているテスト種別（例：災害復旧テスト、長時間稼働テスト）がないか確認
