---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 42
  claims_with_evidence: 38
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：38 / 42、根拠なし：4
- 優先レビュー（高）
  1. **可用性要件の SLA 定義**：ソースコード上に具体的な稼働率目標や SLA が存在しない
  2. **TCP タイマーのデフォルト値**：ソースコード上の define 値とランタイムデフォルト値の整合確認が必要
  3. **GEOM RAID の具体的サポート範囲**：RAID レベルの詳細はソースコードの追加調査が必要
  4. **RPO の具体値**：ファイルシステムごとの RPO はソースから直接読み取れない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `sys/kern/subr_param.c` - カーネルパラメータ定義（HZ, maxusers, maxproc, maxfiles 等）
- E-02: `sys/netinet/tcp_timer.c` - TCP タイマー定義（keepalive, rexmit, msl 等）
- E-03: `sys/netinet/tcp_syncache.c` - TCP SYN キャッシュ再送実装
- E-04: `sys/kern/subr_log.c` - カーネルメッセージログデバイス
- E-05: `sys/kern/kern_shutdown.c` - カーネルシャットダウン・パニック処理
- E-06: `sys/netinet/ip_carp.c` - CARP プロトコル実装
- E-07: `sys/geom/mirror/g_mirror.c` - GEOM ミラー実装
- E-08: `sys/geom/eli/g_eli.c` - GEOM 暗号化（GELI）実装
- E-09: `sys/security/mac/` - MAC フレームワークディレクトリ
- E-10: `sys/security/audit/` - BSM 監査ディレクトリ
- E-11: `sys/kern/kern_jail.c` - Jail 実装（securelevel 含む）
- E-12: `sys/kern/kern_priv.c` - 特権管理
- E-13: `sys/kern/sys_capability.c` - Capsicum ケイパビリティ
- E-14: `sys/netpfil/pf/` - pf パケットフィルタディレクトリ
- E-15: `sys/netpfil/ipfw/` - IPFW ファイアウォールディレクトリ
- E-16: `sys/netpfil/ipfilter/` - IPFilter ディレクトリ
- E-17: `sys/kern/kern_linker.c` - カーネルモジュールリンカー
- E-18: `sys/amd64/include/param.h` - amd64 アーキテクチャパラメータ
- E-19: `sys/arm64/include/param.h` - arm64 アーキテクチャパラメータ
- E-20: `sys/i386/include/param.h` - i386 アーキテクチャパラメータ
- E-21: `sys/powerpc/include/param.h` - powerpc アーキテクチャパラメータ
- E-22: `sys/kern/kern_timeout.c` - callout タイマー統計
- E-23: `README.md` - プロジェクト概要・ディレクトリ構成
- E-24: `sys/kern/kern_racct.c` - リソースアカウンティング
- E-25: `sys/kern/kern_alq.c` - 非同期ログキュー
- E-26: `sys/kern/kern_boottrace.c` - ブートトレース
- E-27: `sys/kern/subr_kdb.c` - カーネルデバッガ（securelevel 制御含む）
- E-28: `sys/security/mac_veriexec/` - 実行ファイル検証
- E-29: `sys/compat/linuxkpi/common/include/linux/ratelimit.h` - レートリミット
- E-30: `tests/` - テストスイートディレクトリ
- E-31: `CONTRIBUTING.md` - 貢献ガイドライン

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カーネルクロック HZ=1000 がデフォルト | E-01 | ○ |
| C-02 | 仮想マシン環境で HZ_VM=100 | E-01 | ○ |
| C-03 | TCP 初期 RTO のデフォルト値 1000ms | E-02 | ○ |
| C-04 | TCP 最小 RTO のデフォルト値 30ms | E-02 | ○ |
| C-05 | TCP 最大 RTO のデフォルト値 64000ms | E-02 | ○ |
| C-06 | TCP Delayed ACK 100ms | E-02 | ○ |
| C-07 | maxproc = 20 + 16 * maxusers | E-01 | ○ |
| C-08 | maxfiles = 40 + 32 * maxusers | E-01 | ○ |
| C-09 | amd64 MAXCPU=1024, MAXMEMDOM=8 | E-18 | ○ |
| C-10 | arm64 MAXCPU=1024, MAXMEMDOM=8 | E-19 | ○ |
| C-11 | i386 MAXCPU=32, MAXMEMDOM=1 | E-20 | ○ |
| C-12 | powerpc MAXCPU=256 | E-21 | ○ |
| C-13 | TCP keepalive 関連パラメータの存在 | E-02 | ○ |
| C-14 | TCP 再送に指数バックオフ使用 | E-02, E-03 | ○ |
| C-15 | tcp_always_keepalive デフォルト 1 | E-02 | ○ |
| C-16 | 稼働率の具体的 SLA なし | **根拠なし** | △ |
| C-17 | パニック時クラッシュダンプ・自動リブート | E-05 | ○ |
| C-18 | RPO がファイルシステム依存 | **根拠なし** | △ |
| C-19 | CARP によるネットワーク冗長化 | E-06 | ○ |
| C-20 | GEOM Mirror によるストレージミラーリング | E-07 | ○ |
| C-21 | GEOM RAID サポート | E-07（ディレクトリ確認） | ○ |
| C-22 | MAC フレームワーク（Biba, LOMAC, MLS） | E-09 | ○ |
| C-23 | Capsicum ケイパビリティモード | E-13 | ○ |
| C-24 | securelevel によるシステム操作制限 | E-11, E-27 | ○ |
| C-25 | Jail によるプロセス隔離 | E-11 | ○ |
| C-26 | BSM 監査サポート | E-10 | ○ |
| C-27 | pf パケットフィルタ | E-14 | ○ |
| C-28 | IPFW ファイアウォール | E-15 | ○ |
| C-29 | IPFilter | E-16 | ○ |
| C-30 | GELI ディスク暗号化 | E-08 | ○ |
| C-31 | MAC Veriexec 実行ファイル検証 | E-28 | ○ |
| C-32 | 動的カーネルモジュールのロード/アンロード | E-17 | ○ |
| C-33 | VNET によるネットワークスタック仮想化 | E-02 | ○ |
| C-34 | VM ゲスト検出（Xen, HyperV, VMware 等） | E-01 | ○ |
| C-35 | maxusers の自動チューニングロジック | E-01 | ○ |
| C-36 | カーネルメッセージバッファ /dev/log | E-04 | ○ |
| C-37 | ALQ 非同期ログキュー | E-25 | ○ |
| C-38 | DTrace 動的トレーシング | E-22（dtrace モジュール参照） | ○ |
| C-39 | KDB securelevel 制御 | E-27 | ○ |
| C-40 | RACCT リソースアカウンティング | E-24 | ○ |
| C-41 | TCP タイマーデフォルト値の正確性（30ms, 64000ms 等） | **根拠なし** | △ |
| C-42 | GEOM RAID の具体的 RAID レベル | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-16（稼働率 SLA）**: FreeBSD はカーネルソースコードであり、具体的な SLA やサービスレベル目標はソースコード上に定義されていない。これは運用ポリシーの範囲であり、コードから抽出不可能。
  - 候補：運用マニュアル / SLA 文書 / デプロイメントガイド
- **C-18（RPO 値）**: ファイルシステムごとの RPO はアーキテクチャ設計上の特性であり、ソースコードの特定箇所には数値として記載されていない。
  - 候補：ZFS ドキュメント / UFS softupdates 設計文書 / FreeBSD ハンドブック
- **C-41（TCP タイマーデフォルト値の正確性）**: ソースコード上で sysctl 定義は確認できるが、初期値の代入箇所（tcp_init 等）の追加確認が望ましい。
  - 候補：`sys/netinet/tcp_subr.c`（tcp_init 関数）/ `sys/netinet/tcp_timer.h`（TCPTV_* マクロ）
- **C-42（GEOM RAID レベル）**: GEOM RAID のディレクトリ存在は確認したが、サポートする RAID レベルの詳細はソースコードの追加調査が必要。
  - 候補：`sys/geom/raid/g_raid.c` / `sys/geom/raid/` 配下の各トランスフォームモジュール

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: TCP タイマーのデフォルト値について、sysctl 定義は確認できたが `tcp_init()` での初期代入値と一致するかの追加確認が必要
- **0（低リスク）**: MAXCPU, MAXMEMDOM 等のアーキテクチャ定数はヘッダファイルから直接読み取っており高精度
- **0（低リスク）**: セキュリティ機能（MAC, Capsicum, Jail, 監査）はディレクトリ・ソースファイルの存在で裏付け済み
- **1（中リスク）**: 可用性要件の具体値（稼働率、RTO、RPO）はソースコードからは導出不可能であり、運用設計に委ねられる
- **0（低リスク）**: カーネルパラメータのチューニング式（maxproc, maxfiles）はソースコードから直接引用

## 6) レビュアーチェックリスト（最小）
- [ ] TCP タイマーのデフォルト値が `sys/netinet/tcp_subr.c` の `tcp_init()` 関数内の初期化と一致するか確認
- [ ] GEOM RAID がサポートする具体的な RAID レベル（0, 1, 3, 5 等）を `sys/geom/raid/` 配下で確認
- [ ] maxusers の自動チューニング上限値（VM_MAX_AUTOTUNE_MAXUSERS）の具体値を確認
- [ ] 可用性要件のうち、運用環境固有の SLA/RTO/RPO 値が別途定義されているか確認
- [ ] Kerberos 5 や暗号化ライブラリのバージョン情報を `kerberos5/` および `crypto/` で確認
