# 非機能要件定義書

## 概要

本ドキュメントは、FreeBSD オペレーティングシステムのソースコード（freebsd-src-main）から読み取れる非機能要件を整理したものである。FreeBSD はサーバ、デスクトップ、組み込みプラットフォームを対象とした汎用 UNIX 系 OS であり、高度なネットワーキング、セキュリティ、ストレージ機能を備える。本書ではカーネルおよびユーザランドのソースコードに実装されている非機能特性を性能・可用性・セキュリティ・拡張性・保守性・運用監視の観点で定義する。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| カーネルクロック割り込み（HZ） | デフォルト 1000Hz（1ms 間隔） | `sys/kern/subr_param.c` にて `HZ=1000` として定義。仮想マシン環境では `HZ_VM=100` に低減される |
| TCP 初期再送タイムアウト（RTO） | `net.inet.tcp.rexmit_initial` で設定（デフォルト 1000ms） | `sys/netinet/tcp_timer.c` にて定義 |
| TCP 最小再送タイムアウト | `net.inet.tcp.rexmit_min` で設定（デフォルト 30ms） | 同上 |
| TCP 最大再送タイムアウト | `net.inet.tcp.rexmit_max` で設定（デフォルト 64000ms） | 同上 |
| TCP Delayed ACK 送信遅延 | `net.inet.tcp.delacktime` で設定（デフォルト 100ms） | `sys/netinet/tcp_timer.c` にて定義 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 最大プロセス数（maxproc） | `20 + 16 * maxusers` | `sys/kern/subr_param.c` にて算出。`kern.maxusers` はメモリ量から自動チューニングされる |
| 最大オープンファイル数（maxfiles） | `40 + 32 * maxusers` | 同上。`kern.maxfiles` として sysctl で参照可能 |
| 最大 CPU 数（MAXCPU） | amd64/arm64: 1024、i386: 32、powerpc: 256 | 各アーキテクチャの `sys/<arch>/include/param.h` にて定義 |
| 最大メモリドメイン数（MAXMEMDOM） | amd64/arm64: 8、i386: 1 | NUMA 対応。各アーキテクチャの param.h にて定義 |
| バッファキャッシュ数（nbuf） | 自動チューニング（`kern.nbuf`） | `sys/kern/subr_param.c` にて定義。ブート時チューニング可能 |
| スワップバッファ数（nswbuf） | 自動チューニング（`kern.nswbuf`） | 同上 |
| 最大 Raw I/O 転送サイズ（maxphys） | アーキテクチャ依存 | `kern.maxphys` として sysctl で参照可能 |

### タイムアウト設定

| 項目 | 設定パラメータ | 備考 |
| --- | --- | --- |
| TCP コネクション確立タイムアウト | `net.inet.tcp.keepinit` | `sys/netinet/tcp_timer.c` にて定義 |
| TCP Keepalive アイドルタイムアウト | `net.inet.tcp.keepidle` | 同上。Keepalive 開始までの待機時間 |
| TCP Keepalive プローブ間隔 | `net.inet.tcp.keepintvl` | 同上 |
| TCP Keepalive プローブ回数 | `net.inet.tcp.keepcnt`（デフォルト TCPTV_KEEPCNT） | 同上 |
| TCP Maximum Segment Lifetime | `net.inet.tcp.msl` | 同上 |
| TCP FIN_WAIT2 タイムアウト | `net.inet.tcp.finwait2_timeout` | 同上 |
| TCP 持続タイマー最小値 | `net.inet.tcp.persmin` | 同上 |
| TCP 持続タイマー最大値 | `net.inet.tcp.persmax` | 同上 |

### リトライ設定

| 項目 | 設定パラメータ | 備考 |
| --- | --- | --- |
| TCP 再送制御 | `net.inet.tcp.rexmit_initial` / `rexmit_min` / `rexmit_max` | `sys/netinet/tcp_timer.c`。指数バックオフ `tcp_backoff[]` テーブルを使用 |
| TCP 再送スロップ | `net.inet.tcp.rexmit_slop` | 再送タイマーの余裕値 |
| TCP SYN キャッシュ再送 | SyncCache にて backoff テーブルベースで再送 | `sys/netinet/tcp_syncache.c` にて実装 |
| TCP Keepalive（常時有効） | `net.inet.tcp.always_keepalive`（デフォルト 1） | 全 TCP 接続で SO_KEEPALIVE を仮定 |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | ソースコード上に明示的な SLA 定義なし | 運用環境依存。カーネル設計としてはパニック時のダンプ・再起動メカニズムを備える |
| 計画停止時間 | 定義なし | カーネルアップデート時にはリブートが必要。`freebsd-update` による無停止パッチは一部対応 |
| 障害復旧時間（RTO） | カーネルパニック時のクラッシュダンプ + 自動リブート | `sys/kern/kern_shutdown.c` にて実装。watchdog による自動復旧もサポート |
| 目標復旧時点（RPO） | ファイルシステム依存（ZFS: トランザクション整合、UFS: fsck による復旧） | ZFS はコピーオンライトによる整合性保証。UFS はジャーナリング（softupdates）対応 |

### 冗長構成

| 機能 | 実装 | 備考 |
| --- | --- | --- |
| ネットワーク冗長化（CARP） | `sys/netinet/ip_carp.c` | Common Address Redundancy Protocol。IP アドレスの冗長化によるフェイルオーバーを実現 |
| ストレージミラーリング（GEOM Mirror） | `sys/geom/mirror/g_mirror.c` | ディスクミラーリングによるデータ冗長化 |
| ストレージ RAID（GEOM RAID） | `sys/geom/raid/g_raid.c` | ソフトウェア RAID サポート |
| カーネルクラッシュダンプ | `sys/kern/kern_shutdown.c` | パニック時に自動的にコアダンプを保存し、障害分析を可能にする |

## セキュリティ要件

### アクセス制御

| 機能 | 実装 | 備考 |
| --- | --- | --- |
| MAC フレームワーク | `sys/security/mac/` | Mandatory Access Control フレームワーク。Biba、LOMAC、MLS など複数のポリシーモジュールをサポート |
| MAC Biba（整合性モデル） | `sys/security/mac_biba/` | Biba 整合性モデルによる強制アクセス制御 |
| MAC LOMAC | `sys/security/mac_lomac/` | Low-Watermark MAC ポリシー |
| MAC MLS（多層セキュリティ） | `sys/security/mac_mls/` | Bell-LaPadula モデルに基づく多層セキュリティ |
| Capsicum（ケイパビリティモード） | `sys/kern/sys_capability.c` | サンドボックス実行環境。プロセスのケイパビリティを制限 |
| securelevel | `sys/kern/kern_jail.c` 等 | カーネルセキュリティレベル。レベルに応じてシステム操作を制限 |
| Jail（コンテナ化） | `sys/kern/kern_jail.c` | プロセスの隔離環境。ネットワーク・ファイルシステム・プロセス空間を分離 |
| 権限管理（priv） | `sys/kern/kern_priv.c` | 特権操作のきめ細かな制御 |

### 監査

| 機能 | 実装 | 備考 |
| --- | --- | --- |
| BSM 監査 | `sys/security/audit/` | Basic Security Module。システムコール単位の監査ログを生成 |
| 監査パイプ | `sys/security/audit/audit_pipe.c` | リアルタイム監査イベントの配信 |
| 監査トリガー | `sys/security/audit/audit_trigger.c` | 監査イベントに対するトリガーアクション |

### ネットワークセキュリティ

| 機能 | 実装 | 備考 |
| --- | --- | --- |
| パケットフィルタ（pf） | `sys/netpfil/pf/` | OpenBSD 由来のステートフルパケットフィルタ |
| IPFW ファイアウォール | `sys/netpfil/ipfw/` | FreeBSD ネイティブのファイアウォール |
| IPFilter | `sys/netpfil/ipfilter/` | Darren Reed 作の IP フィルタ |
| ディスク暗号化（GELI） | `sys/geom/eli/` | GEOM-based Encryption Layer。AES 等による透過的ディスク暗号化 |
| Kerberos 5 | `kerberos5/` | Heimdal Kerberos 実装による認証基盤 |
| 暗号化ライブラリ | `crypto/`, `secure/` | OpenSSL 等の暗号化ライブラリ |
| MAC Veriexec（実行ファイル検証） | `sys/security/mac_veriexec/` | 実行ファイルの署名検証 |

## 拡張性要件

### アーキテクチャサポート

| アーキテクチャ | MAXCPU | MAXMEMDOM | 備考 |
| --- | --- | --- | --- |
| amd64 | 1024 | 8 | `sys/amd64/include/param.h` |
| arm64 | 1024 | 8 | `sys/arm64/include/param.h` |
| i386 | 32 | 1 | `sys/i386/include/param.h` |
| powerpc | 256 | アーキテクチャ依存 | `sys/powerpc/include/param.h` |

### カーネルモジュールシステム

| 機能 | 実装 | 備考 |
| --- | --- | --- |
| 動的カーネルモジュール | `sys/kern/kern_linker.c` | 実行時にカーネルモジュールのロード/アンロードが可能 |
| GEOM フレームワーク | `sys/geom/` | モジュラーなストレージ変換レイヤー。ミラー、RAID、暗号化等をスタック可能 |
| ネットワークスタック仮想化（VNET） | TCP/IP スタック全体に VNET_DEFINE マクロを使用 | `sys/netinet/tcp_timer.c` 等。Jail ごとに独立したネットワークスタックを提供 |
| 仮想マシン対応 | `sys/kern/subr_param.c` にて VM ゲスト検出 | Xen, HyperV, VMware, KVM, bhyve, VBox, Parallels, NVMM に対応 |

### リソース自動チューニング

| パラメータ | チューニング方式 | 備考 |
| --- | --- | --- |
| maxusers | 物理メモリ量から自動算出 | `pgtok(physpages) / (2 * 1024)`。最小 32、大規模時は 384 以上で緩やかにスケール |
| maxproc | maxusers から導出 | `20 + 16 * maxusers` |
| maxfiles | maxusers から導出 | `40 + 32 * maxusers` |
| カーネルスタックサイズ | `kern.kstack_pages` でチューニング可能 | ブート時に設定 |
| メッセージバッファサイズ | `kern.msgbufsize` でチューニング可能 | カーネルログバッファのサイズ |

## 保守性要件

### ビルドシステム

| 機能 | 実装 | 備考 |
| --- | --- | --- |
| make buildworld / buildkernel | `Makefile`, `Makefile.inc1` | ユーザランドとカーネルを個別にビルド可能 |
| カーネルコンフィグレーション | `sys/<arch>/conf/GENERIC` 等 | コンフィグファイルによるカーネル機能の選択的ビルド |
| DIRDEPS_BUILD | `targets/` | 実験的な依存関係ベースビルドシステム |

### テスト

| 機能 | 実装 | 備考 |
| --- | --- | --- |
| 回帰テストスイート | `tests/` | Kyua テストフレームワークによる回帰テスト |
| DTrace プロービング | `sys/modules/dtrace/` | 動的トレーシングフレームワーク。カーネルおよびユーザランドのプロービングが可能 |
| INVARIANTS / WITNESS | カーネルコンフィグオプション | デバッグビルドでのロック順序検証、不変条件チェック |

### コード品質

| 機能 | 実装 | 備考 |
| --- | --- | --- |
| ライセンス管理 | 各ソースファイルに SPDX ヘッダ | BSD-2-Clause, BSD-3-Clause 等のライセンス識別子 |
| コーディング規約 | `CONTRIBUTING.md` | 貢献ガイドラインの提供 |
| sysctl インターフェース | カーネル全体で SYSCTL マクロを使用 | 一貫したカーネルパラメータ管理インターフェース |

## 運用・監視要件

### ログ機能

| 機能 | 実装 | 備考 |
| --- | --- | --- |
| カーネルメッセージバッファ | `sys/kern/subr_log.c` | `/dev/log` デバイスによるカーネルログの提供。`kern.msgbufsize` でバッファサイズ制御 |
| syslog | syslog(3) ライブラリ | ユーザランドからのログ出力 |
| ALQ（Asynchronous Logging Queues） | `sys/kern/kern_alq.c` | 非同期ログキュー。高性能ログ記録に使用 |
| ブートトレース | `sys/kern/kern_boottrace.c` | ブートプロセスのトレーシング |

### 監視・デバッグ

| 機能 | 実装 | 備考 |
| --- | --- | --- |
| DTrace | `sys/modules/dtrace/` | 動的トレーシング。FBT, SDT, profile, fasttrap 等の複数プロバイダーをサポート |
| KDB（Kernel Debugger） | `sys/kern/subr_kdb.c` | カーネルデバッガ。securelevel によるアクセス制御あり |
| sysctl 監視 | カーネル全体 | `debug.to_avg_depth`, `debug.to_avg_gcalls` 等のランタイム統計を sysctl 経由で公開 |
| devctl | `sys/kern/kern_devctl.c` | デバイスイベント通知メカニズム |
| ktrace | `sys/kern/kern_ktrace.c` | プロセス単位のシステムコールトレース |

### リソース管理

| 機能 | 実装 | 備考 |
| --- | --- | --- |
| RACCT（Resource Accounting） | `sys/kern/kern_racct.c` | リソース使用量の計測と制限 |
| プロセスリソース制限 | `sys/kern/kern_resource.c` | rlimit による per-process リソース制限 |
| CPU セット | `sys/kern/kern_cpuset.c` | CPU アフィニティの管理 |

### レートリミット設定

| 機能 | 実装 | 備考 |
| --- | --- | --- |
| Linux 互換レートリミット | `sys/compat/linuxkpi/common/include/linux/ratelimit.h` | Linux KPI 互換レイヤーにおけるレートリミット機能 |
| ネットワークレートリミット | 各種ネットワークドライバおよびプロトコルスタック | TCP 輻輳制御（`sys/netinet/cc/`）を含む |

## 備考

- 本ドキュメントは FreeBSD ソースコード（main ブランチ）の静的解析に基づいて生成されたものであり、実運用環境での具体的な数値目標（SLA、稼働率等）はデプロイメント環境に依存する。
- 各パラメータは sysctl、カーネルコンフィグファイル（GENERIC 等）、loader.conf、sysctl.conf 等で実行時または起動時にチューニング可能である。
- FreeBSD は汎用 OS であるため、非機能要件の具体的な数値はアプリケーション要件に応じて個別に設計する必要がある。
- 仮想マシン環境（VM ゲスト）での動作時は、HZ 値の自動調整など特別な最適化が適用される。
