# API設計書

## 概要

本ドキュメントは、Ghost CMS（ヘッドレスCMS/ブログプラットフォーム）のREST APIについて記述します。GhostはAdmin APIとContent APIの2種類のAPIを提供しており、Admin APIは管理機能へのアクセスを、Content APIは公開コンテンツへの読み取り専用アクセスを提供します。

## 共通仕様

### ベースURL

```
Admin API:    /ghost/api/admin/
Content API:  /ghost/api/content/
```

### 認証方式

#### Admin API
- **セッション認証**: Cookie/セッションベースの認証（ブラウザからのアクセス用）
- **Admin APIトークン**: JWT形式のトークン（外部アプリケーション/インテグレーション用）
- **スタッフトークン**: ユーザーに紐づいたAPIキー

#### Content API
- **Content APIキー**: クエリパラメータ `key` で渡されるAPIキー
- 読み取り専用のため、限定的な認証

### 共通ヘッダー

| ヘッダー名 | 必須 | 説明 |
| --- | --- | --- |
| Authorization | ○（Admin API） | Bearer Token形式（`Ghost {token}`） |
| Content-Type | ○ | application/json |
| Accept | - | application/json |
| X-Cache-Invalidate | レスポンス | キャッシュ無効化対象パス |

### 共通クエリパラメータ

| パラメータ名 | 型 | 説明 |
| --- | --- | --- |
| include | string | 関連リソースを含める（カンマ区切り） |
| fields | string | 返却するフィールドを指定（カンマ区切り） |
| filter | string | NQL形式のフィルター条件 |
| limit | number | 取得件数の上限（デフォルト: 15, 最大: 制限あり） |
| page | number | ページ番号 |
| order | string | ソート条件（例: `created_at desc`） |

### 共通エラーレスポンス

| ステータスコード | 説明 |
| --- | --- |
| 400 | Bad Request - リクエストパラメータ不正 |
| 401 | Unauthorized - 認証エラー |
| 403 | Forbidden - 権限エラー（APIトークンの権限不足等） |
| 404 | Not Found - リソース未検出 |
| 422 | Unprocessable Entity - バリデーションエラー |
| 500 | Internal Server Error - サーバーエラー |

```json
{
  "errors": [
    {
      "message": "エラーメッセージ",
      "context": "エラーの詳細コンテキスト",
      "type": "エラータイプ",
      "help": "対処方法のヒント"
    }
  ]
}
```

## API一覧

### Admin API

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| Site | /admin/site | GET | サイト情報取得（公開） |
| Config | /admin/config | GET | 設定情報取得 |
| Posts | /admin/posts | GET | 投稿一覧取得 |
| Posts | /admin/posts | POST | 投稿作成 |
| Posts | /admin/posts/:id | GET | 投稿詳細取得 |
| Posts | /admin/posts/:id | PUT | 投稿更新 |
| Posts | /admin/posts/:id | DELETE | 投稿削除 |
| Posts | /admin/posts/bulk | PUT | 投稿一括編集 |
| Pages | /admin/pages | GET | ページ一覧取得 |
| Pages | /admin/pages | POST | ページ作成 |
| Pages | /admin/pages/:id | PUT | ページ更新 |
| Pages | /admin/pages/:id | DELETE | ページ削除 |
| Tags | /admin/tags | GET | タグ一覧取得 |
| Tags | /admin/tags | POST | タグ作成 |
| Tags | /admin/tags/:id | PUT | タグ更新 |
| Tags | /admin/tags/:id | DELETE | タグ削除 |
| Users | /admin/users | GET | ユーザー一覧取得 |
| Users | /admin/users/:id | GET | ユーザー詳細取得 |
| Users | /admin/users/:id | PUT | ユーザー更新 |
| Users | /admin/users/:id | DELETE | ユーザー削除 |
| Members | /admin/members | GET | メンバー一覧取得 |
| Members | /admin/members | POST | メンバー作成 |
| Members | /admin/members/:id | PUT | メンバー更新 |
| Members | /admin/members/:id | DELETE | メンバー削除 |
| Newsletters | /admin/newsletters | GET | ニュースレター一覧取得 |
| Newsletters | /admin/newsletters | POST | ニュースレター作成 |
| Newsletters | /admin/newsletters/:id | PUT | ニュースレター更新 |
| Themes | /admin/themes | GET | テーマ一覧取得 |
| Themes | /admin/themes/upload | POST | テーマアップロード |
| Themes | /admin/themes/:name/activate | PUT | テーマ有効化 |
| Settings | /admin/settings | GET | 設定一覧取得 |
| Settings | /admin/settings | PUT | 設定更新 |
| Session | /admin/session | POST | ログイン（セッション作成） |
| Session | /admin/session | DELETE | ログアウト（セッション削除） |
| DB | /admin/db | GET | データベースエクスポート |
| DB | /admin/db | POST | データベースインポート |
| DB | /admin/db | DELETE | 全コンテンツ削除 |
| Images | /admin/images/upload | POST | 画像アップロード |
| Media | /admin/media/upload | POST | メディアアップロード |

### Content API

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| Posts | /content/posts | GET | 公開投稿一覧取得 |
| Posts | /content/posts/:id | GET | 公開投稿詳細取得 |
| Posts | /content/posts/slug/:slug | GET | スラッグで投稿取得 |
| Pages | /content/pages | GET | 公開ページ一覧取得 |
| Pages | /content/pages/:id | GET | 公開ページ詳細取得 |
| Authors | /content/authors | GET | 著者一覧取得 |
| Authors | /content/authors/:id | GET | 著者詳細取得 |
| Tags | /content/tags | GET | タグ一覧取得 |
| Tags | /content/tags/:id | GET | タグ詳細取得 |
| Settings | /content/settings | GET | サイト設定取得 |
| Tiers | /content/tiers | GET | 料金プラン一覧取得 |
| Newsletters | /content/newsletters | GET | ニュースレター一覧取得 |

## 各APIエンドポイント定義

### Posts（投稿）

#### 1. 投稿一覧取得

投稿の一覧をページネーション付きで取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/posts` |
| 認証 | 必要（Admin API） |
| 権限 | posts.browse |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| include | string | - | - | 関連リソース（tags, authors, email, tiers, newsletter等） |
| filter | string | - | - | NQLフィルター条件 |
| fields | string | - | - | 返却フィールド指定 |
| formats | string | - | - | コンテンツフォーマット（html, mobiledoc, lexical） |
| limit | number | - | 15 | 取得件数 |
| page | number | - | 1 | ページ番号 |
| order | string | - | - | ソート条件 |
| collection | string | - | - | コレクション指定 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "posts": [
    {
      "id": "64f9a8c73d2f3c001f3b4a5b",
      "uuid": "a1b2c3d4-e5f6-7890-abcd-ef1234567890",
      "title": "記事タイトル",
      "slug": "article-slug",
      "html": "<p>記事の本文...</p>",
      "feature_image": "https://example.com/image.jpg",
      "featured": false,
      "status": "published",
      "visibility": "public",
      "created_at": "2024-01-15T10:30:00.000Z",
      "updated_at": "2024-01-16T14:20:00.000Z",
      "published_at": "2024-01-16T09:00:00.000Z",
      "authors": [],
      "tags": [],
      "primary_author": {},
      "primary_tag": null
    }
  ],
  "meta": {
    "pagination": {
      "page": 1,
      "limit": 15,
      "pages": 5,
      "total": 72,
      "next": 2,
      "prev": null
    }
  }
}
```

#### 2. 投稿作成

新しい投稿を作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/posts` |
| 認証 | 必要（Admin API） |
| 権限 | posts.add |

**リクエストボディ**

```json
{
  "posts": [
    {
      "title": "新しい記事",
      "lexical": "{\"root\":{\"children\":[...],\"type\":\"root\"}}",
      "status": "draft",
      "tags": [{"name": "タグ名"}],
      "authors": [{"id": "author-id"}],
      "feature_image": "https://example.com/image.jpg",
      "visibility": "public"
    }
  ]
}
```

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| title | string | ○ | 記事タイトル |
| lexical | string | - | Lexicalエディタ形式のコンテンツ |
| html | string | - | HTMLコンテンツ（sourceオプション使用時） |
| status | string | - | draft / published / scheduled |
| visibility | string | - | public / members / paid / tiers |
| tags | array | - | タグの配列 |
| authors | array | - | 著者の配列 |
| feature_image | string | - | アイキャッチ画像URL |
| published_at | string | - | 公開日時（ISO 8601形式） |

**レスポンス（成功時）**

ステータスコード: `201 Created`

```json
{
  "posts": [
    {
      "id": "64f9a8c73d2f3c001f3b4a5c",
      "title": "新しい記事",
      "slug": "new-article",
      "status": "draft",
      ...
    }
  ]
}
```

#### 3. 投稿更新

既存の投稿を更新します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `PUT /admin/posts/:id` |
| 認証 | 必要（Admin API） |
| 権限 | posts.edit |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| id | string | ○ | 投稿ID |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| newsletter | string | - | ニュースレターIDまたはslug（公開時に送信） |
| email_segment | string | - | メールセグメント |
| force_rerender | boolean | - | 強制再レンダリング |
| save_revision | boolean | - | リビジョン保存 |

**リクエストボディ**

```json
{
  "posts": [
    {
      "title": "更新されたタイトル",
      "updated_at": "2024-01-16T14:20:00.000Z"
    }
  ]
}
```

**レスポンス（成功時）**

ステータスコード: `200 OK`

#### 4. 投稿削除

投稿を削除します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `DELETE /admin/posts/:id` |
| 認証 | 必要（Admin API） |
| 権限 | posts.destroy |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| id | string | ○ | 投稿ID |

**レスポンス（成功時）**

ステータスコード: `204 No Content`

#### 5. 投稿一括編集

複数の投稿を一括で編集します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `PUT /admin/posts/bulk` |
| 認証 | 必要（Admin API） |
| 権限 | posts.edit |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| filter | string | ○ | 対象投稿のフィルター条件 |

**リクエストボディ**

```json
{
  "bulk": {
    "action": "addTag",
    "meta": {
      "tags": [{"id": "tag-id"}]
    }
  }
}
```

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| action | string | ○ | 実行するアクション |
| meta | object | - | アクション固有のメタデータ |

**レスポンス（成功時）**

ステータスコード: `200 OK`

---

### Members（メンバー）

#### 1. メンバー一覧取得

メンバー（購読者）の一覧を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/members` |
| 認証 | 必要（Admin API） |
| 権限 | members.browse |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| include | string | - | email_recipients, products, tiers |
| filter | string | - | NQLフィルター |
| search | string | - | 検索クエリ |
| limit | number | - | 取得件数 |
| page | number | - | ページ番号 |
| order | string | - | ソート条件 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "members": [
    {
      "id": "64f9a8c73d2f3c001f3b4a5d",
      "uuid": "member-uuid",
      "email": "member@example.com",
      "name": "会員名",
      "status": "free",
      "subscribed": true,
      "created_at": "2024-01-10T12:00:00.000Z",
      "tiers": [],
      "newsletters": []
    }
  ],
  "meta": {
    "pagination": {...}
  }
}
```

#### 2. メンバー作成

新しいメンバーを作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/members` |
| 認証 | 必要（Admin API） |
| 権限 | members.add |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| send_email | boolean | - | ウェルカムメールを送信するか |
| email_type | string | - | signin / signup / subscribe |

**リクエストボディ**

```json
{
  "members": [
    {
      "email": "new-member@example.com",
      "name": "新規メンバー",
      "labels": [{"name": "ラベル名"}],
      "note": "管理者メモ",
      "subscribed": true,
      "newsletters": [{"id": "newsletter-id"}]
    }
  ]
}
```

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| email | string | ○ | メールアドレス |
| name | string | - | 表示名 |
| labels | array | - | ラベルの配列 |
| note | string | - | 管理者用メモ |
| subscribed | boolean | - | ニュースレター購読状態 |
| newsletters | array | - | 購読するニュースレター |

**レスポンス（成功時）**

ステータスコード: `201 Created`

#### 3. メンバーCSVエクスポート

メンバー情報をCSV形式でエクスポートします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/members/upload` |
| 認証 | 必要（Admin API） |
| 権限 | members.browse |

**レスポンス（成功時）**

ステータスコード: `200 OK`
Content-Type: `text/csv`
Content-Disposition: `attachment; filename=members.{date}.csv`

#### 4. メンバーCSVインポート

CSVファイルからメンバーを一括インポートします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/members/upload` |
| 認証 | 必要（Admin API） |
| 権限 | members.add |

**リクエストボディ（multipart/form-data）**

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| membersfile | file | ○ | CSVファイル |
| mapping | object | - | ヘッダーマッピング |
| labels | array | - | 共通ラベル |

**レスポンス（成功時）**

ステータスコード: `201 Created` または `202 Accepted`（バックグラウンド処理時）

---

### Users（ユーザー）

#### 1. ユーザー一覧取得

管理者ユーザーの一覧を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/users` |
| 認証 | 必要（Admin API） |
| 権限 | users.browse |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| include | string | - | count.posts, permissions, roles, roles.permissions |
| filter | string | - | NQLフィルター |
| limit | number | - | 取得件数 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "users": [
    {
      "id": "user-id",
      "name": "ユーザー名",
      "slug": "user-slug",
      "email": "user@example.com",
      "profile_image": "https://...",
      "cover_image": null,
      "bio": "プロフィール説明",
      "website": "https://...",
      "location": "Tokyo",
      "status": "active",
      "roles": [
        {
          "id": "role-id",
          "name": "Administrator"
        }
      ]
    }
  ]
}
```

#### 2. パスワード変更

ユーザーのパスワードを変更します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `PUT /admin/users/password` |
| 認証 | 必要（Admin API） |
| 権限 | users.edit（自分自身のみ） |

**リクエストボディ**

```json
{
  "password": [
    {
      "user_id": "user-id",
      "oldPassword": "現在のパスワード",
      "newPassword": "新しいパスワード",
      "ne2Password": "新しいパスワード（確認）"
    }
  ]
}
```

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| user_id | string | ○ | ユーザーID |
| oldPassword | string | - | 現在のパスワード |
| newPassword | string | ○ | 新しいパスワード |
| ne2Password | string | ○ | 新しいパスワード（確認用） |

**レスポンス（成功時）**

ステータスコード: `200 OK`

---

### Tags（タグ）

#### 1. タグ一覧取得

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/tags` |
| 認証 | 必要（Admin API） |
| 権限 | tags.browse |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| include | string | - | count.posts |
| filter | string | - | NQLフィルター |
| limit | number | - | 取得件数 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "tags": [
    {
      "id": "tag-id",
      "name": "タグ名",
      "slug": "tag-slug",
      "description": "タグの説明",
      "feature_image": null,
      "visibility": "public",
      "count": {
        "posts": 10
      }
    }
  ]
}
```

#### 2. タグ作成

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/tags` |
| 認証 | 必要（Admin API） |
| 権限 | tags.add |

**リクエストボディ**

```json
{
  "tags": [
    {
      "name": "新しいタグ",
      "slug": "new-tag",
      "description": "タグの説明"
    }
  ]
}
```

**レスポンス（成功時）**

ステータスコード: `201 Created`

---

### Newsletters（ニュースレター）

#### 1. ニュースレター一覧取得

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/newsletters` |
| 認証 | 必要（Admin API） |
| 権限 | newsletters.browse |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| include | string | - | count.posts, count.members, count.active_members |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "newsletters": [
    {
      "id": "newsletter-id",
      "uuid": "uuid",
      "name": "ニュースレター名",
      "slug": "newsletter-slug",
      "status": "active",
      "subscribe_on_signup": true,
      "sort_order": 0,
      "sender_name": "送信者名",
      "sender_email": "sender@example.com"
    }
  ]
}
```

#### 2. ニュースレター作成

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/newsletters` |
| 認証 | 必要（Admin API） |
| 権限 | newsletters.add |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| opt_in_existing | boolean | - | 既存メンバーを自動購読させるか |

**リクエストボディ**

```json
{
  "newsletters": [
    {
      "name": "新しいニュースレター",
      "sender_name": "送信者名",
      "sender_email": "sender@example.com",
      "subscribe_on_signup": true
    }
  ]
}
```

**レスポンス（成功時）**

ステータスコード: `201 Created`

---

### Themes（テーマ）

#### 1. テーマ一覧取得

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/themes` |
| 認証 | 必要（Admin API） |
| 権限 | themes.browse |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "themes": [
    {
      "name": "casper",
      "package": {
        "name": "casper",
        "version": "5.0.0"
      },
      "active": true
    }
  ]
}
```

#### 2. テーマアップロード

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/themes/upload` |
| 認証 | 必要（Admin API） |
| 権限 | themes.add |

**リクエストボディ（multipart/form-data）**

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| file | file | ○ | テーマのZIPファイル |

**レスポンス（成功時）**

ステータスコード: `200 OK`

#### 3. テーマ有効化

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `PUT /admin/themes/:name/activate` |
| 認証 | 必要（Admin API） |
| 権限 | themes.activate |

**パスパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| name | string | ○ | テーマ名 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

---

### Session（認証）

#### 1. ログイン

セッションを作成してログインします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/session` |
| 認証 | 不要 |
| レート制限 | brute force対策あり |

**リクエストボディ**

```json
{
  "username": "user@example.com",
  "password": "password123"
}
```

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| username | string | ○ | メールアドレス |
| password | string | ○ | パスワード |

**レスポンス（成功時）**

ステータスコード: `201 Created`
Set-Cookie: ghost-admin-api-session={session_token}

#### 2. ログアウト

セッションを削除してログアウトします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `DELETE /admin/session` |
| 認証 | 必要 |

**レスポンス（成功時）**

ステータスコード: `204 No Content`

---

### Settings（設定）

#### 1. 設定一覧取得

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/settings` |
| 認証 | 必要（Admin API） |
| 権限 | settings.browse |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| group | string | - | 設定グループでフィルター |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "settings": [
    {
      "key": "title",
      "value": "サイトタイトル"
    },
    {
      "key": "description",
      "value": "サイトの説明"
    }
  ]
}
```

#### 2. 設定更新

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `PUT /admin/settings` |
| 認証 | 必要（Admin API） |
| 権限 | settings.edit |

**リクエストボディ**

```json
{
  "settings": [
    {
      "key": "title",
      "value": "新しいサイトタイトル"
    }
  ]
}
```

**レスポンス（成功時）**

ステータスコード: `200 OK`

---

### Database（データベース）

#### 1. コンテンツエクスポート

サイトのコンテンツをJSON形式でエクスポートします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /admin/db` |
| 認証 | 必要（Admin API） |
| 権限 | db.exportContent |

**レスポンス（成功時）**

ステータスコード: `200 OK`
Content-Disposition: attachment; filename=ghost.{date}.json

#### 2. コンテンツインポート

JSONファイルからコンテンツをインポートします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/db` |
| 認証 | 必要（Admin API） |
| 権限 | db.importContent |

**リクエストボディ（multipart/form-data）**

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| importfile | file | ○ | インポートするJSONファイル |

**レスポンス（成功時）**

ステータスコード: `200 OK` または `202 Accepted`

#### 3. 全コンテンツ削除

全ての投稿とタグを削除します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `DELETE /admin/db` |
| 認証 | 必要（Admin API - スタッフトークンでは不可） |
| 権限 | db.deleteAllContent |

**レスポンス（成功時）**

ステータスコード: `204 No Content`

---

### Images/Media/Files（メディアアップロード）

#### 1. 画像アップロード

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/images/upload` |
| 認証 | 必要（Admin API） |
| 権限 | images.add |

**リクエストボディ（multipart/form-data）**

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| file | file | ○ | 画像ファイル |

**レスポンス（成功時）**

ステータスコード: `201 Created`

```json
{
  "images": [
    {
      "url": "https://example.com/content/images/2024/01/image.jpg"
    }
  ]
}
```

#### 2. メディアアップロード

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /admin/media/upload` |
| 認証 | 必要（Admin API） |
| 権限 | media.add |

**リクエストボディ（multipart/form-data）**

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| file | file | ○ | メディアファイル（動画/音声） |
| thumbnail | file | - | サムネイル画像 |

**レスポンス（成功時）**

ステータスコード: `201 Created`

---

### Content API エンドポイント

Content APIは公開コンテンツへの読み取り専用アクセスを提供します。

#### 公開投稿一覧取得

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /content/posts` |
| 認証 | Content API Key（クエリパラメータ） |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| key | string | ○ | Content APIキー |
| include | string | - | authors, tags |
| filter | string | - | NQLフィルター |
| limit | number | - | 取得件数 |
| page | number | - | ページ番号 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "posts": [
    {
      "id": "post-id",
      "title": "記事タイトル",
      "slug": "article-slug",
      "html": "<p>本文...</p>",
      "feature_image": "https://...",
      "visibility": "public",
      "published_at": "2024-01-16T09:00:00.000Z"
    }
  ],
  "meta": {
    "pagination": {...}
  }
}
```

---

## インテグレーション（API トークン権限）

Admin APIトークン（インテグレーション）で許可されているエンドポイント：

| リソース | 許可メソッド |
| --- | --- |
| site | GET |
| posts | GET, PUT, DELETE, POST |
| pages | GET, PUT, DELETE, POST |
| images | POST |
| webhooks | POST, PUT, DELETE |
| actions | GET |
| tags | GET, PUT, DELETE, POST |
| labels | GET, PUT, DELETE, POST |
| users | GET |
| roles | GET |
| invites | POST |
| themes | POST, PUT |
| members | GET, PUT, DELETE, POST |
| tiers | GET, PUT, POST |
| offers | GET, PUT, POST |
| newsletters | GET, PUT, POST |
| config | GET |
| explore | GET |
| schedules | PUT |
| files | POST |
| media | POST |
| db | GET, POST |
| settings | GET |
| comments | GET, POST, PUT |
| oembed | GET |
| search-index | GET |

## 備考

- 全てのリクエストはHTTPS経由で行うことを推奨
- レート制限が一部エンドポイントに適用（ログイン試行、パスワードリセット等）
- `updated_at` フィールドは楽観的ロック制御に使用される
- 公開状態の変更は `X-Cache-Invalidate: /*` ヘッダーでキャッシュ無効化をトリガー
- NQL（Ghost Query Language）を使用した高度なフィルタリングが可能
