---
generated_at: 2026-01-29 12:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **レート制限の詳細値**：具体的な制限値はコードから特定困難
  2. **NQL文法の詳細**：外部ライブラリに依存、完全な仕様は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/web/api/endpoints/admin/routes.js`（Admin APIルーティング定義）
- E-02: `ghost/core/core/server/web/api/endpoints/content/routes.js`（Content APIルーティング定義）
- E-03: `ghost/core/core/server/web/api/endpoints/admin/middleware.js`（Admin API認証ミドルウェア）
- E-04: `ghost/core/core/server/web/api/endpoints/content/middleware.js`（Content API認証ミドルウェア）
- E-05: `ghost/core/core/server/api/endpoints/posts.js`（Posts APIコントローラー）
- E-06: `ghost/core/core/server/api/endpoints/members.js`（Members APIコントローラー）
- E-07: `ghost/core/core/server/api/endpoints/users.js`（Users APIコントローラー）
- E-08: `ghost/core/core/server/api/endpoints/tags.js`（Tags APIコントローラー）
- E-09: `ghost/core/core/server/api/endpoints/session.js`（Session APIコントローラー）
- E-10: `ghost/core/core/server/api/endpoints/newsletters.js`（Newsletters APIコントローラー）
- E-11: `ghost/core/core/server/api/endpoints/themes.js`（Themes APIコントローラー）
- E-12: `ghost/core/core/server/api/endpoints/settings.js`（Settings APIコントローラー）
- E-13: `ghost/core/core/server/api/endpoints/authentication.js`（Authentication APIコントローラー）
- E-14: `ghost/core/core/server/api/endpoints/db.js`（Database APIコントローラー）
- E-15: `ghost/core/core/server/api/endpoints/index.js`（APIエンドポイント一覧）
- E-16: `ghost/core/core/server/web/api/app.js`（API アプリケーション設定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Admin APIのベースURLは `/ghost/api/admin/` | E-16 | ○ |
| C-02 | Content APIのベースURLは `/ghost/api/content/` | E-16 | ○ |
| C-03 | Admin APIはセッション認証とAPIトークン認証をサポート | E-03 | ○ |
| C-04 | Content APIはAPIキー認証（クエリパラメータ）を使用 | E-04 | ○ |
| C-05 | GET /admin/posts で投稿一覧を取得 | E-01, E-05 | ○ |
| C-06 | POST /admin/posts で投稿を作成 | E-01, E-05 | ○ |
| C-07 | PUT /admin/posts/:id で投稿を更新 | E-01, E-05 | ○ |
| C-08 | DELETE /admin/posts/:id で投稿を削除 | E-01, E-05 | ○ |
| C-09 | PUT /admin/posts/bulk で一括編集 | E-01, E-05 | ○ |
| C-10 | Postsのincludeパラメータにtags, authors等が使用可能 | E-05 | ○ |
| C-11 | 投稿作成時のステータスコードは201 | E-05 | ○ |
| C-12 | 投稿削除時のステータスコードは204 | E-05 | ○ |
| C-13 | GET /admin/members でメンバー一覧を取得 | E-01, E-06 | ○ |
| C-14 | POST /admin/members でメンバーを作成 | E-01, E-06 | ○ |
| C-15 | メンバー作成にはemail必須 | E-06 | ○ |
| C-16 | GET /admin/members/upload でCSVエクスポート | E-01, E-06 | ○ |
| C-17 | POST /admin/members/upload でCSVインポート | E-01, E-06 | ○ |
| C-18 | GET /admin/users でユーザー一覧を取得 | E-01, E-07 | ○ |
| C-19 | PUT /admin/users/password でパスワード変更 | E-01, E-07 | ○ |
| C-20 | パスワード変更にはnewPassword, ne2Password, user_id必須 | E-07 | ○ |
| C-21 | GET /admin/tags でタグ一覧を取得 | E-01, E-08 | ○ |
| C-22 | POST /admin/tags でタグを作成 | E-01, E-08 | ○ |
| C-23 | タグ作成時のステータスコードは201 | E-08 | ○ |
| C-24 | POST /admin/session でログイン | E-01, E-09 | ○ |
| C-25 | DELETE /admin/session でログアウト | E-01, E-09 | ○ |
| C-26 | ログインにはusernameとpasswordが必要 | E-09 | ○ |
| C-27 | GET /admin/newsletters でニュースレター一覧を取得 | E-01, E-10 | ○ |
| C-28 | POST /admin/newsletters でニュースレターを作成 | E-01, E-10 | ○ |
| C-29 | GET /admin/themes でテーマ一覧を取得 | E-01, E-11 | ○ |
| C-30 | POST /admin/themes/upload でテーマをアップロード | E-01, E-11 | ○ |
| C-31 | PUT /admin/themes/:name/activate でテーマを有効化 | E-01, E-11 | ○ |
| C-32 | テーマ削除時のステータスコードは204 | E-11 | ○ |
| C-33 | GET /admin/settings で設定一覧を取得 | E-01, E-12 | ○ |
| C-34 | PUT /admin/settings で設定を更新 | E-01, E-12 | ○ |
| C-35 | GET /admin/db でコンテンツをエクスポート | E-01, E-14 | ○ |
| C-36 | POST /admin/db でコンテンツをインポート | E-01, E-14 | ○ |
| C-37 | DELETE /admin/db で全コンテンツを削除 | E-01, E-14 | ○ |
| C-38 | 全コンテンツ削除時のステータスコードは204 | E-14 | ○ |
| C-39 | スタッフトークンではDELETE /db とPUT /users/owner が禁止 | E-03 | ○ |
| C-40 | インテグレーショントークンの許可リストが定義されている | E-03 | ○ |
| C-41 | Content APIでGET /content/posts が利用可能 | E-02 | ○ |
| C-42 | Content APIでGET /content/authors が利用可能 | E-02 | ○ |
| C-43 | Content APIでGET /content/tags が利用可能 | E-02 | ○ |
| C-44 | レート制限がログイン試行等に適用される | E-01（brute参照） | △ |
| C-45 | NQL形式のフィルタリングがサポートされている | E-05（filter参照） | △ |

## 4) 不足情報（Unknown / Missing）
- **レート制限の詳細仕様**：brute force対策のミドルウェアは参照されているが、具体的な制限値（試行回数、ロック時間等）はコードベースの他の場所で定義されている可能性あり
  - 候補：`ghost/core/core/server/web/shared/middleware/brute.js` / 設定ファイル / 環境変数
- **NQL（Ghost Query Language）の完全な文法仕様**：外部ライブラリ `@tryghost/nql` に依存
  - 候補：ライブラリのドキュメント / Ghost公式ドキュメント / ライブラリソースコード

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：APIエンドポイントのパス、HTTPメソッド - ソースコードから直接確認
- **0（低リスク）**：リクエスト/レスポンス形式 - コントローラーのバリデーション定義から確認
- **1（中リスク）**：認証・認可の詳細 - ミドルウェアの実装詳細は確認したが、実際の動作はテストで検証推奨
- **1（中リスク）**：ステータスコード - コードで明示されているものは正確、暗黙的なもの（200等）は要確認
- **2（高リスク）**：レート制限の具体値 - 根拠が不足、運用前に確認必要

## 6) レビュアーチェックリスト（最小）
- [ ] Admin APIの認証フローを実際にテストして動作確認
- [ ] Content APIキーの発行・管理方法を確認
- [ ] インテグレーショントークンの権限リストが最新かどうか確認
- [ ] レート制限の詳細仕様を別途調査・補完
- [ ] NQLフィルタの使用例を公式ドキュメントと照合
- [ ] 本番環境でのHTTPS強制設定を確認
- [ ] ファイルアップロードのサイズ制限・許可形式を確認
