# Ghost

## 概要

Ghostは、プロフェッショナルなパブリッシングプラットフォームとして設計されたオープンソースのヘッドレスCMS（コンテンツ管理システム）です。ブログ、ニュースレター、有料メンバーシップ機能を統合し、クリエイターやパブリッシャーがコンテンツを収益化できるプラットフォームを提供します。Yarn v1 + Nxを使用したモノレポ構成で開発されています。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| コンテンツ管理 | Markdownベースの記事作成、Lexicalエディタによるリッチコンテンツ編集 |
| メンバーシップ | 有料/無料会員管理、Stripe連携による課金システム |
| ニュースレター | メール配信機能、Mailgun連携 |
| テーマシステム | Handlebarsテンプレートによるカスタマイズ可能なフロントエンド |
| 管理画面 | Ember.js/Reactベースの管理インターフェース |
| API | Content API、Admin API、Webhookによる外部連携 |
| 多言語対応 | 60以上の言語をサポートするi18n機能 |
| 分析機能 | サイト訪問者・会員の分析ダッシュボード |
| ActivityPub | 分散型ソーシャルネットワーク対応（Fediverse連携） |

## 技術スタック

### コア

- フレームワーク: Express.js (Node.js)
- 言語: JavaScript / TypeScript
- データベース: MySQL（本番）、SQLite（開発/テスト用）
- ORM: Bookshelf.js + Knex.js
- キャッシュ: Redis
- メールサービス: Mailgun / Nodemailer
- 決済: Stripe

### 主要ライブラリ

- **フロントエンド（Admin）**: Ember.js 3.24（Octane）、React 18
- **ビルドツール**: Nx（モノレポ管理）、Vite、Webpack
- **テスト**: Mocha、Playwright、Vitest
- **デザインシステム**: shade（新）、admin-x-design-system（レガシー）
- **UIライブラリ**: Radix UI、TailwindCSS、shadcn/ui
- **状態管理**: @tanstack/react-query
- **i18n**: i18next
- **リッチエディタ**: @tryghost/koenig-lexical

## ディレクトリ構成

```
Ghost/
├── ghost/                    # コアGhostパッケージ
│   ├── core/                 # メインGhostアプリケーション
│   │   ├── core/
│   │   │   ├── server/       # Node.js/Express バックエンド
│   │   │   │   ├── api/      # APIルート
│   │   │   │   ├── models/   # データモデル
│   │   │   │   ├── services/ # ビジネスロジック
│   │   │   │   └── data/     # スキーマ・マイグレーション
│   │   │   ├── frontend/     # テーマレンダリング
│   │   │   └── shared/       # 共通ユーティリティ
│   │   └── test/             # テストファイル
│   ├── admin/                # Ember.js 管理画面（レガシー）
│   ├── i18n/                 # 国際化・翻訳ファイル
│   └── parse-email-address/  # メールアドレスパーサー
├── apps/                     # React UIアプリケーション
│   ├── admin-x-settings/     # 設定画面（React）
│   ├── admin-x-framework/    # 共通APIフック・ルーティング
│   ├── shade/                # 新デザインシステム
│   ├── admin-x-design-system/# レガシーデザインシステム
│   ├── portal/               # 会員ポータル（公開アプリ）
│   ├── comments-ui/          # コメント機能（公開アプリ）
│   ├── signup-form/          # 登録フォーム（公開アプリ）
│   ├── sodo-search/          # 検索機能（公開アプリ）
│   ├── announcement-bar/     # 告知バー（公開アプリ）
│   ├── posts/                # 投稿分析
│   ├── stats/                # サイト統計
│   └── activitypub/          # ActivityPub連携
├── e2e/                      # E2Eテスト（Playwright）
├── docker/                   # Docker設定
├── .github/                  # CI/CD・GitHub設定
└── docs/                     # ドキュメント
```

## セットアップ

### 必要条件

- Node.js ^22.13.1
- Yarn v1（npmは使用不可）
- Docker & Docker Compose（推奨）
- MySQL 8.x または SQLite

### インストール手順

```bash
# 1. リポジトリのクローン
git clone https://github.com/TryGhost/Ghost.git
cd Ghost

# 2. 初回セットアップ（依存関係 + サブモジュール初期化）
yarn setup

# 3. 開発サーバー起動（Docker + ホストフロントエンド）
yarn dev
```

### アクセス先

| サービス | URL |
| --- | --- |
| Ghost本体 | http://localhost:2368 |
| Mailpit（メールテスト） | http://localhost:8025 |
| MySQL | localhost:3306 |
| Redis | localhost:6379 |

## 開発

### 主要コマンド

```bash
# 開発
yarn dev                # Docker + フロントエンド開発サーバー起動
yarn dev:legacy         # Dockerなしでローカル開発（非推奨）
yarn build              # 全パッケージビルド

# テスト
yarn test:unit          # ユニットテスト（全パッケージ）
yarn test:e2e           # E2Eテスト（Playwright）
yarn lint               # リント（全パッケージ）

# ghost/core内
cd ghost/core
yarn test:unit          # ユニットテスト
yarn test:integration   # 統合テスト
yarn test:e2e           # E2E APIテスト
yarn test:browser       # ブラウザテスト

# データベース
yarn knex-migrator migrate    # マイグレーション実行
yarn reset:data               # テストデータでリセット（会員1000件、投稿100件）
yarn reset:data:empty         # 空データでリセット

# Docker
yarn docker:build       # Dockerイメージビルド
yarn docker:shell       # Ghostコンテナでシェル起動
yarn docker:mysql       # MySQL CLIアクセス
yarn docker:reset       # 全Dockerボリュームリセット
```

### リント・フォーマット

```bash
# 全体
yarn lint

# 個別
cd ghost/core && yarn lint    # Ghost Core
cd ghost/admin && yarn lint   # Ember Admin
```

### テスト実行

```bash
# ルートから実行
yarn test:unit                # 全パッケージのユニットテスト
yarn test:e2e                 # Playwrightブラウザテスト

# 単一テスト実行（ghost/core内）
cd ghost/core
yarn test:single test/unit/path/to/test.test.js
```

### ビルド依存関係（Nx管理）

以下の順序でNxが自動的にビルドを実行します：

1. `shade` + `admin-x-design-system` ビルド
2. `admin-x-framework` ビルド
3. Admin Reactアプリ（settings, activitypub, posts, stats）ビルド
4. `ghost/admin`（Ember）ビルド + アセットコピー
5. `ghost/core` がAdmin成果物を配信
