---
generated_at: 2026-01-29 20:06:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **60以上の言語サポート**：CLAUDE.mdの記載に基づくが、実際のlocalesディレクトリ内容は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/Ghost-main/package.json`
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/Ghost-main/CLAUDE.md`
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/Ghost-main/README.md`
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/Ghost-main/ghost/core/package.json`
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/Ghost-main/ghost/admin/package.json`
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/Ghost-main/ghost/i18n/package.json`
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/Ghost-main/apps/shade/package.json`
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/Ghost-main/apps/portal/package.json`
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/Ghost-main/apps/admin-x-framework/package.json`
- E-10: ディレクトリ構造（lsコマンド結果）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GhostはオープンソースのヘッドレスCMS | E-03 (README.md: "headless Node.js CMS") | ○ |
| C-02 | Yarn v1 + Nxモノレポ構成 | E-01 (package.json: workspaces), E-02 (CLAUDE.md) | ○ |
| C-03 | フレームワークはExpress.js | E-04 (ghost/core/package.json: "express": "4.21.2") | ○ |
| C-04 | データベースはMySQL | E-04 (package.json: "mysql2": "3.15.2") | ○ |
| C-05 | ORM: Bookshelf.js + Knex.js | E-04 (package.json: "bookshelf", "knex") | ○ |
| C-06 | キャッシュはRedis | E-02 (CLAUDE.md: Docker構成にRedis記載) | ○ |
| C-07 | 決済はStripe | E-04 (package.json: "stripe": "8.222.0") | ○ |
| C-08 | メールサービスはMailgun | E-04 (package.json: "mailgun.js": "10.4.0") | ○ |
| C-09 | AdminはEmber.js 3.24 Octane | E-05 (ghost/admin/package.json: "ember-source": "3.24.0") | ○ |
| C-10 | shadeはshadcn/ui + Radix UI + TailwindCSS | E-07 (apps/shade/package.json: Radix依存関係多数) | ○ |
| C-11 | 状態管理は@tanstack/react-query | E-09 (admin-x-framework/package.json: "@tanstack/react-query") | ○ |
| C-12 | i18nはi18next | E-06 (ghost/i18n/package.json: "i18next": "23.16.8") | ○ |
| C-13 | Node.js要件は^22.13.1 | E-04 (ghost/core/package.json: engines.node) | ○ |
| C-14 | テストはMocha, Playwright, Vitest | E-04, E-07, E-08 (各package.jsonの依存関係) | ○ |
| C-15 | Ghostバージョンは6.15.0 | E-04 (ghost/core/package.json: "version": "6.15.0") | ○ |
| C-16 | 60以上の言語サポート | E-02 (CLAUDE.md: "60+ supported locales") | △ |
| C-17 | yarn devでDocker + ホスト開発 | E-02 (CLAUDE.md: yarn dev説明) | ○ |
| C-18 | Ghost URL: localhost:2368 | E-02 (CLAUDE.md: Accessing Services) | ○ |
| C-19 | Mailpit URL: localhost:8025 | E-02 (CLAUDE.md: Accessing Services) | ○ |
| C-20 | yarn setupで初回セットアップ | E-01 (package.json: scripts.setup) | ○ |
| C-21 | yarn knex-migrator migrate | E-01 (package.json: scripts.knex-migrator) | ○ |
| C-22 | yarn reset:dataで会員1000件、投稿100件 | E-01 (package.json: scripts.reset:data) | ○ |
| C-23 | ghost/core/core/server/がバックエンド | E-10 (ディレクトリ構造確認) | ○ |
| C-24 | appsディレクトリにReactアプリ群 | E-10 (apps/配下のls結果) | ○ |
| C-25 | Lexicalエディタ使用 | E-05 (ghost/admin/package.json: "@tryghost/koenig-lexical") | ○ |
| C-26 | Handlebarsテンプレート | E-04 (ghost/core/package.json: "handlebars", "express-hbs") | ○ |
| C-27 | Viteでビルド | E-07, E-08, E-09 (各apps package.jsonにvite) | ○ |
| C-28 | MITライセンス | E-03 (README.md: "MIT license") | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-16 (60以上の言語サポート)**: CLAUDE.mdの記載に基づいているが、実際の`ghost/i18n/locales/`ディレクトリの内容を直接確認していない
  - 候補：`ghost/i18n/locales/`ディレクトリの実ファイル数確認 / i18n設定ファイルの確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分の主張がpackage.jsonおよびCLAUDE.mdから直接確認可能
- **1（中リスク）**: 多言語対応の言語数（C-16）はCLAUDE.mdの記載のみに依存

## 6) レビュアーチェックリスト（最小）
- [ ] Node.jsバージョン要件（^22.13.1）が最新リリースと一致するか確認
- [ ] `ghost/i18n/locales/`ディレクトリ内の実際のロケール数を確認
- [ ] ディレクトリ構成図がプロジェクトの最新状態を反映しているか確認
- [ ] 各URLポート番号が現在の設定と一致するか確認
