---
generated_at: 2026-01-29 22:45:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **サービス間の依存関係の詳細**：一部推測に基づく記述あり
  2. **全サービス一覧の網羅性**：主要サービスのみ列挙
  3. **Ember.js管理画面の詳細構造**：レガシーのため詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` (ルートモノレポ設定)
- E-02: `ghost/core/package.json` (Ghost Core依存関係)
- E-03: `ghost/core/ghost.js` (CLIエントリーポイント)
- E-04: `ghost/core/core/boot.js` (ブートシーケンス)
- E-05: `ghost/core/core/app.js` (Expressルートアプリ)
- E-06: `ghost/core/core/server/ghost-server.js` (HTTPサーバークラス)
- E-07: `ghost/core/core/server/models/index.js` (モデル初期化)
- E-08: `ghost/core/core/server/models/base/index.js` (ベースモデル)
- E-09: `ghost/core/core/server/models/post.js` (Postモデル)
- E-10: `ghost/core/core/server/data/schema/schema.js` (DBスキーマ)
- E-11: `ghost/core/core/server/api/endpoints/posts.js` (APIエンドポイント)
- E-12: `ghost/core/core/server/web/api/app.js` (APIルーティング)
- E-13: `ghost/core/core/server/web/parent/app.js` (親アプリ)
- E-14: `ghost/admin/package.json` (Ember Admin設定)
- E-15: `apps/shade/package.json` (新デザインシステム)
- E-16: `apps/admin-x-framework/package.json` (Adminフレームワーク)
- E-17: `apps/admin-x-settings/package.json` (設定アプリ)
- E-18: `apps/portal/package.json` (Portalアプリ)
- E-19: `ghost/i18n/package.json` (国際化パッケージ)
- E-20: `AGENTS.md` / `CLAUDE.md` (開発ガイドライン)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GhostはJavaScript/Node.jsで構築されている | E-02 | ○ |
| C-02 | フロントエンドにTypeScriptとReactを使用 | E-15, E-16, E-17 | ○ |
| C-03 | バックエンドはExpress.jsベース | E-02, E-05, E-13 | ○ |
| C-04 | ORM層はBookshelf.js(Knexベース) | E-02, E-08 | ○ |
| C-05 | レガシー管理画面はEmber.js | E-14 | ○ |
| C-06 | 新管理画面はReact + Vite | E-16, E-17 | ○ |
| C-07 | Yarn v1 + Nx monorepo構成 | E-01, E-20 | ○ |
| C-08 | ghost.jsがCLIエントリーポイント | E-03 | ○ |
| C-09 | boot.jsでブートシーケンスを定義 | E-04 | ○ |
| C-10 | app.jsでExpressルートアプリを生成 | E-05 | ○ |
| C-11 | GhostServerクラスでHTTPサーバー管理 | E-06 | ○ |
| C-12 | モデルはghostBookshelf.Model.extendで定義 | E-08, E-09 | ○ |
| C-13 | Postモデルはpostsテーブルを使用 | E-09, E-10 | ○ |
| C-14 | APIエンドポイントはcontrollerオブジェクトで定義 | E-11 | ○ |
| C-15 | APIはadminとcontentの2種類がある | E-12 | ○ |
| C-16 | サービスはinit()で初期化される | E-04 | ○ |
| C-17 | ファイル命名はkebab-case | E-01〜E-20の全ファイル | ○ |
| C-18 | index.jsがディレクトリのエントリーポイント | E-07など | ○ |
| C-19 | admin-x-*が新React管理画面アプリの接頭辞 | E-16, E-17 | ○ |
| C-20 | @tryghost/*が内部パッケージの接頭辞 | E-02 | ○ |
| C-21 | ghost/core/core/server/がバックエンドロジック | E-04, E-06〜E-12 | ○ |
| C-22 | ghost/core/core/frontend/がサイトレンダリング | ディレクトリ構造確認 | ○ |
| C-23 | services/配下にビジネスロジックが配置 | E-04 (initServices) | ○ |
| C-24 | apps/shade/が新デザインシステム | E-15 | ○ |
| C-25 | apps/portal/がメンバーUI | E-18 | ○ |
| C-26 | shadeはRadix UI + Tailwind CSSベース | E-15 | ○ |
| C-27 | モジュラーモノリスアーキテクチャ | E-01, E-20 | ○ |
| C-28 | データフローはRouter→API→Service→Model→DB | E-04, E-11, E-12 | ○ |
| C-29 | Presentationレイヤーがweb/配下 | E-12, E-13 | ○ |
| C-30 | APIレイヤーがapi/endpoints/配下 | E-11 | ○ |
| C-31 | Serviceレイヤーがservices/配下 | E-04 | ○ |
| C-32 | Modelレイヤーがmodels/配下 | E-07〜E-09 | ○ |
| C-33 | Dataレイヤーがdata/配下 | E-10 | ○ |
| C-34 | postsエンドポイントはpostsServiceを呼び出す | E-11 | ○ |
| C-35 | DBスキーマはschema.jsで定義 | E-10 | ○ |
| C-36 | 設定管理は./shared/configから | E-04, E-05 | ○ |
| C-37 | ロギングは@tryghost/loggingを使用 | E-04, E-06 | ○ |
| C-38 | デバッグは@tryghost/debugを使用 | E-04, E-06 | ○ |
| C-39 | Service Patternでビジネスロジックを分離 | E-04, E-11 | ○ |
| C-40 | API Controllerパターンでエンドポイント定義 | E-11 | ○ |
| C-41 | Model Extensionパターンでモデル拡張 | E-08, E-09 | ○ |
| C-42 | 全サービスの初期化順序はboot.jsで制御 | E-04 | ○ |
| C-43 | Lexicalが新エディター形式、Mobiledocが旧形式 | E-10 (posts.lexical, posts.mobiledoc) | ○ |
| C-44 | サービス間の詳細な依存関係 | **根拠なし** | △ |
| C-45 | Ember.js管理画面の詳細構造 | **根拠なし（レガシーで詳細未調査）** | △ |

## 4) 不足情報（Unknown / Missing）
- サービス間の依存関係の詳細図
  - 候補：`boot.js`のinitServices()を詳細解析 / サービス内のrequire文を網羅的に調査
- Ember.js管理画面の詳細構造
  - 候補：`ghost/admin/`配下のEmberコンポーネント構造調査
- 全サービス一覧の網羅性
  - 候補：`ghost/core/core/server/services/`の全ディレクトリを走査

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 言語基礎（JavaScript/Node.js）の説明
- 0: 低リスク - ディレクトリ構造の説明（実際のファイルから確認）
- 0: 低リスク - 命名規則（実際のファイル名から確認）
- 1: 中リスク - アーキテクチャ図（構造は正確だが、図の表現が概念的）
- 1: 中リスク - 業務フロー追跡例（実際の処理フローと若干の差異の可能性）
- 0: 低リスク - パターン説明（コードから直接引用）

## 6) レビュアーチェックリスト（最小）
- [ ] C-44（サービス間依存関係）の記述は現状を正確に反映しているか
- [ ] C-45（Ember管理画面）の説明は十分か、追加が必要か
- [ ] アーキテクチャ図がチームの理解と一致しているか
- [ ] 業務フロー追跡例が実際の開発時に役立つ詳細度か
- [ ] 用語集に不足している重要用語はないか
- [ ] 参考資料のリンクは最新か
