---
generated_at: 2026-01-29 20:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **TTL設定の詳細**：キャッシュTTLの具体的な値はコード解析では特定困難
  2. **トランザクション分離レベル**：デフォルト設定の推測に基づく
  3. **FlexSearch利用箇所**：Admin UIでの利用は推測

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/package.json` - 依存パッケージとバージョン情報
- E-02: `ghost/core/core/boot.js` - ブートシーケンスと初期化順序
- E-03: `ghost/core/core/app.js` - ルートExpressアプリケーション定義
- E-04: `ghost/core/core/server/ghost-server.js` - HTTPサーバー実装
- E-05: `ghost/core/core/server/web/parent/backend.js` - バックエンドルーティング
- E-06: `ghost/core/core/server/data/schema/schema.js` - データベーススキーマ定義
- E-07: `compose.dev.yaml` - Docker Compose開発環境設定
- E-08: `package.json` (root) - モノレポ構成とワークスペース定義
- E-09: `ghost/admin/package.json` - Ember Admin依存関係
- E-10: `AGENTS.md` / `CLAUDE.md` - プロジェクト構造ドキュメント
- E-11: ディレクトリ構造 - `ls`コマンドによる確認
- E-12: `ghost/core/core/server/services/` - サービス一覧（66サービス確認）
- E-13: `ghost/core/core/server/models/` - モデル一覧（70モデル確認）
- E-14: `ghost/core/core/server/api/endpoints/` - APIエンドポイント一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Node.js/ExpressベースのモノレポCMS | E-01, E-08, E-10 | ○ |
| C-02 | Yarn v1 + Nx構成 | E-08, E-10 | ○ |
| C-03 | MySQL 8.4.5がプライマリDB | E-01, E-07 | ○ |
| C-04 | Redis 7.0をキャッシュに使用 | E-01, E-07 | ○ |
| C-05 | Stripeとの決済連携 | E-01, E-02 | ○ |
| C-06 | Mailgunでメール配信 | E-01, E-02 | ○ |
| C-07 | サービス指向レイヤードアーキテクチャ | E-02, E-11, E-12 | ○ |
| C-08 | 66以上のサービスが存在 | E-12 | ○ |
| C-09 | 70以上のモデルが存在 | E-13 | ○ |
| C-10 | Bookshelf.js ORMを使用 | E-01, E-06 | ○ |
| C-11 | Web Layer → API Layer → Service Layer依存 | E-02, E-05 | ○ |
| C-12 | Express 4.21.2を使用 | E-01 | ○ |
| C-13 | Handlebars 4.7.8をテンプレートに使用 | E-01 | ○ |
| C-14 | Sentry 7.120.4でエラートラッキング | E-01, E-03 | ○ |
| C-15 | @tryghost/job-managerでジョブ管理 | E-01, E-02 | ○ |
| C-16 | ghost/adminはEmber.js製 | E-09, E-10 | ○ |
| C-17 | Reactマイクロフロントエンド統合 | E-09, E-10 | ○ |
| C-18 | UMDバンドルで公開UI配信 | E-07, E-10 | ○ |
| C-19 | セッションベース認証（Staff） | E-02, E-05 | ○ |
| C-20 | JWT認証（Admin API） | E-01, E-02 | ○ |
| C-21 | Magic Link認証（Members） | E-02, E-10 | ○ |
| C-22 | 5ロールのRBAC | E-06, E-10 | ○ |
| C-23 | @tryghost/loggingでログ出力 | E-01, E-02 | ○ |
| C-24 | actions テーブルで監査ログ | E-06 | ○ |
| C-25 | @tryghost/errorsでエラーハンドリング | E-01, E-02 | ○ |
| C-26 | Knexでトランザクション管理 | E-01 | ○ |
| C-27 | Content/Members/Email/Auth等のドメイン分割 | E-11, E-12 | ○ |
| C-28 | posts, pages, tags等のコンテンツ管理 | E-12, E-14 | ○ |
| C-29 | members, tiers, offersのメンバー管理 | E-12, E-14 | ○ |
| C-30 | email-service, newsletters等のメール機能 | E-12, E-14 | ○ |
| C-31 | themes, custom-theme-settingsのテーマ管理 | E-02, E-12 | ○ |
| C-32 | activitypub, mentions, webmentionsの連携 | E-02, E-12, E-14 | ○ |
| C-33 | Caddy開発環境リバースプロキシ | E-07 | ○ |
| C-34 | Mailpit開発環境メールテスト | E-07 | ○ |
| C-35 | shadeデザインシステム（shadcn/ui） | E-10, E-11 | ○ |
| C-36 | admin-x-frameworkの共有フレームワーク | E-10, E-11 | ○ |
| C-37 | Ember → React段階的移行中 | E-10 | ○ |
| C-38 | TypeScript段階的導入 | E-01, E-10 | ○ |
| C-39 | URLサービスによるルート解決 | E-02, E-03 | ○ |
| C-40 | イベント駆動アーキテクチャ（部分的） | E-02, E-11 | ○ |
| C-41 | バックグラウンドジョブでメール配信 | E-02 | ○ |
| C-42 | Webhook受信でStripe連携 | E-02, E-12 | ○ |
| C-43 | キャッシュTTLは設定依存 | **根拠不足** | △ |
| C-44 | トランザクション分離レベルREPEATABLE READ | **根拠不足** | △ |
| C-45 | FlexSearchでAdmin UI検索 | E-09（推測） | △ |

## 4) 不足情報（Unknown / Missing）

- **キャッシュTTL設定**：cache-managerやRedis設定の具体的なTTL値は設定ファイルや環境変数で動的に決定されるため、コード解析のみでは特定困難
  - 候補：`config.development.json` / 環境変数 / `shared/config`モジュール詳細解析

- **トランザクション分離レベル**：明示的な設定がコード内で見つからず、MySQLデフォルト（REPEATABLE READ）を推測
  - 候補：Knex設定ファイル / MySQL接続オプション詳細解析

- **FlexSearch利用箇所**：`ghost/admin/package.json`に依存関係として存在するが、具体的な利用コードは未確認
  - 候補：`ghost/admin/app/`ディレクトリ内のコード解析

## 5) リスクフラグ（レビュー観点）

| リスク項目 | レベル | 説明 |
|---|---|---|
| アーキテクチャスタイル記述 | 0: 低リスク | boot.jsとディレクトリ構造から明確に特定可能 |
| ミドルウェアバージョン | 0: 低リスク | package.jsonから直接確認 |
| データフロー記述 | 1: 中リスク | boot.jsの初期化順序から推測したが、実行時の動的な挙動は未検証 |
| キャッシュ設定詳細 | 1: 中リスク | 設定依存のため環境ごとに異なる可能性 |
| セキュリティ関連（認証方式） | 0: 低リスク | AGENTS.mdとコードで確認済み |
| 外部連携設定 | 0: 低リスク | Docker Composeと依存パッケージで確認 |

## 6) レビュアーチェックリスト（最小）

- [ ] レイヤー構成が実際のディレクトリ構造と一致しているか確認
- [ ] サービス数（66+）とモデル数（70+）が最新のコードベースと一致しているか確認
- [ ] 外部連携（Stripe, Mailgun）の設定方法がドキュメント通りか確認
- [ ] キャッシュTTL設定の詳細を環境設定ファイルで補完
- [ ] 本番環境でのトランザクション分離レベルを確認
- [ ] Ember → React移行の進捗状況を最新化
- [ ] shadeデザインシステムの採用範囲を確認
