---
generated_at: 2026-01-29 22:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **本番環境スペック推奨値**：開発環境の構成ファイルから推測、本番用設定ファイル無し
  2. **バックアップ頻度・保持期間**：設定ファイルに明示的記載無し
  3. **スケーリング台数**：本番環境のスケーリング構成は未定義

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `compose.yml`
- E-02: `compose.dev.yaml`
- E-03: `compose.dev.analytics.yaml`
- E-04: `compose.dev.storage.yaml`
- E-05: `compose.object-storage.yml`
- E-06: `e2e/compose.yml`
- E-07: `Dockerfile`
- E-08: `docker/ghost-dev/Dockerfile`
- E-09: `docker/dev-gateway/Dockerfile`
- E-10: `docker/tb-cli/Dockerfile`
- E-11: `docker/caddy/Caddyfile`
- E-12: `docker/dev-gateway/Caddyfile`
- E-13: `docker/prometheus/prometheus.yml`
- E-14: `docker/grafana/dashboard.yml`
- E-15: `docker/grafana/datasources/datasource.yml`
- E-16: `ghost/core/core/shared/config/env/config.development.json`
- E-17: `ghost/core/core/shared/config/env/config.production.json`
- E-18: `ghost/core/core/shared/config/env/config.development.docker.json`
- E-19: `ghost/core/core/server/data/schema/schema.js`
- E-20: `ghost/core/package.json`
- E-21: `package.json`
- E-22: `.env.example`
- E-23: `CLAUDE.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Node.js 22.18.0 を使用 | E-07, E-08, E-20 | ○ |
| C-02 | MySQL 8.4.5 を使用 | E-01, E-02, E-06 | ○ |
| C-03 | Redis 7.0 を使用 | E-01, E-02 | ○ |
| C-04 | Caddy 2 (Alpine) をリバースプロキシとして使用 | E-09, E-11, E-12 | ○ |
| C-05 | Express.js 4.21.2 をWebフレームワークとして使用 | E-20 | ○ |
| C-06 | Ghost Core はポート 2368 で動作 | E-01, E-02, E-11, E-12 | ○ |
| C-07 | MySQL InnoDB Buffer Pool Size: 1G | E-01, E-02, E-06 | ○ |
| C-08 | MySQL Log Buffer Size: 500M | E-01, E-02, E-06 | ○ |
| C-09 | Prometheus スクレイプ間隔 15秒 | E-13 | ○ |
| C-10 | Grafana バージョン 8.5.27 | E-01 | ○ |
| C-11 | Mailpit を開発用メールサーバーとして使用 | E-01, E-02 | ○ |
| C-12 | Tinybird をアナリティクスに使用 | E-03, E-23 | ○ |
| C-13 | MinIO を S3 互換ストレージとして使用 | E-04, E-05 | ○ |
| C-14 | Stripe CLI で決済連携 | E-01, E-02, E-22 | ○ |
| C-15 | Docker ネットワーク名 ghost_dev | E-02 | ○ |
| C-16 | Docker ネットワーク名 ghost_e2e | E-06 | ○ |
| C-17 | ghost/traffic-analytics:1.0.42 イメージを使用 | E-01, E-03, E-06 | ○ |
| C-18 | tinybirdco/tinybird-local イメージを使用 | E-01, E-03, E-06 | ○ |
| C-19 | 開発環境 SQLite サポート | E-16 | ○ |
| C-20 | 本番環境 MySQL 推奨 | E-17 | ○ |
| C-21 | Redis をキャッシュ・セッション管理に使用 | E-18 | ○ |
| C-22 | 70以上のデータベーステーブル | E-19 | ○ |
| C-23 | newsletters テーブル存在 | E-19 | ○ |
| C-24 | posts テーブル存在 | E-19 | ○ |
| C-25 | members テーブル存在 | E-19 | ○ |
| C-26 | subscriptions テーブル存在 | E-19 | ○ |
| C-27 | stripe_products テーブル存在 | E-19 | ○ |
| C-28 | emails テーブル存在 | E-19 | ○ |
| C-29 | comments テーブル存在 | E-19 | ○ |
| C-30 | Knex 2.4.2 を SQL クエリビルダーとして使用 | E-20 | ○ |
| C-31 | Bookshelf 1.2.0 を ORM として使用 | E-20 | ○ |
| C-32 | Stripe SDK 8.222.0 を使用 | E-20 | ○ |
| C-33 | Mailgun.js 10.4.0 を使用 | E-20 | ○ |
| C-34 | Sentry 連携対応 | E-20 | ○ |
| C-35 | Slack Webhook 連携対応 | E-20 | ○ |
| C-36 | Prometheus メトリクス対応 (@tryghost/prometheus-metrics) | E-20 | ○ |
| C-37 | マルチステージ Docker ビルド | E-07 | ○ |
| C-38 | ヘルスチェック設定（MySQL SELECT 1） | E-01, E-02, E-06 | ○ |
| C-39 | ヘルスチェック設定（Redis ping） | E-01, E-02 | ○ |
| C-40 | Caddy transform-encoder プラグイン追加 | E-09 | ○ |
| C-41 | ActivityPub プロキシ対応 | E-12 | ○ |
| C-42 | Ghost バージョン 6.15.0 | E-20 | ○ |
| C-43 | 本番環境推奨スペック（具体的な CPU/メモリ値） | **根拠なし** | △ |
| C-44 | バックアップ頻度・保持期間（日次推奨等） | **根拠なし** | △ |
| C-45 | 本番環境スケーリング台数 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **C-43: 本番環境推奨スペック**
  - 開発環境用 Docker Compose ファイルには具体的なリソース制限（CPU/メモリ）の設定が無い
  - 候補：Ghost公式ドキュメント / Ghost(Pro)プラン仕様 / コミュニティベストプラクティス

- **C-44: バックアップ頻度・保持期間**
  - プロジェクト内にバックアップ設定ファイルや自動バックアップスクリプトが見当たらない
  - 候補：運用マニュアル / 外部バックアップサービス設定 / Kubernetes CronJob設定

- **C-45: 本番環境スケーリング台数**
  - 本リポジトリは開発環境向けの単一インスタンス構成のみ
  - 候補：Kubernetes マニフェスト / AWS ECS タスク定義 / 本番デプロイメントドキュメント

## 5) リスクフラグ（レビュー観点）

| リスク項目 | レベル | 説明 |
|---|---|---|
| 本番環境構成の推測 | 1 (中) | 開発環境構成から本番推奨を推測している部分がある |
| バックアップ設計の詳細 | 1 (中) | 具体的な頻度・保持期間は環境依存のため推奨値として記載 |
| 外部サービス認証情報 | 0 (低) | .env.example にプレースホルダーのみ記載、実値は含まれていない |
| セキュリティ設定 | 0 (低) | 開発環境設定のため本番向けの強化が必要な可能性 |

## 6) レビュアーチェックリスト（最小）

- [ ] Node.js 22.18.0 の使用が適切か（LTS バージョンとの整合性）
- [ ] MySQL 8.4 の InnoDB 設定が本番環境に適切か
- [ ] Redis のパーシステンス設定（RDB/AOF）が要件を満たすか
- [ ] Caddy の SSL 設定が本番要件を満たすか
- [ ] バックアップ戦略が RTO/RPO 要件を満たすか
- [ ] 監視アラートの閾値設定が適切か
- [ ] 外部サービス（Stripe/Mailgun/Tinybird）の本番クレデンシャル管理方法
- [ ] ネットワークセキュリティグループ/ファイアウォール設定の検討
