# インフラ構成図

## 全体システム構成図

```mermaid
graph TB
    subgraph "クライアント"
        Browser[Webブラウザ]
        API_Client[API クライアント]
    end

    subgraph "フロントエンド層"
        direction TB
        Caddy[Caddy Gateway<br/>:80, :443]
    end

    subgraph "アプリケーション層"
        direction TB
        Ghost[Ghost Core<br/>Node.js :2368]
        Admin[Admin UI<br/>Ember/React :4200]
        Portal[Portal<br/>:4175]
        Comments[Comments UI<br/>:7173]
        Search[Sodo Search<br/>:4178]
    end

    subgraph "データ層"
        direction TB
        MySQL[(MySQL 8.4<br/>:3306)]
        Redis[(Redis 7.0<br/>:6379)]
    end

    subgraph "外部サービス"
        direction TB
        Stripe[Stripe API]
        Mailgun[Mailgun]
        S3[AWS S3 / MinIO]
        Tinybird[Tinybird Analytics]
    end

    subgraph "監視・運用"
        direction TB
        Prometheus[Prometheus<br/>:9090]
        Grafana[Grafana<br/>:3000]
        Pushgateway[Pushgateway<br/>:9091]
    end

    Browser --> Caddy
    API_Client --> Caddy
    Caddy --> Ghost
    Caddy --> Admin
    Caddy --> Portal
    Caddy --> Comments
    Caddy --> Search

    Ghost --> MySQL
    Ghost --> Redis
    Ghost --> Stripe
    Ghost --> Mailgun
    Ghost --> S3
    Ghost --> Tinybird

    Ghost --> Prometheus
    Prometheus --> Grafana
    Pushgateway --> Prometheus
```

## Docker 開発環境構成図

```mermaid
graph TB
    subgraph "ホストマシン"
        subgraph "Docker Network: ghost_dev"
            subgraph "Core Services"
                GhostDev[ghost-dev<br/>Ghost Core<br/>:2368]
                Gateway[ghost-dev-gateway<br/>Caddy<br/>:80]
            end

            subgraph "Data Services"
                MySQL[ghost-dev-mysql<br/>MySQL 8.4<br/>:3306]
                Redis[ghost-dev-redis<br/>Redis 7.0<br/>:6379]
            end

            subgraph "Optional Services"
                Mailpit[ghost-dev-mailpit<br/>:1025, :8025]
                Stripe[ghost-dev-stripe<br/>Stripe CLI]
            end
        end

        subgraph "Host Dev Servers"
            AdminDev[Admin Dev Server<br/>:5174]
            PortalDev[Portal Dev Server<br/>:4175]
            CommentsDev[Comments Dev Server<br/>:7173]
            SignupDev[Signup Form Dev<br/>:6174]
            SearchDev[Search Dev Server<br/>:4178]
            AnnounceDev[Announcement Dev<br/>:4177]
        end

        subgraph "Volumes"
            MySQLData[(mysql-data)]
            RedisData[(redis-data)]
            GhostData[(ghost-dev-data)]
            GhostImages[(ghost-dev-images)]
        end
    end

    Gateway --> GhostDev
    Gateway -.-> AdminDev
    Gateway -.-> PortalDev
    Gateway -.-> CommentsDev
    Gateway -.-> SignupDev
    Gateway -.-> SearchDev
    Gateway -.-> AnnounceDev

    GhostDev --> MySQL
    GhostDev --> Redis
    GhostDev --> Mailpit
    GhostDev -.-> Stripe

    MySQL --> MySQLData
    Redis --> RedisData
    GhostDev --> GhostData
    GhostDev --> GhostImages
```

## アナリティクス構成図

```mermaid
graph LR
    subgraph "Ghost Application"
        Ghost[Ghost Core]
        Tracker[Analytics Tracker]
    end

    subgraph "Analytics Services"
        Analytics[ghost-dev-analytics<br/>Traffic Analytics<br/>:3000]
        TinyBird[ghost-dev-tinybird<br/>Tinybird Local<br/>:7181]
        TBCLI[ghost-dev-tb-cli<br/>Tinybird CLI]
    end

    subgraph "Data Flow"
        Events[Page Hit Events]
        API[Stats API]
    end

    Ghost --> Tracker
    Tracker --> Events
    Events --> Analytics
    Analytics --> TinyBird
    TBCLI --> TinyBird
    TinyBird --> API
    API --> Ghost
```

## オブジェクトストレージ構成図

```mermaid
graph TB
    subgraph "Ghost Application"
        Ghost[Ghost Core]
        S3Adapter[S3Storage Adapter]
    end

    subgraph "MinIO Services"
        MinIO[ghost-dev-minio<br/>MinIO Server<br/>:9000, :9001]
        MinIOSetup[ghost-dev-minio-setup<br/>MC CLI]
    end

    subgraph "Storage"
        Bucket[ghost-dev bucket]
        subgraph "Content Structure"
            Images[/images/]
            Media[/media/]
            Files[/files/]
        end
    end

    Ghost --> S3Adapter
    S3Adapter --> MinIO
    MinIOSetup --> MinIO
    MinIO --> Bucket
    Bucket --> Images
    Bucket --> Media
    Bucket --> Files
```

## 監視構成図

```mermaid
graph LR
    subgraph "Ghost Services"
        Ghost[Ghost Core]
        Jobs[Background Jobs]
    end

    subgraph "Metrics Collection"
        Prometheus[Prometheus<br/>:9090]
        Pushgateway[Pushgateway<br/>:9091]
    end

    subgraph "Visualization"
        Grafana[Grafana<br/>:3000]
        Dashboard[Dashboards]
    end

    Ghost -->|metrics| Prometheus
    Jobs -->|push| Pushgateway
    Pushgateway --> Prometheus
    Prometheus -->|remote_write| Grafana
    Grafana --> Dashboard
```

## データベーススキーマ関連図（主要テーブル）

```mermaid
erDiagram
    posts ||--o{ posts_tags : has
    posts ||--o{ posts_authors : has
    posts ||--o{ posts_products : has
    posts ||--|| posts_meta : has
    posts ||--o{ comments : has
    posts ||--o{ emails : generates

    users ||--o{ posts_authors : writes
    users ||--o{ roles_users : has
    roles ||--o{ roles_users : assigns

    members ||--o{ subscriptions : has
    members ||--o{ members_products : has
    members ||--o{ members_stripe_customers : has
    members ||--o{ comments : writes
    members ||--o{ members_newsletters : subscribes

    products ||--o{ members_products : has
    products ||--o{ posts_products : restricts
    products ||--o{ stripe_products : links
    products ||--o{ offers : has

    newsletters ||--o{ members_newsletters : has
    newsletters ||--o{ posts : sends

    stripe_products ||--o{ stripe_prices : has
    members_stripe_customers ||--o{ subscriptions : has

    posts {
        string id PK
        string uuid
        string title
        string slug
        text lexical
        string status
        datetime published_at
    }

    users {
        string id PK
        string name
        string email
        string password
        string status
    }

    members {
        string id PK
        string uuid
        string email
        string status
        string name
    }

    products {
        string id PK
        string name
        string slug
        string type
        integer monthly_price
        integer yearly_price
    }

    newsletters {
        string id PK
        string name
        string slug
        string status
    }
```

## ネットワークフロー図

```mermaid
sequenceDiagram
    participant Client as Client Browser
    participant Caddy as Caddy Gateway
    participant Ghost as Ghost Core
    participant MySQL as MySQL
    participant Redis as Redis
    participant Stripe as Stripe API

    Client->>Caddy: HTTPS Request
    Caddy->>Ghost: HTTP Forward

    alt Static Assets
        Ghost-->>Caddy: Cached Response
        Caddy-->>Client: Asset
    else API Request
        Ghost->>Redis: Check Cache
        alt Cache Hit
            Redis-->>Ghost: Cached Data
        else Cache Miss
            Ghost->>MySQL: Query
            MySQL-->>Ghost: Data
            Ghost->>Redis: Store Cache
        end
        Ghost-->>Caddy: JSON Response
        Caddy-->>Client: Response
    else Payment Flow
        Ghost->>Stripe: Payment Request
        Stripe-->>Ghost: Payment Result
        Ghost->>MySQL: Update Subscription
        Ghost-->>Caddy: Success Response
        Caddy-->>Client: Response
    end
```

## コンテナ起動順序図

```mermaid
flowchart TD
    subgraph "Phase 1: Infrastructure"
        MySQL[MySQL]
        Redis[Redis]
        Mailpit[Mailpit]
    end

    subgraph "Phase 2: Analytics Optional"
        TinyBird[Tinybird Local]
        TBCLI[TB CLI]
        Analytics[Analytics]
    end

    subgraph "Phase 3: Application"
        Ghost[Ghost Dev]
        Gateway[Caddy Gateway]
    end

    subgraph "Phase 4: Optional Services"
        Stripe[Stripe CLI]
        MinIO[MinIO]
    end

    MySQL -->|healthy| Ghost
    Redis -->|healthy| Ghost
    Mailpit -->|healthy| Ghost

    TinyBird -->|healthy| TBCLI
    TBCLI -->|completed| Analytics
    Analytics -->|healthy| Ghost

    Ghost -->|healthy| Gateway

    MySQL -->|healthy| MinIO
    MinIO -->|healthy| Ghost
```

## 環境別構成比較

```mermaid
graph TB
    subgraph "Development"
        DevGhost[Ghost Core]
        DevMySQL[MySQL Container]
        DevRedis[Redis Container]
        DevMailpit[Mailpit]
        DevMinIO[MinIO]
    end

    subgraph "E2E Testing"
        E2EGhost[Ghost Instance]
        E2EMySQL[MySQL tmpfs]
        E2ETinyBird[Tinybird]
        E2EMailpit[Mailpit]
    end

    subgraph "Production Recommended"
        ProdGhost[Ghost Cluster]
        ProdMySQL[Managed MySQL/RDS]
        ProdRedis[Managed Redis/ElastiCache]
        ProdS3[AWS S3]
        ProdCDN[CloudFront/CDN]
        ProdMailgun[Mailgun]
    end
```
