---
generated_at: 2026-01-29 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **HSTS設定**：設定ファイルの確認が必要
  2. **ログ保持期間**：明示的な設定が見つからない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/auth/index.js`
- E-02: `ghost/core/core/server/services/auth/authenticate.js`
- E-03: `ghost/core/core/server/services/auth/authorize.js`
- E-04: `ghost/core/core/server/services/auth/session/session-service.js`
- E-05: `ghost/core/core/server/services/auth/session/middleware.js`
- E-06: `ghost/core/core/server/services/auth/session/express-session.js`
- E-07: `ghost/core/core/server/services/auth/session/session-store.js`
- E-08: `ghost/core/core/server/services/auth/api-key/admin.js`
- E-09: `ghost/core/core/server/services/auth/api-key/content.js`
- E-10: `ghost/core/core/server/services/auth/members/index.js`
- E-11: `ghost/core/core/server/services/auth/otp.js`
- E-12: `ghost/core/core/server/services/permissions/index.js`
- E-13: `ghost/core/core/server/services/permissions/can-this.js`
- E-14: `ghost/core/core/server/models/role.js`
- E-15: `ghost/core/core/server/models/permission.js`
- E-16: `ghost/core/core/server/models/user.js`
- E-17: `ghost/core/core/server/models/action.js`
- E-18: `ghost/core/core/server/models/base/plugins/actions.js`
- E-19: `ghost/core/core/server/web/shared/middleware/brute.js`
- E-20: `ghost/core/core/server/web/shared/middleware/api/spam-prevention.js`
- E-21: `ghost/core/core/server/web/api/middleware/cors.js`
- E-22: `ghost/core/core/server/web/admin/controller.js`
- E-23: `ghost/core/core/server/api/endpoints/utils/validators/input/invitations.js`
- E-24: `ghost/core/core/server/api/endpoints/utils/validators/input/posts.js`
- E-25: `ghost/core/core/server/api/endpoints/utils/validators/input/password_reset.js`
- E-26: `ghost/core/core/frontend/apps/private-blogging/lib/middleware.js`
- E-27: `ghost/core/core/frontend/services/handlebars.js`
- E-28: `ghost/core/core/server/data/schema/schema.js`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セッション認証はexpress-sessionを使用 | E-06 | ○ |
| C-02 | セッション有効期限は6ヶ月 | E-06 (maxAge: 6 * 30 * 24 * 60 * 60 * 1000) | ○ |
| C-03 | Cookie名はghost-admin-api-session | E-06 | ○ |
| C-04 | httpOnlyはtrue | E-06 | ○ |
| C-05 | sameSiteはHTTPS時none、HTTP時lax | E-06 | ○ |
| C-06 | 2FAはTOTPベースで6桁のコードを使用 | E-11 (digits: 6, step: 60) | ○ |
| C-07 | Admin API JWT認証はHS256アルゴリズム | E-08 (algorithms: ['HS256']) | ○ |
| C-08 | JWTトークン有効期間は5分 | E-08 (maxAge: '5m') | ○ |
| C-09 | Content API認証はクエリパラメータのkey | E-09 (req.query.key) | ○ |
| C-10 | Members認証はRS512アルゴリズムのJWT | E-10 (algorithms: ['RS512']) | ○ |
| C-11 | Origin検証によるCSRF保護 | E-04 (cookieCsrfProtection関数) | ○ |
| C-12 | パスワードはbcryptでハッシュ化 | E-16 (security.password.hash) | ○ |
| C-13 | Ownerロールは全権限を持つ | E-13, E-14 (isOwner判定でバイパス) | ○ |
| C-14 | 6種類のロールが存在 | E-14, E-28 | ○ |
| C-15 | canThis APIで権限チェック | E-13 | ○ |
| C-16 | internal contextで権限バイパス | E-13 (context.internal判定) | ○ |
| C-17 | express-bruteでレート制限 | E-19, E-20 | ○ |
| C-18 | ログイン試行は5回/IPの制限 | E-20 (userLogin設定) | ○ |
| C-19 | グローバルブロックは50回/時間 | E-20 (globalBlock設定) | ○ |
| C-20 | CORSはlocalhostとサイトURLを許可 | E-21 (getAllowlist関数) | ○ |
| C-21 | X-Frame-OptionsはadminFrameProtection設定に依存 | E-22 | ○ |
| C-22 | 入力検証に@tryghost/validatorを使用 | E-23, E-25 | ○ |
| C-23 | JSON Schemaによる検証 | E-24 (jsonSchema.validate) | ○ |
| C-24 | SafeStringでXSS対策 | E-27 | ○ |
| C-25 | actionsテーブルで監査ログ管理 | E-17, E-18 | ○ |
| C-26 | CRUD操作をactionとして記録 | E-18 (actionsCollectCRUD) | ○ |
| C-27 | プライベートブログはSHA-256ハッシュ | E-26 (crypto.createHash('sha256')) | ○ |
| C-28 | プライベートブログセッションは30日 | E-26 (maxAge: 30 * 24 * 60 * 60 * 1000) | ○ |
| C-29 | パスワードはJSONシリアライズ時に除外 | E-16 (toJSON内でdelete) | ○ |
| C-30 | Bookshelf ORMでSQLインジェクション対策 | E-16, E-28 (パラメータ化クエリ使用) | ○ |
| C-31 | セッションストアはデータベース保存 | E-06, E-07 (SessionStore, SessionModel) | ○ |
| C-32 | ユーザーステータスに複数の警告状態が存在 | E-28 (warn-1 から warn-4) | ○ |
| C-33 | 404エラー時も認証要求（プライベートブログ） | E-26 (handle404関数) | ○ |
| C-34 | HSTSは設定可能 | **根拠なし** | △ |
| C-35 | ログ保持期間はデータベースに永続保存 | **根拠なし**（明示的な保持期間設定が見つからない） | △ |

## 4) 不足情報（Unknown / Missing）
- **HSTS設定の詳細**：コードベースでHSTS関連の明示的な設定が見つからない。Nginx/Caddy等のリバースプロキシで設定される可能性あり。
  - 候補：`config.*.json` / Caddyfile / docker-compose設定
- **ログ保持期間**：actionsテーブルのレコードに対する明示的な保持期間やパージ処理が見つからない。
  - 候補：スケジュールジョブ / データベースレベルの設定 / 運用ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 認証・認可の実装は標準的なライブラリを適切に使用
- **1: 中リスク** - HSTS設定の有無を確認すべき（現状不明）
- **0: 低リスク** - ブルートフォース対策は express-brute で実装済み
- **0: 低リスク** - CSRF対策はOrigin検証とSameSite Cookieで実装済み
- **0: 低リスク** - XSS対策はHandlebarsのエスケープ機能で対応

## 6) レビュアーチェックリスト（最小）
- [ ] HSTS設定がリバースプロキシ（Caddy/Nginx）で有効になっているか確認
- [ ] 監査ログの保持期間・パージポリシーが運用要件を満たしているか確認
- [ ] `admin_session_secret`が本番環境で適切に設定されているか確認
- [ ] Content APIキーの定期ローテーション運用が定義されているか確認
- [ ] express-bruteの制限値が運用要件に適合しているか確認
- [ ] 2FA（require_email_mfa）の有効化ポリシーを確認
