---
generated_at: 2026-01-29 20:15:00
metrics:
  claims_total: 42
  claims_with_evidence: 40
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：40 / 42、根拠なし：2
- 優先レビュー（高）
  1. **ステージング環境構成**：Ghost-Moya関連の詳細が外部リポジトリ
  2. **テスト担当者**：明示的な担当定義がコード上にない

## 2) 参照した情報（Evidence一覧）

- E-01: `.github/workflows/ci.yml` - CI/CDワークフロー定義
- E-02: `package.json`（ルート）- モノレポ構成、スクリプト定義
- E-03: `ghost/core/package.json` - Ghost Coreパッケージ設定、テストスクリプト
- E-04: `e2e/package.json` - E2Eテストパッケージ設定
- E-05: `ghost/admin/package.json` - Ghost Admin設定、ember-exam設定
- E-06: `ghost/core/.c8rc.json` - 単体テストカバレッジ設定
- E-07: `ghost/core/.c8rc.e2e.json` - E2E/結合テストカバレッジ設定
- E-08: `ghost/core/playwright.config.js` - Ghost Core Playwright設定
- E-09: `e2e/playwright.config.mjs` - E2E Playwright設定
- E-10: `apps/comments-ui/playwright.config.ts` - Comments-UI Playwright設定
- E-11: `apps/signup-form/playwright.config.ts` - Signup Form Playwright設定
- E-12: `apps/admin-x-settings/vitest.config.ts` - Vitest設定
- E-13: `e2e/README.md` - E2Eテストドキュメント
- E-14: `CLAUDE.md` - プロジェクト開発ガイド
- E-15: `e2e/CLAUDE.md` - E2Eテストガイド

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Mochaがテストフレームワーク（v11.7.3） | E-03 | ○ |
| C-02 | c8がカバレッジツール（v10.1.3） | E-03 | ○ |
| C-03 | Playwrightがブラウザテスト用（v1.55.1） | E-03, E-04 | ○ |
| C-04 | Vitestがadmin-x-settings等で使用 | E-12 | ○ |
| C-05 | ember-examがAdmin並列テスト用 | E-05 | ○ |
| C-06 | 単体テスト行カバレッジ目標65% | E-06 | ○ |
| C-07 | 単体テスト分岐カバレッジ目標85% | E-06 | ○ |
| C-08 | E2Eテスト行カバレッジ目標54% | E-07 | ○ |
| C-09 | E2Eテスト分岐カバレッジ目標75% | E-07 | ○ |
| C-10 | CI結合テスト行カバレッジ52% | E-01 (line 46) | ○ |
| C-11 | 8並列シャードでE2Eテスト実行 | E-01 (matrix.shardTotal: [8]) | ○ |
| C-12 | Node.js 22.18.0使用 | E-01 (NODE_VERSION) | ○ |
| C-13 | MySQL 8.0使用 | E-01 (mysql version: '8.0') | ○ |
| C-14 | SQLite3サポート | E-01 (DB: sqlite3) | ○ |
| C-15 | PR/Push時にCIトリガー | E-01 (on: pull_request, push) | ○ |
| C-16 | Slack通知あり | E-01 (SLACK_WEBHOOK_URL) | ○ |
| C-17 | 14日間HTMLレポート保持 | E-01 (retention-days: 14) | ○ |
| C-18 | Nxによるaffectedテスト実行 | E-01 (yarn nx affected) | ○ |
| C-19 | Docker Compose環境構成 | E-02 (docker:dev スクリプト) | ○ |
| C-20 | ember-mocha使用 | E-05 | ○ |
| C-21 | Sinon使用（v18.0.1） | E-03 | ○ |
| C-22 | Nock使用（v13.5.6） | E-03 | ○ |
| C-23 | hyperfine使用（v1.18.0） | E-01 (HYPERFINE_VERSION) | ○ |
| C-24 | ESLint使用（v8.57.1） | E-02 | ○ |
| C-25 | TypeScript使用（v5.8.3） | E-02, E-03 | ○ |
| C-26 | AAAパターン推奨 | E-15 (AAA Pattern) | ○ |
| C-27 | Page Objectパターン推奨 | E-15 (Page Objects) | ○ |
| C-28 | セマンティックロケータ使用 | E-15 (Locators) | ○ |
| C-29 | data-factory使用 | E-15 (Factory Pattern) | ○ |
| C-30 | テスト分離（独自DB） | E-13 (Test Isolation) | ○ |
| C-31 | ワーカー数=CPUコア/3 | E-09 (getWorkerCount) | ○ |
| C-32 | 最大5ワーカー（Stripe制限） | E-08 (Math.min(5, cpuCount - 1)) | ○ |
| C-33 | CI時100%ワーカー使用（コア） | E-08 (if CI return '100%') | ○ |
| C-34 | Chromiumブラウザ使用 | E-08, E-09, E-10, E-11 | ○ |
| C-35 | テストデータリセットコマンド | E-02 (reset:data scripts) | ○ |
| C-36 | GitHub Issues利用 | E-03 (bugs field) | ○ |
| C-37 | Codecovカバレッジ連携 | E-01 (codecov/codecov-action) | ○ |
| C-38 | Admin 2分割並列実行 | E-05 (--split 2 --parallel) | ○ |
| C-39 | E2E retries: 0 | E-09 (retries: 0) | ○ |
| C-40 | Ghost Core retries: 2（CI） | E-08 (retries: process.env.CI ? 2 : 0) | ○ |
| C-41 | ステージング環境へのデプロイ | E-01 (canary job) | △ |
| C-42 | テスト担当者の定義 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **ステージング環境の詳細構成**: Ghost-Moyaリポジトリは外部にあり、詳細なステージング環境構成は本リポジトリでは確認できません
  - 候補：Ghost-Moyaリポジトリ / インフラドキュメント / 運用ガイド
- **テスト担当者の明示的定義**: コードベース上にテスト担当者（開発者/QA）の明示的な定義はありません。一般的な開発プラクティスに基づく推定です
  - 候補：CONTRIBUTING.md / チーム運用ガイド / 開発プロセスドキュメント

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - テストツール・バージョン情報：設定ファイルから直接確認可能
- **0: 低リスク** - カバレッジ目標：.c8rc設定ファイルで明確に定義
- **0: 低リスク** - CI/CD設定：ci.yml から詳細に確認可能
- **1: 中リスク** - テスト担当者：推定に基づく記載のため、組織の実態と異なる可能性あり
- **1: 中リスク** - ステージング環境：外部リポジトリ依存のため、変更を検知できない

## 6) レビュアーチェックリスト（最小）

- [ ] カバレッジ目標値が最新の.c8rc設定と一致しているか確認
- [ ] Node.jsバージョンがci.ymlのNODE_VERSIONと一致しているか確認
- [ ] テストツールバージョンがpackage.jsonと一致しているか確認
- [ ] CI/CDジョブ名がci.ymlの実際のジョブ名と一致しているか確認
- [ ] テスト担当者の記載が組織の実態と合っているか確認
- [ ] ステージング環境の構成がGhost-Moyaの最新状態と整合しているか確認
