# テスト方針書

## 概要

本ドキュメントは、Ghost（オープンソースのプロフェッショナル出版プラットフォーム）プロジェクトのテスト方針を定義するものです。Ghostはモノレポ構成を採用しており、バックエンドコア、管理画面（Ember.js/React）、複数のフロントエンドアプリケーションを含む大規模プロジェクトです。本方針書では、各種テストレベル、テストツール、CI/CD統合、カバレッジ目標について記載します。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々の関数・モジュールの動作検証 | 開発者 |
| 結合テスト | モジュール間の連携・API連携の検証 | 開発者 |
| E2Eテスト（API） | APIエンドポイントのエンドツーエンド検証 | 開発者/QA |
| E2Eテスト（ブラウザ） | ブラウザを通じたユーザージャーニーの検証 | 開発者/QA |
| レガシーテスト | 旧バージョンとの互換性検証 | 開発者 |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | 各機能の正常動作を検証 | PR作成時、マージ時 |
| 回帰テスト | 既存機能への影響がないことを検証 | PR作成時、マージ時 |
| 性能テスト | ブート時間などのパフォーマンス測定（hyperfine使用） | main/開発ブランチへのプッシュ時 |
| i18nテスト | 多言語対応の翻訳ファイル検証 | 関連パッケージ変更時 |
| Tinybirdテスト | アナリティクスデータパイプラインの検証 | Tinybird関連ファイル変更時 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 開発者によるテスト実行 | Docker Compose（MySQL、Redis、Mailpit、Caddy） |
| CI環境（GitHub Actions） | 自動テスト実行 | Ubuntu、Docker、MySQL 8.0、SQLite3 |
| ステージング環境 | リリース前検証 | Ghost-Moya経由でデプロイ |

### データベース構成

- **MySQL 8.0**: 本番相当の結合テスト・E2Eテスト用
- **SQLite3**: 高速な単体テスト・一部の結合テスト用
- **テスト分離**: 各E2Eテストは独自のデータベースを使用し、テンプレートDBからリストア

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| Mocha | Ghost Core単体・結合・E2Eテスト実行 | 11.7.3 |
| c8 | コードカバレッジ測定 | 10.1.3 |
| Playwright | ブラウザE2Eテスト | 1.55.1 |
| Vitest | React系アプリ（admin-x-settings, posts, stats）のテスト | 設定ファイル参照 |
| ember-exam | Ghost Admin（Ember.js）テスト並列実行 | 6.0.1 |
| ember-mocha | Ghost Admin単体・受入テスト | 0.16.2 |
| Sinon | モック・スタブ・スパイ | 18.0.1 |
| Nock | HTTPリクエストモック | 13.5.6 |
| hyperfine | パフォーマンスベンチマーク | 1.18.0 |
| ESLint | 静的コード解析 | 8.57.1 |
| TypeScript | 型チェック | 5.8.3 |

## カバレッジ目標

| 対象 | 目標値 | 備考 |
| --- | --- | --- |
| 行カバレッジ（単体テスト） | 65% | .c8rc.json で設定 |
| 分岐カバレッジ（単体テスト） | 85% | .c8rc.json で設定 |
| 関数カバレッジ（単体テスト） | 65% | .c8rc.json で設定 |
| ステートメントカバレッジ（単体テスト） | 65% | .c8rc.json で設定 |
| 行カバレッジ（E2E/結合テスト） | 54% | .c8rc.e2e.json で設定 |
| 分岐カバレッジ（E2E/結合テスト） | 75% | .c8rc.e2e.json で設定 |
| 関数カバレッジ（E2E/結合テスト） | 79% | .c8rc.e2e.json で設定 |
| 行カバレッジ（CI結合テスト） | 52% | CI設定で指定 |

### カバレッジ除外対象

- マイグレーションファイル（`core/server/data/migrations/**`）
- スキーマ定義（`core/server/data/schema/schema.js`）
- フロントエンドソースファイル（`core/frontend/src/**`、`core/frontend/public/**`）
- テストモードAPI（`core/server/web/api/testmode/**`）
- 一部のサービスジョブファイル

## テストデータ

### データ準備方針

- **ファクトリパターン**: E2Eテストでは `data-factory` を使用してテストデータを生成
- **フィクスチャ**: 単体テストでは `test/utils/fixtures` 配下のテーマ・設定ファイルを使用
- **シードデータ**: `yarn reset:data` コマンドで1000メンバー・100投稿のテストデータを生成可能
- **テスト分離**: 各E2Eテストは独自のGhostインスタンスとデータベースを使用

### テストデータ管理

```bash
# テストデータのリセット（1000メンバー、100投稿）
yarn reset:data

# 空のデータベースでリセット
yarn reset:data:empty

# 大規模データ（200万メンバー）
yarn reset:data:xxl
```

## 不具合管理

- **Issue管理**: GitHub Issues（https://github.com/TryGhost/Ghost/issues）
- **テスト失敗通知**: Slack Webhook経由でチームに通知
- **テストレポート**: Playwright HTML/BlobレポートをGitHub Artifactsに保存（14日間保持）
- **トレース情報**: 失敗時に自動的にトレースを保存

## CI/CD連携

### トリガー条件

- **Pull Request**: opened, synchronize, reopened, labeled, unlabeled
- **Push**: main、vX.Y.Z（リリースブランチ）、X.x（メジャーバージョンブランチ）

### ジョブ構成

| ジョブ名 | 実行条件 | 内容 |
| --- | --- | --- |
| job_lint | コード変更時 | ESLint実行（Nx affected） |
| job_i18n | i18n関連変更時 | 翻訳ファイル検証 |
| job_unit-tests | コード変更時 | 全パッケージの単体テスト実行 |
| job_admin-tests | Admin変更時 | Ember.jsテスト（Chrome） |
| job_acceptance-tests | Core変更時 | 結合・E2E APIテスト（MySQL/SQLite） |
| job_legacy-tests | Core変更時 | レガシーテスト（MySQL/SQLite） |
| job_browser-tests | 開発ブランチ or ラベル付与時 | Playwright ブラウザテスト |
| job_e2e_tests | Docker Build成功後 | 8並列シャードでE2Eテスト実行 |
| job_admin_x_settings | Admin-X Settings変更時 | Playwright受入テスト |
| job_activitypub | ActivityPub変更時 | Playwright受入テスト |
| job_comments_ui | Comments-UI変更時 | Playwright E2Eテスト |
| job_signup_form | Signup Form変更時 | Playwright E2Eテスト |
| job_tinybird-tests | Tinybird変更時 | Tinybird CLIテスト |
| job_perf-tests | Core変更時（開発ブランチ） | パフォーマンス計測 |
| job_ghost-cli | Core変更時 | Ghost CLIアップグレードテスト |

### キャッシュ戦略

- **依存関係キャッシュ**: `node_modules`、`~/.cache/ms-playwright/`
- **Nxキャッシュ**: `.nxcache`
- **ESLintキャッシュ**: `ghost/**/.eslintcache`

### アーティファクト

| 種類 | 保持期間 | 用途 |
| --- | --- | --- |
| カバレッジレポート | Codecov連携 | カバレッジ追跡 |
| Playwright HTMLレポート | 14日間 | テスト結果確認 |
| テスト結果 | 7日間 | 失敗調査 |
| Blobレポート | 1日間 | レポートマージ用 |

### テスト実行コマンド

```bash
# 全単体テスト
yarn test:unit

# Ghost Core 単体テスト
cd ghost/core && yarn test:unit

# Ghost Core 結合テスト
cd ghost/core && yarn test:integration

# Ghost Core E2Eテスト（API）
cd ghost/core && yarn test:e2e

# ブラウザテスト
yarn test:browser

# E2Eテスト（Playwright/Docker）
yarn test:e2e

# 特定テストファイルの実行
cd ghost/core && yarn test:single test/unit/path/to/test.test.js
```

## 備考

### テスト設計原則

- **AAA パターン**: Arrange（準備）、Act（実行）、Assert（検証）の3段階で構成
- **Page Object パターン**: E2EテストではPage Objectを使用してUI要素を抽象化
- **テスト分離**: 各テストは独立して実行可能であること
- **セマンティックロケータ**: CSS/XPathセレクタではなく、`getByRole`、`getByLabel`、`data-testid` を使用

### Node.jsバージョン

- **テストマトリクス**: Node.js 22.18.0
- **エンジン要件**: Node.js ^22.13.1

### 並列実行設定

- **E2Eテスト**: 8並列シャード（CI環境）
- **Admin テスト**: ember-exam で2分割並列実行
- **Playwright**: CPU コア数の1/3をワーカー数として使用（E2E）、最大5ワーカー（Stripeレート制限対応）

### テストデバッグ

```bash
# デバッグモードでE2Eテスト
yarn test:e2e:debug

# Playwright UI モード
yarn test:e2e -- --ui

# コンテナ保持（失敗調査用）
PRESERVE_ENV=true yarn test:e2e
```
