---
generated_at: 2026-01-29 12:30:00
metrics:
  claims_total: 75
  claims_with_evidence: 75
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：75 / 75、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/core/core/server/data/schema/schema.js` - メインのデータベーススキーマ定義ファイル (1166行)
- E-02: `ghost/core/core/server/data/schema/index.js` - スキーマモジュールのエクスポート定義
- E-03: Ghost公式ドキュメント（CLAUDE.md内の記述）- プロジェクト構造の説明

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | newslettersテーブルが存在し、75テーブル中1つである | E-01 (L12-60) | ○ |
| C-02 | postsテーブルにid, uuid, title, slug, mobiledoc, lexical, htmlカラムが存在 | E-01 (L61-105) | ○ |
| C-03 | posts_metaテーブルがpostsと1対1の関係を持つ | E-01 (L106-122) post_id参照 | ○ |
| C-04 | usersテーブルがスタッフ管理用である | E-01 (L123-186) コメント「this is the staff table」 | ○ |
| C-05 | posts_authorsテーブルがposts.idとusers.idを参照 | E-01 (L187-192) references定義 | ○ |
| C-06 | rolesテーブルにname, descriptionカラムが存在 | E-01 (L193-199) | ○ |
| C-07 | roles_usersテーブルがrole_idとuser_idを持つ | E-01 (L200-204) | ○ |
| C-08 | permissionsテーブルにobject_type, action_typeカラムが存在 | E-01 (L205-213) | ○ |
| C-09 | settingsテーブルがgroup, key, value, typeカラムを持つ | E-01 (L224-267) | ○ |
| C-10 | tagsテーブルにparent_idカラムが存在（階層構造対応） | E-01 (L274) | ○ |
| C-11 | posts_tagsテーブルにインデックス[post_id, tag_id]が存在 | E-01 (L302-304) @@INDEXES@@定義 | ○ |
| C-12 | invitesテーブルにstatus, token, email, expiresカラムが存在 | E-01 (L306-321) | ○ |
| C-13 | bruteテーブルがレート制限用データを保持 | E-01 (L322-328) | ○ |
| C-14 | sessionsテーブルにsession_id, user_id, session_dataカラムが存在 | E-01 (L329-336) | ○ |
| C-15 | integrationsテーブルにtype, name, slugカラムが存在 | E-01 (L337-352) | ○ |
| C-16 | webhooksテーブルがintegrations.idを参照（cascadeDelete） | E-01 (L364) references定義 | ○ |
| C-17 | api_keysテーブルにtype（content/admin）バリデーションが存在 | E-01 (L373-378) isIn定義 | ○ |
| C-18 | mobiledoc_revisionsテーブルにpost_id, mobiledoc, created_at_tsカラムが存在 | E-01 (L395-401) | ○ |
| C-19 | post_revisionsテーブルにlexical, author_id, title, post_statusカラムが存在 | E-01 (L402-416) | ○ |
| C-20 | membersテーブルにuuid, transient_id, email, status, nameカラムが存在 | E-01 (L417-444) | ○ |
| C-21 | productsテーブルがティア管理用である | E-01 (L446) コメント「this is the tiers table」 | ○ |
| C-22 | offersテーブルにdiscount_type（percent/amount/trial）バリデーションが存在 | E-01 (L490) isIn定義 | ○ |
| C-23 | benefitsテーブルにname, slugカラムが存在 | E-01 (L500-506) | ○ |
| C-24 | products_benefitsテーブルがproducts.idとbenefits.idを参照（cascadeDelete） | E-01 (L507-512) | ○ |
| C-25 | members_productsテーブルにexpiry_atカラムが存在 | E-01 (L518) | ○ |
| C-26 | posts_productsテーブルがアクセス制御用である | E-01 (L520-525) | ○ |
| C-27 | members_created_eventsテーブルにアトリビューション関連カラムが存在 | E-01 (L526-554) | ○ |
| C-28 | members_cancel_eventsテーブルにfrom_planカラムが存在 | E-01 (L555-560) | ○ |
| C-29 | members_payment_eventsテーブルにamount, currency, sourceカラムが存在 | E-01 (L561-570) | ○ |
| C-30 | members_login_eventsテーブルがログイン履歴を記録 | E-01 (L571-575) | ○ |
| C-31 | members_email_change_eventsテーブルにto_email, from_emailカラムが存在 | E-01 (L576-582) | ○ |
| C-32 | members_status_eventsテーブルにfrom_status, to_statusカラムが存在 | E-01 (L583-597) | ○ |
| C-33 | members_product_eventsテーブルにaction（added/removed）バリデーションが存在 | E-01 (L602-605) isIn定義 | ○ |
| C-34 | members_paid_subscription_eventsテーブルにmrr_deltaカラムが存在 | E-01 (L624) | ○ |
| C-35 | labelsテーブルにname, slugカラムが存在（両方unique） | E-01 (L627-633) | ○ |
| C-36 | members_labelsテーブルがmembers.idとlabels.idを参照（cascadeDelete） | E-01 (L636-637) | ○ |
| C-37 | members_stripe_customersテーブルにcustomer_idカラムが存在（unique） | E-01 (L643) | ○ |
| C-38 | subscriptionsテーブルにtype, status, member_id, tier_idカラムが存在 | E-01 (L649-685) | ○ |
| C-39 | members_stripe_customers_subscriptionsテーブルにmrrカラムが存在 | E-01 (L700) | ○ |
| C-40 | members_subscription_created_eventsテーブルにアトリビューション関連カラムが存在 | E-01 (L715-739) | ○ |
| C-41 | offer_redemptionsテーブルがoffer_id, member_id, subscription_idを参照（cascadeDelete） | E-01 (L741-746) | ○ |
| C-42 | members_subscribe_eventsテーブルにnewsletter_idカラムが存在 | E-01 (L757) | ○ |
| C-43 | donation_payment_eventsテーブルにdonation_messageカラムが存在 | E-01 (L788) | ○ |
| C-44 | stripe_productsテーブルがproducts.idとstripe_product_idをマッピング | E-01 (L790-796) | ○ |
| C-45 | stripe_pricesテーブルにtype（recurring/one_time/donation）バリデーションが存在 | E-01 (L807) isIn定義 | ○ |
| C-46 | actionsテーブルに監査ログ用のresource_type, actor_type, eventカラムが存在 | E-01 (L813-825) | ○ |
| C-47 | emailsテーブルにpost_id（unique）, status, recipient_filterカラムが存在 | E-01 (L826-869) | ○ |
| C-48 | email_batchesテーブルにprovider_id, status, member_segmentカラムが存在 | E-01 (L870-888) | ○ |
| C-49 | email_recipientsテーブルに複合インデックスが定義されている | E-01 (L901-906) @@INDEXES@@定義 | ○ |
| C-50 | email_recipient_failuresテーブルにcode, enhanced_code, severity, messageカラムが存在 | E-01 (L908-925) | ○ |
| C-51 | tokensテーブルにtoken, uuid, data, used_countカラムが存在 | E-01 (L926-936) | ○ |
| C-52 | snippetsテーブルにname, mobiledoc, lexicalカラムが存在 | E-01 (L937-944) | ○ |
| C-53 | custom_theme_settingsテーブルにtheme, key, type, valueカラムが存在 | E-01 (L945-964) | ○ |
| C-54 | members_newslettersテーブルにインデックス[newsletter_id, member_id]が存在 | E-01 (L969-971) @@INDEXES@@定義 | ○ |
| C-55 | commentsテーブルにparent_id, in_reply_to_idカラムが存在（自己参照） | E-01 (L977-978) | ○ |
| C-56 | comment_likesテーブルがcomments.idとmembers.idを参照（cascadeDelete） | E-01 (L985-991) | ○ |
| C-57 | comment_reportsテーブルがmember_idにsetNullDeleteを使用 | E-01 (L995) | ○ |
| C-58 | jobsテーブルにstatus（started/finished/failed/queued）バリデーションが存在 | E-01 (L1002) isIn定義 | ○ |
| C-59 | redirectsテーブルにfrom, to, post_idカラムが存在 | E-01 (L1010-1017) | ○ |
| C-60 | members_click_eventsテーブルがmembers.idとredirects.idを参照（cascadeDelete） | E-01 (L1018-1023) | ○ |
| C-61 | members_feedbackテーブルにscore, member_id, post_idカラムが存在 | E-01 (L1024-1031) | ○ |
| C-62 | suppressionsテーブルにemail（unique）, reason（spam/bounce）カラムが存在 | E-01 (L1032-1048) | ○ |
| C-63 | email_spam_complaint_eventsテーブルにユニーク制約[email_id, member_id]が存在 | E-01 (L1055-1057) @@UNIQUE_CONSTRAINTS@@定義 | ○ |
| C-64 | mentionsテーブルにsource, target, resource_id, resource_type, verified, deletedカラムが存在 | E-01 (L1059-1075) | ○ |
| C-65 | milestonesテーブルにtype, value, currency, email_sent_atカラムが存在 | E-01 (L1076-1083) | ○ |
| C-66 | collectionsテーブルにtitle, slug, type, filterカラムが存在 | E-01 (L1084-1094) | ○ |
| C-67 | collections_postsテーブルがcollections.idとposts.idを参照（cascadeDelete） | E-01 (L1095-1100) | ○ |
| C-68 | recommendationsテーブルにurl, title, one_click_subscribeカラムが存在 | E-01 (L1101-1112) | ○ |
| C-69 | recommendation_click_eventsテーブルがrecommendations.idを参照（cascadeDelete） | E-01 (L1113-1118) | ○ |
| C-70 | recommendation_subscribe_eventsテーブルがmember_idにsetNullDeleteを使用 | E-01 (L1122) | ○ |
| C-71 | outboxテーブルにevent_type, status, payload, retry_countカラムが存在 | E-01 (L1125-1138) | ○ |
| C-72 | automated_emailsテーブルにstatus, name, slug, subject, lexicalカラムが存在 | E-01 (L1139-1155) | ○ |
| C-73 | automated_email_recipientsテーブルがautomated_emails.idを参照 | E-01 (L1156-1165) | ○ |
| C-74 | すべてのプライマリキーが24文字のstring型である | E-01 (全テーブル) maxlength: 24定義 | ○ |
| C-75 | 文字列カラムサイズガイドライン（50/191/2000/65535/1000000000） | E-01 (L1-10) コメント記載 | ○ |

## 4) 不足情報（Unknown / Missing）

すべての主張に対して根拠が確認されたため、不足情報はありません。

備考：
- マイグレーション履歴ファイルは参照していないため、実際のテーブル構造と差異がある可能性は低いが0ではない
- 本番環境での追加インデックスやパフォーマンスチューニングについては未確認

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - すべてのテーブル定義がスキーマファイルに明確に記述されている
- **0: 低リスク** - 外部キー制約とカスケード削除設定が明確に定義されている
- **0: 低リスク** - バリデーションルールがスキーマに含まれている
- **1: 中リスク** - 非推奨フィールド（monthly_price_id, yearly_price_id等）の実際の使用状況は未確認

## 6) レビュアーチェックリスト（最小）

- [ ] 75テーブルすべてがデータベース設計書に含まれているか確認
- [ ] ER図の主要リレーションシップが正確に表現されているか確認
- [ ] 外部キー制約（cascadeDelete, setNullDelete）の設定が正しいか確認
- [ ] インデックスとユニーク制約が網羅されているか確認
- [ ] 非推奨フィールドの扱いについてプロジェクトポリシーと一致しているか確認
