---
generated_at: 2026-01-29 20:17:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（すべてのバッチ処理に対してソースコードからの根拠が確認できました）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/jobs/job-service.js` - JobManagerのラッパー、Breeを使用したジョブスケジューリング
- E-02: `ghost/core/core/server/services/email-analytics/jobs/index.js` - email-analytics-fetch-latestジョブのスケジューリング
- E-03: `ghost/core/core/server/services/email-analytics/email-analytics-service.js` - メール分析サービスの実装
- E-04: `ghost/core/core/server/services/email-service/batch-sending-service.js` - バッチメール送信サービス
- E-05: `ghost/core/core/server/services/members/jobs/index.js` - メンバー関連ジョブのスケジューリング
- E-06: `ghost/core/core/server/services/members/jobs/clean-expired-comped.js` - 期限切れcompedクリーンアップジョブ
- E-07: `ghost/core/core/server/services/members/jobs/clean-tokens.js` - トークンクリーンアップジョブ
- E-08: `ghost/core/core/server/adapters/scheduling/post-scheduling/PostScheduler.js` - 投稿スケジューラ
- E-09: `ghost/core/core/server/adapters/scheduling/scheduling-default.js` - デフォルトスケジューリングアダプタ
- E-10: `ghost/core/core/server/services/update-check/index.js` - アップデートチェックサービス
- E-11: `ghost/core/core/server/services/outbox/jobs/index.js` - Outboxジョブのスケジューリング
- E-12: `ghost/core/core/server/services/outbox/jobs/outbox-job.js` - Outboxジョブの実装
- E-13: `ghost/core/core/server/services/mentions-email-report/service.js` - Webmention通知サービス
- E-14: `ghost/core/core/server/services/mentions-email-report/mention-email-report-job.js` - Mention通知ジョブの実装
- E-15: `ghost/core/core/server/services/milestones/service.js` - マイルストーンサービス
- E-16: `ghost/core/core/server/services/media-inliner/service.js` - メディアインラインサービス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | email-analytics-fetch-latestは5分ごとに実行される | E-02 (31-35行目: cronスケジュール `${s} ${m}/5 * * * *`) | ○ |
| C-02 | batch-sending-service-jobはメールをバッチ単位で送信する | E-04 (12行目: MAX_SENDING_CONCURRENCY=2, 250行目: BATCH_SIZE) | ○ |
| C-03 | clean-expired-compedは毎日0-5時に実行される | E-05 (18行目: h = Math.floor(Math.random() * 6)) | ○ |
| C-04 | clean-tokensは24時間以上経過したトークンを削除する | E-07 (32行目: subtract(24, 'hours')) | ○ |
| C-05 | post-schedulingは5分ごとにウェイクアップする | E-09 (24行目: runTimeoutInMs = 1000 * 60 * 5) | ○ |
| C-06 | update-checkは毎日ランダムな時刻に実行される | E-10 (77-82行目: cronスケジュール `${s} ${m} ${h} * * *`) | ○ |
| C-07 | process-outboxは5分ごとに実行される | E-11 (23行目: cronスケジュール `${s} ${m}/5 * * * *`) | ○ |
| C-08 | mentions-email-reportは1時間ごとに実行される | E-13 (162行目: cronスケジュール `${s} ${m} * * * *`) | ○ |
| C-09 | milestones-checkは0-4日のランダム遅延で実行される | E-15 (6行目: JOB_TIMEOUT = 1000 * 60 * 60 * 24 * (Math.floor(Math.random() * 4))) | ○ |
| C-10 | external-media-inlinerはオンデマンドで実行される | E-16 (47行目: offloaded: false) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。すべてのバッチ処理がソースコードから確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのバッチ処理に対してソースコードの根拠が確認できました
- 注意点：
  - バッチ処理の実行間隔にランダム要素（秒、分、時）が含まれるため、正確な実行時刻はインスタンスごとに異なります
  - 開発環境（NODE_ENV=development）では一部のジョブが異なる動作をする場合があります

## 6) レビュアーチェックリスト（最小）
- [ ] すべてのバッチ処理がプロジェクトの要件に合致しているか確認
- [ ] 実行間隔が運用要件を満たしているか確認
- [ ] 各ジョブのエラーハンドリングが適切に行われているか確認
- [ ] リトライ機構が必要なジョブで適切に実装されているか確認
