# バッチ設計書 10-external-media-inliner

## 概要

本ドキュメントは、Ghostプラットフォームにおける外部メディアインライナーバッチ「external-media-inliner」の設計仕様を記載したものです。このバッチは、外部ドメインのメディア（画像、動画など）をローカルストレージに取り込み、コンテンツ内の参照を更新する役割を担います。

### 本バッチの処理概要

**業務上の目的・背景**：Ghostに他のプラットフォーム（Substack、Revueなど）からコンテンツをインポートする際、記事内のメディアは外部URLを参照したままの状態になります。外部サービスが終了したり、URL構造が変更されたりすると、これらのメディアが表示されなくなるリスクがあります。このバッチは、外部メディアをGhostのローカルストレージにダウンロードし、コンテンツ内の参照を更新することで、メディアの永続性と信頼性を確保します。

**バッチの実行タイミング**：オンデマンドで手動実行されます。主にインポート後のメディア取り込み用途で使用されます。

**主要な処理内容**：
1. 指定されたドメインのメディアURLを投稿コンテンツから検索
2. 外部URLからメディアをダウンロード
3. ローカルストレージに保存
4. 投稿コンテンツ内の参照URLを更新
5. タグ・ユーザーの画像フィールドも同様に処理

**前後の処理との関連**：インポートジョブ（Substack、Revueインポート）の後処理として使用されます。

**影響範囲**：posts、posts_meta、tags、usersテーブルのメディア関連フィールドが更新されます。ローカルストレージにファイルが保存されます。

## バッチ種別

データ連携 / データ変換

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | オンデマンド |
| 実行時刻 | 手動実行 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | API呼び出し（startMediaInliner） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| サービス初期化 | MediaInlinerサービスが初期化されていること |
| ストレージ設定 | 画像・メディア・ファイルストレージが設定されていること |

### 実行可否判定

- domainsパラメータが指定されていない場合はデフォルトドメインを使用
- 常に実行可能（オンデマンド）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| domains | string[] | No | ['https://s3.amazonaws.com/revue', 'https://substackcdn.com'] | インライン対象ドメイン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| posts テーブル | DB | 投稿コンテンツ（mobiledoc, lexical, feature_image） |
| posts_meta テーブル | DB | OG画像、Twitter画像 |
| tags テーブル | DB | タグのフィーチャー画像、OG画像、Twitter画像 |
| users テーブル | DB | ユーザーのプロフィール画像、カバー画像 |
| 外部URL | HTTP | メディアファイル本体 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| posts テーブル | DB | mobiledoc, lexical, feature_imageを更新 |
| posts_meta テーブル | DB | og_image, twitter_imageを更新 |
| tags テーブル | DB | feature_image, og_image, twitter_imageを更新 |
| users テーブル | DB | profile_image, cover_imageを更新 |
| ローカルストレージ | ファイル | ダウンロードしたメディアファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 元URL末尾248文字をslugify + 拡張子 |
| 出力先 | ストレージアダプタの指定パス |
| 文字コード | バイナリ |
| 形式 | 元ファイル形式（HEIC/HEIFはJPEGに変換） |

## 処理フロー

### 処理シーケンス

```
1. startMediaInliner(domains)
   └─ domainsが未指定の場合はデフォルト値を設定

2. ジョブ登録
   └─ jobsService.addJob()で非オフロードジョブとして登録

3. inline(domains)実行
   └─ 3.1. 投稿処理
      └─ PostModel.findAll()で全投稿取得
      └─ 各投稿について:
         └─ feature_imageをインライン
         └─ mobiledocコンテンツをインライン
         └─ lexicalコンテンツをインライン
         └─ PostModel.edit()で更新

   └─ 3.2. 投稿メタ処理
      └─ PostMetaModel.findPage()で全メタ取得
      └─ og_image, twitter_imageをインライン

   └─ 3.3. タグ処理
      └─ TagModel.findPage()で全タグ取得
      └─ feature_image, og_image, twitter_imageをインライン

   └─ 3.4. ユーザー処理
      └─ UserModel.findPage()で全ユーザー取得
      └─ profile_image, cover_imageをインライン

4. 各メディアのインライン処理
   └─ getRemoteMedia(): HTTPリクエストでダウンロード
   └─ extractFileDataFromResponse(): ファイル情報抽出
   └─ storeMediaLocally(): ローカルストレージに保存
   └─ コンテンツ内のURLを__GHOST_URL__形式に置換
```

### フローチャート

```mermaid
flowchart TD
    A[startMediaInliner] --> B[ジョブ登録]
    B --> C[inline開始]
    C --> D[全投稿取得]
    D --> E[投稿コンテンツをインライン]
    E --> F[投稿メタをインライン]
    F --> G[タグをインライン]
    G --> H[ユーザーをインライン]
    H --> I[完了]

    subgraph メディアインライン処理
    J[URLを検索] --> K[HTTPダウンロード]
    K --> L[ファイル情報抽出]
    L --> M{HEIC/HEIF?}
    M -->|Yes| N[JPEGに変換]
    M -->|No| O[そのまま]
    N --> P[ローカル保存]
    O --> P
    P --> Q[URL置換]
    end
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 投稿取得 | posts | SELECT | 全投稿を取得 |
| 投稿更新 | posts | UPDATE | feature_image, mobiledoc, lexicalを更新 |
| 投稿メタ取得 | posts_meta | SELECT | 全投稿メタを取得 |
| 投稿メタ更新 | posts_meta | UPDATE | og_image, twitter_imageを更新 |
| タグ取得 | tags | SELECT | 全タグを取得 |
| タグ更新 | tags | UPDATE | 画像フィールドを更新 |
| ユーザー取得 | users | SELECT | 全ユーザーを取得 |
| ユーザー更新 | users | UPDATE | 画像フィールドを更新 |

### テーブル別操作詳細

#### posts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | mobiledoc, lexical, feature_image | context: internal | |
| UPDATE | feature_image | __GHOST_URL__形式のパス | |
| UPDATE | mobiledoc | 置換後のJSON文字列 | |
| UPDATE | lexical | 置換後のJSON文字列 | |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ダウンロードエラー | 外部URLへのアクセス失敗 | ログ出力して次のメディアへ |
| - | 変換エラー | HEIC/HEIF変換失敗 | ログ出力して元形式で保存試行 |
| - | ストレージエラー | ローカル保存失敗 | ログ出力してスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- 各メディアの処理エラーはログ出力して続行
- 投稿単位のエラーもログ出力して次の投稿へ
- DataImportErrorとして詳細をログ

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 各モデル更新単位 |
| コミットタイミング | Model.edit()完了時 |
| ロールバック条件 | 更新失敗時（個別） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 投稿数・メディア数に依存 |
| 目標処理時間 | 数分〜数時間（メディア量依存） |
| メモリ使用量上限 | メディアファイルサイズに依存 |

## 排他制御

- ジョブサービスによる管理（offloaded: false）
- 同時実行制御は特になし

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | `[Inliner] Starting media inlining job for domains: ${domains}` |
| 進捗ログ | メディア保存時 | `Inlined media: ${src} -> ${inlinedSrc}` |
| 警告ログ | ストレージなし時 | `No storage adapter found for file extension: ${extension}` |
| エラーログ | ダウンロード失敗時 | `Error downloading remote media: ${url}` |
| エラーログ | 変換失敗時 | `Error converting file to JPEG: ${url}` |
| エラーログ | 投稿処理失敗時 | `Error inlining media for post: ${id}` |
| 完了ログ | 処理完了時 | `Finished inlining external media for posts, tags, and users` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- デフォルトドメイン: Revue（https://s3.amazonaws.com/revue）、Substack（https://substackcdn.com）
- HEIC/HEIF形式はJPEGに自動変換（heic-convertパッケージ使用）
- ファイル名は最大248文字（各種OSの制限対応）
- URL置換は`__GHOST_URL__`プレフィックスを使用（Ghost内部形式）
- JSONコンテンツ（mobiledoc, lexical）内のURLも正規表現で検索・置換
- 重複URLは複数回処理される可能性あり（キャッシュなし）
- HTTPリダイレクトに対応（followRedirect: true）
- http://はhttps://にアップグレードされる可能性あり
- ストレージアダプタは拡張子に応じて選択（images/media/files）
