# バッチ設計書 3-clean-expired-comped

## 概要

本ドキュメントは、Ghostプラットフォームにおける期限切れ無料サブスクリプションクリーンアップバッチ「clean-expired-comped」の設計仕様を記載したものです。このバッチは、期限切れとなったcomplimentary（無料提供）サブスクリプションを削除し、対象メンバーのステータスを更新する役割を担います。

### 本バッチの処理概要

**業務上の目的・背景**：Ghostでは、サイト運営者がメンバーに対して期間限定の無料サブスクリプション（complimentary）を付与することができます。このサブスクリプションには有効期限（expiry_at）を設定でき、期限が過ぎた場合は自動的にサブスクリプションを解除し、メンバーのステータスを「comped」から「free」に変更する必要があります。このバッチは、期限切れサブスクリプションの自動クリーンアップを行い、データの整合性を維持します。

**バッチの実行タイミング**：毎日0時〜5時の間のランダムな時刻に1回実行されます。ランダム化により、データベースへの負荷スパイクを防止しています。

**主要な処理内容**：
1. members_productsテーブルから期限切れ（expiry_at < 今日の日付）のレコードを取得
2. 該当レコードをmembers_productsテーブルから削除
3. 対象メンバーのステータスが「comped」の場合、「free」に更新
4. ステータス変更をmembers_status_eventsテーブルに記録

**前後の処理との関連**：独立したクリーンアップジョブとして動作します。メンバー管理機能やサブスクリプション管理機能と連携します。

**影響範囲**：members_products、members、members_status_eventsテーブルが更新されます。期限切れサブスクリプションを持つメンバーのアクセス権限に影響します。

## バッチ種別

データクレンジング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | 0:00〜5:59の間のランダムな時刻 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron（`${s} ${m} ${h} * * *`、s=0-59, m=0-59, h=0-5） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| テスト環境除外 | NODE_ENV.startsWith('test')の場合はスケジュールされない |
| 未スケジュール | hasScheduled.expiredCompedがfalseであること |

### 実行可否判定

- スケジュール登録は1回のみ（hasScheduledフラグで制御）
- テスト環境では実行されない

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| members_products テーブル | DB | 期限切れサブスクリプションの取得元 |
| members テーブル | DB | メンバー情報（ステータス確認用） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| members_products テーブル | DB | 期限切れレコードを削除 |
| members テーブル | DB | statusを「comped」→「free」に更新 |
| members_status_events テーブル | DB | ステータス変更イベントを記録 |

### 出力ファイル仕様

ファイル出力なし（データベースのみ更新）

## 処理フロー

### 処理シーケンス

```
1. ジョブ開始
   └─ cleanupStartDateを記録

2. 期限切れレコード取得
   └─ members_productsから expiry_at < 今日の日付 のレコードを取得

3. 期限切れレコードがある場合
   └─ 3.1. rowIds、memberIdsを抽出
   └─ 3.2. members_productsから期限切れレコードを削除
   └─ 3.3. membersテーブルから対象メンバー（status='comped'）を取得
   └─ 3.4. 対象メンバーのstatusを'free'に更新
   └─ 3.5. members_status_eventsにステータス変更イベントを挿入

4. 結果ログ出力
   └─ 削除数、更新数、処理時間をログ出力

5. ジョブ終了
   └─ parentPortに'done'を送信
```

### フローチャート

```mermaid
flowchart TD
    A[ジョブ開始] --> B[期限切れレコード取得]
    B --> C{レコードあり?}
    C -->|No| D[結果ログ出力]
    C -->|Yes| E[rowIds, memberIds抽出]
    E --> F[members_productsから削除]
    F --> G[comped メンバー取得]
    G --> H[status を free に更新]
    H --> I[ステータスイベント挿入]
    I --> D
    D --> J[ジョブ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 期限切れ取得 | members_products | SELECT | expiry_at < 今日のレコードを取得 |
| 期限切れ削除 | members_products | DELETE | 期限切れレコードの削除 |
| comped取得 | members | SELECT | 対象メンバー（status=comped）を取得 |
| ステータス更新 | members | UPDATE | status: comped → free |
| イベント記録 | members_status_events | INSERT | ステータス変更イベントの記録 |

### テーブル別操作詳細

#### members_products

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | expiry_at < 今日の開始時刻（UTC） | moment.utc().startOf('day') |
| DELETE | - | id IN (期限切れレコードのID) | |

#### members

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | id IN (対象memberIds) AND status = 'comped' | |
| UPDATE | status | 'free' | 対象メンバーのみ |

#### members_status_events

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | id | 新規ObjectID | |
| INSERT | member_id | 対象メンバーID | |
| INSERT | from_status | 元のステータス（'comped'） | |
| INSERT | to_status | 'free' | |
| INSERT | created_at | CURRENT_TIMESTAMP | |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | キャンセル | ワーカースレッドがキャンセルされた | メッセージ出力後、プロセス終了 |
| - | DBエラー | データベース接続・クエリ失敗 | 未処理（次回実行時に再処理） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- キャンセル時は「cancelled」メッセージを送信して終了
- エラー発生時は次回の日次実行で再処理（冪等性あり）

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 明示的なトランザクションなし |
| コミットタイミング | 各クエリ単位 |
| ロールバック条件 | 個別クエリ失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 通常は少数（期限切れサブスクリプション数依存） |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | ステータスイベント挿入時は6553件ずつチャンク処理 |

## 排他制御

- hasScheduled.expiredCompedフラグによる重複スケジュール防止
- 同時実行制御は特になし（冪等性により問題なし）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | `Starting cleanup of expired comp subscriptions` |
| 終了ログ | ジョブ終了時 | `Removed ${deletedExpiredSubs} expired subscriptions, updated ${updatedMembers} members in ${time}ms` |
| キャンセルログ | キャンセル時 | `Expired complimentary subscriptions cleanup cancelled before completion` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- SQLite互換性のため、ステータスイベント挿入時は6553件ずつチャンク処理（SQLite 3.32.0以降は32766パラメータ対応）
- 期限切れ判定はUTC基準の日付開始時刻で比較
- moment.jsを使用してタイムゾーン処理
- ObjectIDはbson-objectidパッケージを使用
