# バッチ設計書 4-clean-tokens

## 概要

本ドキュメントは、Ghostプラットフォームにおける古いトークン削除バッチ「clean-tokens」の設計仕様を記載したものです。このバッチは、24時間以上経過した古いトークンをデータベースから削除し、システムの整合性とパフォーマンスを維持する役割を担います。

### 本バッチの処理概要

**業務上の目的・背景**：Ghostでは、メンバー認証やマジックリンクなどで一時的なトークンを生成します。これらのトークンは使用後や一定時間経過後に不要となりますが、自動的には削除されません。放置するとtokensテーブルのレコード数が増加し、パフォーマンス低下やストレージ消費の原因となります。このバッチは、24時間以上経過したトークンを定期的に削除することで、データベースの肥大化を防止します。

**バッチの実行タイミング**：毎日ランダムな時刻（0-23時のいずれか）に1回実行されます。ランダム化により、データベースへの負荷スパイクを防止しています。

**主要な処理内容**：
1. tokensテーブルから created_at が24時間以上前のレコードを削除

**前後の処理との関連**：独立したクリーンアップジョブとして動作します。トークン生成機能（メンバー認証など）とは独立して動作します。

**影響範囲**：tokensテーブルのみが更新されます。古いトークンの削除により、既に期限切れのマジックリンクなどが使用不可となります（本来期待される動作）。

## バッチ種別

データクレンジング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | 0:00〜23:59の間のランダムな時刻 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron（`${s} ${m} ${h} * * *`、s=0-59, m=0-59, h=0-23） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| テスト環境除外 | NODE_ENV.startsWith('test')の場合はスケジュールされない |
| 未スケジュール | hasScheduled.tokensがfalseであること |

### 実行可否判定

- スケジュール登録は1回のみ（hasScheduledフラグで制御）
- テスト環境では実行されない

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| tokens テーブル | DB | 削除対象トークンの取得元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| tokens テーブル | DB | 24時間以上前のトークンを削除 |

### 出力ファイル仕様

ファイル出力なし（データベースのみ更新）

## 処理フロー

### 処理シーケンス

```
1. ジョブ開始
   └─ cleanupStartDateを記録

2. 削除期限計算
   └─ 現在時刻から24時間前の日時を計算（UTC）

3. トークン削除
   └─ tokensテーブルから created_at < 削除期限 のレコードを削除

4. 結果ログ出力
   └─ 削除数、削除期限、処理時間をログ出力

5. ジョブ終了
   └─ parentPortに'done'を送信
```

### フローチャート

```mermaid
flowchart TD
    A[ジョブ開始] --> B[削除期限計算（24時間前）]
    B --> C[tokensテーブルから削除]
    C --> D[結果ログ出力]
    D --> E[ジョブ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| トークン削除 | tokens | DELETE | created_at < 24時間前のレコードを削除 |

### テーブル別操作詳細

#### tokens

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | created_at < 24時間前（UTC） | format('YYYY-MM-DD HH:mm:ss') |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | キャンセル | ワーカースレッドがキャンセルされた | メッセージ出力後、プロセス終了 |
| - | DBエラー | データベース接続・クエリ失敗 | 未処理（次回実行時に再処理） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- キャンセル時は「cancelled」メッセージを送信して終了
- エラー発生時は次回の日次実行で再処理（冪等性あり）

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 単一DELETE文 |
| コミットタイミング | クエリ完了時 |
| ロールバック条件 | クエリ失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | トークン生成量に依存 |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 特になし（単一DELETE文） |

## 排他制御

- hasScheduled.tokensフラグによる重複スケジュール防止
- 同時実行制御は特になし（冪等性により問題なし）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ジョブ開始時 | `Starting cleanup of tokens` |
| 終了ログ | ジョブ終了時 | `Removed ${deletedTokens} tokens created before ${d.toISOString()} in ${time}ms` |
| キャンセルログ | キャンセル時 | `Expired complimentary subscriptions cleanup cancelled before completion`（注：メッセージにバグあり） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- 日時比較はSQLiteとMySQL両方で動作するよう、moment().format('YYYY-MM-DD HH:mm:ss')形式を使用
- キャンセルメッセージに「Expired complimentary subscriptions」と誤ったテキストが残っている（コピペミスと思われる）
- moment.utc()を使用してUTC基準で24時間前を計算
- ランダムな秒・分・時を使用してデータベースへの負荷スパイクを分散
