# バッチ設計書 5-post-scheduling

## 概要

本ドキュメントは、Ghostプラットフォームにおける予約投稿スケジューラ「post-scheduling」の設計仕様を記載したものです。このスケジューラは、予約された投稿を指定時刻に自動公開する役割を担います。

### 本バッチの処理概要

**業務上の目的・背景**：Ghostでは、投稿を指定した日時に自動公開する「予約投稿」機能を提供しています。サイト運営者は記事を事前に作成し、公開日時を指定することで、最適なタイミングでコンテンツを配信できます。このスケジューラは、予約された投稿を正確な時刻に公開APIを呼び出すことで、自動公開を実現します。

**バッチの実行タイミング**：5分ごとにウェイクアップし、10分以内に公開予定の投稿をチェックします。緊急ジョブ（10分以内に公開予定）は即座に処理されます。

**主要な処理内容**：
1. 起動時に既存の予約投稿をスケジューラに再登録
2. 投稿イベント（scheduled, rescheduled, unscheduled）を監視
3. 5分ごとにウェイクアップし、10分以内に公開予定の投稿を処理キューに移動
4. 指定時刻の約70ms前に起床し、setImmediateで正確なタイミングを検出
5. 公開APIエンドポイントをHTTPリクエストで呼び出し

**前後の処理との関連**：投稿作成・編集APIからスケジュールイベントを受信します。公開後はbatch-sending-service-jobでメール送信が開始されます。

**影響範囲**：postsテーブルの公開状態が更新されます。予約投稿の公開に直接影響します。

## バッチ種別

データ処理 / 通知配信

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 5分ごと（ウェイクアップ） |
| 実行時刻 | 常時稼働 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | タイマー（setTimeout）+ イベント駆動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| スケジューラ起動 | PostScheduler.run()が呼び出されていること |
| API URL設定 | apiUrlが設定されていること |
| Integration設定 | 内部APIキーが設定されていること |

### 実行可否判定

- isRunningフラグで重複実行を防止
- 削除済みジョブはdeletedJobsで管理し、実行をスキップ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| apiUrl | string | Yes | - | Ghost API URL |
| integration | object | Yes | - | 内部APIキー情報 |
| adapter | object | Yes | - | スケジューリングアダプタ |
| scheduledResources | object | Yes | {} | 起動時の予約リソース |
| events | EventEmitter | Yes | - | イベントエミッタ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| posts テーブル | DB | 予約投稿情報（起動時にscheduledResourcesとして渡される） |
| イベント | EventEmitter | post.scheduled, post.rescheduled, post.unscheduled |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Ghost API | HTTP | 公開APIエンドポイントへのPUTリクエスト |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. PostScheduler初期化
   └─ apiUrl, integration, adapter, events を設定

2. 起動時リスケジュール
   └─ scheduledResourcesの各投稿をunschedule→scheduleで再登録

3. adapter.run()
   └─ 5分ごとのウェイクアップループ開始

4. イベントリスナー登録
   └─ post.scheduled: schedule()呼び出し
   └─ post.rescheduled: unschedule()→schedule()呼び出し
   └─ post.unscheduled: unschedule()呼び出し

5. スケジュール処理（schedule）
   └─ normalize()でジョブ情報を正規化
   └─ allJobsに登録（時刻でソート）
   └─ 10分以内の場合は即座に_execute()

6. 実行処理（_execute）
   └─ 指定時刻の70ms前にsetTimeout
   └─ setImmediateで正確なタイミングを検出
   └─ _pingUrl()でAPI呼び出し

7. API呼び出し（_pingUrl）
   └─ /schedules/{resource}/{id}/?token={token} にPUTリクエスト
   └─ 503エラーの場合は最大30回リトライ
```

### フローチャート

```mermaid
flowchart TD
    A[PostScheduler初期化] --> B[既存予約を再登録]
    B --> C[adapter.run開始]
    C --> D[5分ごとにウェイクアップ]
    D --> E{10分以内の予約あり?}
    E -->|Yes| F[_executeに移動]
    E -->|No| D
    F --> G[指定時刻-70msでsetTimeout]
    G --> H[setImmediateで正確タイミング検出]
    H --> I{削除済み?}
    I -->|Yes| D
    I -->|No| J[_pingUrlでAPI呼び出し]
    J --> K{成功?}
    K -->|Yes| D
    K -->|503| L[リトライ（最大30回）]
    K -->|404| D
    L --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし（API経由） | posts | UPDATE | 公開APIを介して投稿ステータスを更新 |

### テーブル別操作詳細

このスケジューラは直接データベースを操作せず、Ghost APIを介して投稿を公開します。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | Not Found | 投稿が既に削除されている | 処理をスキップ |
| 503 | Service Unavailable | メンテナンスモード | 5秒間隔でリトライ（最大30回） |
| - | その他エラー | API呼び出し失敗 | criticalレベルでログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 最大30回 |
| リトライ間隔 | 5秒（retryTimeoutInMs） |
| リトライ対象エラー | 503 Service Unavailable |

### 障害時対応

- 404エラー: 投稿が削除されたとみなし、処理をスキップ
- 503エラー: メンテナンスモードとみなし、リトライ
- その他エラー: criticalレベルでログ出力、処理続行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | API呼び出し単位 |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 予約投稿数に依存 |
| 目標処理時間 | 指定時刻から-50ms以内に公開 |
| メモリ使用量上限 | allJobsオブジェクトのサイズ依存 |

## 排他制御

- isRunningフラグで重複実行を防止
- deletedJobsで削除済みジョブを管理
- 同一時刻に複数ジョブがある場合は順次処理

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| デバッグログ | ジョブ追加時 | `Added job ${url} ${time}` |
| デバッグログ | ジョブ削除時 | `Deleted job ${url} ${time}` |
| デバッグログ | Ping実行時 | `Ping url ${url} ${time}` |
| デバッグログ | 緊急ジョブ時 | `Emergency job ${url} ${time}` |
| エラーログ | 503リトライ時 | InternalServerError（normal level） |
| エラーログ | その他エラー時 | InternalServerError（critical level） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- setTimeoutは24.3日が上限のため、長期間の予約は5分ごとのウェイクアップでカバー
- beforePingInMs（-50ms）のマージンで正確なタイミングを確保
- 過去の公開予定時刻の場合は`{force: true}`パラメータを付与
- 署名付きトークン（getSignedAdminToken）でAPI認証
- SchedulingDefaultはインメモリ実装、カスタム実装ではDB使用も可能
- rescheduleOnBoot: trueで起動時に全予約を再登録
