# バッチ設計書 6-update-check

## 概要

本ドキュメントは、Ghostプラットフォームにおける更新チェックバッチ「update-check」の設計仕様を記載したものです。このバッチは、Ghostの新バージョンの有無をGhost公式サーバーに問い合わせ、利用可能な場合は通知を作成する役割を担います。

### 本バッチの処理概要

**業務上の目的・背景**：Ghostは定期的に新バージョンをリリースしており、セキュリティアップデートや新機能が含まれています。サイト運営者が最新バージョンを把握し、適切なタイミングでアップデートできるよう、このバッチは自動的にバージョンチェックを行い、管理画面に通知を表示します。また、Ghostチームはこのチェックを通じて匿名の使用統計を収集し、製品改善に活用しています（オプトアウト可能）。

**バッチの実行タイミング**：毎日ランダムな時刻に1回実行されます。`next_update_check`設定値に基づいて、次回チェック時刻を管理します。

**主要な処理内容**：
1. `next_update_check`設定を確認し、チェック時刻に達しているか判定
2. ブログの統計情報（バージョン、投稿数、ユーザー数など）を収集
3. Ghost公式更新チェックサービス（updates.ghost.org）にリクエスト送信
4. レスポンスから通知メッセージを抽出し、notificationsテーブルに登録
5. 重要な通知（type: alert）の場合は管理者にメール送信

**前後の処理との関連**：独立したバックグラウンドジョブとして動作します。管理画面の通知表示機能と連携します。

**影響範囲**：settings（next_update_check）、notificationsテーブルが更新されます。管理画面の通知に影響します。

## バッチ種別

データ連携 / 通知配信

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | ランダム（next_update_check設定に基づく） |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | 起動時チェック + 24時間後に次回チェック |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| プライバシー設定 | privacy.useUpdateCheckがtrueであること（デフォルト有効） |
| チェック時刻 | next_update_checkが現在時刻より前であること |

### 実行可否判定

- `next_update_check`がnullまたは現在時刻より前の場合に実行
- `forceUpdate`設定がtrueの場合は強制実行（開発用）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| config.checkEndpoint | string | Yes | - | 更新チェックサービスURL |
| config.isPrivacyDisabled | boolean | No | false | 統計送信を無効化 |
| config.notificationGroups | string[] | No | [] | カスタム通知グループ |
| config.forceUpdate | boolean | No | false | 強制チェック（開発用） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| settings テーブル | DB | db_hash, active_theme, next_update_check |
| posts テーブル | DB | 投稿数の取得 |
| users テーブル | DB | ユーザー数・Owner作成日の取得 |
| システム情報 | Node.js | ghost_version, node_version, npm_version |
| 設定ファイル | JSON | mail, env, databaseType |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| settings テーブル | DB | next_update_checkを更新 |
| notifications API | API | 通知を登録 |
| メール | SMTP | 重要通知（alert）を管理者に送信 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. check()開始
   └─ next_update_check設定を読み取り

2. 実行判定
   └─ next_update_checkが現在時刻より前かチェック
   └─ forceUpdateがtrueの場合は強制実行

3. updateCheckData()
   └─ ブログ統計情報を収集
   └─ ghost_version, node_version, npm_version
   └─ db_hash, active_theme, post_count, user_count
   └─ blog_id（URLとdb_hashのMD5ハッシュ）
   └─ blog_created_at（Ownerユーザーの作成日）

4. updateCheckRequest()
   └─ プライバシー設定に応じてPOST/GETを選択
   └─ POST: 統計情報を送信
   └─ GET: ghost_versionのみ送信

5. updateCheckResponse()
   └─ next_update_checkを更新（現在時刻+24時間）
   └─ 通知メッセージをフィルタリング
   └─ notificationGroupsに基づいてカスタム通知を選別

6. createCustomNotification()
   └─ 各通知をnotifications APIに登録
   └─ type: alertの場合は管理者にメール送信
```

### フローチャート

```mermaid
flowchart TD
    A[check開始] --> B{チェック時刻到達?}
    B -->|No| C[スキップ]
    B -->|Yes| D[統計情報収集]
    D --> E{プライバシー有効?}
    E -->|Yes| F[GET リクエスト]
    E -->|No| G[POST リクエスト]
    F --> H[レスポンス処理]
    G --> H
    H --> I[next_update_check更新]
    I --> J[通知フィルタリング]
    J --> K{通知あり?}
    K -->|No| L[終了]
    K -->|Yes| M[通知登録]
    M --> N{type=alert?}
    N -->|Yes| O[管理者にメール送信]
    N -->|No| L
    O --> L
    C --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定読み取り | settings | SELECT | next_update_check, db_hash, active_theme |
| 投稿数取得 | posts | SELECT | COUNT |
| ユーザー取得 | users | SELECT | COUNT, created_at |
| 設定更新 | settings | UPDATE | next_update_check |
| 通知登録 | notifications | INSERT | 通知メッセージ（API経由） |

### テーブル別操作詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | value | key = 'next_update_check' | |
| SELECT | value | key = 'db_hash' | |
| SELECT | value | key = 'active_theme' | |
| UPDATE | value | 現在時刻 + 24時間 | key = 'next_update_check' |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | Not Found | 通知なし | 空の通知配列を返す |
| - | その他エラー | API呼び出し失敗 | next_update_checkを更新してログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- エラー発生時もnext_update_checkを更新して次回チェックを設定
- ログにエラー詳細を出力（context: "Checking for updates failed"）
- rethrowErrorsがtrueの場合は例外を再スロー（ワーカースレッド用）

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 個別操作単位 |
| コミットタイミング | 各設定更新時 |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/日 |
| 目標処理時間 | 数秒（API応答時間依存） |
| メモリ使用量上限 | 特になし |

## 排他制御

- next_update_check設定による時間ベースの制御
- 同時実行制御は特になし

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| デバッグログ | リクエスト時 | `Request Update Check Service ${endpoint}` |
| デバッグログ | 通知グループ | `Notification Groups ${groups}` |
| デバッグログ | レスポンス | `Response Update Check Service ${response}` |
| デバッグログ | 通知作成時 | `Add Custom Notification ${notification}` |
| エラーログ | エラー時 | context, help付きのエラー情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- 送信される統計情報（プライバシー無効時）:
  - ghost_version, node_version, npm_version, env, database_type
  - email_transport, url, blog_id, theme, post_count, user_count, blog_created_at
- blog_idはURL+db_hashのMD5ハッシュで匿名化
- notificationGroupsに'all'が含まれると全カスタム通知を受信
- 通知のtype: alertは管理者（Owner/Administrator）全員にメール送信
- APIタイムアウトは1秒に設定
