# バッチ設計書 7-process-outbox

## 概要

本ドキュメントは、Ghostプラットフォームにおけるメール送信キュー処理バッチ「process-outbox」の設計仕様を記載したものです。このバッチは、メール送信キュー（Outbox）に蓄積されたメール（ウェルカムメールなど）を定期的に処理し、送信する役割を担います。

### 本バッチの処理概要

**業務上の目的・背景**：Ghostでは、新規メンバー登録時のウェルカムメールなど、特定のイベントに応じてメールを送信する必要があります。これらのメールは即座に送信するのではなく、一旦Outbox（送信キュー）に蓄積し、バッチ処理で送信することで、システムの安定性と信頼性を確保しています。このバッチは、Outboxに蓄積されたメールを定期的に処理し、確実に送信します。

**バッチの実行タイミング**：5分ごとにcronスケジュールで自動実行されます（`${s} ${m}/5 * * * *`形式）。開発環境やテスト用設定では3秒ごとに実行することも可能です。

**主要な処理内容**：
1. ワーカースレッドからStartOutboxProcessingEventを発火
2. メインスレッドでOutbox処理サービスがイベントを受信
3. Outboxキューに蓄積されたメール送信リクエストを処理

**前後の処理との関連**：メンバー登録など各種イベントでOutboxにメールがキューイングされます。このバッチがキューを処理して実際のメール送信を行います。

**影響範囲**：outboxテーブル（メールキュー）が処理され、メール送信が実行されます。

## バッチ種別

通知配信 / データ処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 5分ごと |
| 実行時刻 | ランダムな秒・分オフセット付きで5分間隔 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | cron（`${s} ${m}/5 * * * *`） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 未スケジュール | hasScheduled.processOutboxがfalseであること |
| メール設定 | メール送信設定が完了していること |

### 実行可否判定

- スケジュール登録は1回のみ（hasScheduledフラグで制御）
- memberWelcomeEmailSendInstantly設定がtrueの場合は3秒ごとに実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| outbox キュー | Event | StartOutboxProcessingEventを通じて処理開始 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| メール送信 | SMTP | Outboxキューのメールを送信 |
| outbox キュー | DB | 処理済みアイテムを更新/削除 |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. ワーカースレッド起動
   └─ outbox-job.jsが実行される

2. イベント発火
   └─ StartOutboxProcessingEventをparentPortに送信

3. メインスレッド処理
   └─ Outbox処理サービスがイベントを受信
   └─ キューに蓄積されたメールを処理

4. ジョブ完了
   └─ parentPortに'done'を送信
```

### フローチャート

```mermaid
flowchart TD
    A[ワーカースレッド起動] --> B[StartOutboxProcessingEvent発火]
    B --> C[メインスレッドに通知]
    C --> D[Outboxサービス処理]
    D --> E[メール送信]
    E --> F[ジョブ完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| キュー処理 | outbox | SELECT/UPDATE/DELETE | キューアイテムの取得・更新・削除 |

### テーブル別操作詳細

#### outbox

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | 未処理のキューアイテム | |
| UPDATE/DELETE | - | 処理完了後 | |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | キャンセル | ワーカースレッドがキャンセルされた | メッセージ出力後、プロセス終了 |
| - | メール送信エラー | SMTP送信失敗 | 次回実行時に再処理 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（次回cron実行で再処理） |
| リトライ間隔 | 5分（次回cron実行時） |
| リトライ対象エラー | メール送信エラー |

### 障害時対応

- キャンセル時は「cancelled」メッセージを送信して終了
- エラー発生時は次回の5分後実行で再処理

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | イベント駆動のため不定 |
| コミットタイミング | 処理完了時 |
| ロールバック条件 | 処理失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | キュー蓄積量に依存 |
| 目標処理時間 | 5分以内（次回実行前） |
| メモリ使用量上限 | 特になし |

## 排他制御

- hasScheduled.processOutboxフラグによる重複スケジュール防止
- ワーカースレッドによる非同期処理

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| キャンセルログ | キャンセル時 | `Outbox job cancelled before completion` |
| 完了ログ | 完了時 | `done` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- memberWelcomeEmailSendInstantly設定がtrue/'true'の場合、3秒ごとに実行（テスト/開発用）
- ワーカースレッドからイベントを発火し、メインスレッドで処理を実行する設計
- ウェルカムメールなどの送信キューを処理
- ランダムな秒・分オフセットでデータベースへの負荷スパイクを分散
