---
generated_at: 2026-01-29 21:40:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-email-analytics-fetch-latest

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **想定処理件数の約2,500イベント/分**：ログコメントからの推測値
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/email-analytics/jobs/fetch-latest/index.js`
- E-02: `ghost/core/core/server/services/email-analytics/email-analytics-service.js`
- E-03: `ghost/core/core/server/services/email-analytics/email-analytics-service-wrapper.js`
- E-04: `ghost/core/core/server/services/email-analytics/lib/queries.js`
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 5分ごとにcronスケジュールで実行 | E-05 | ○ |
| C-02 | ワーカースレッドからStartEmailAnalyticsJobEventを発火 | E-01 L27-34 | ○ |
| C-03 | fetchingフラグで同時実行を防止 | E-03 L170-173 | ○ |
| C-04 | 開封イベントを優先的に取得 | E-03 L180 | ○ |
| C-05 | 最大10,000件のイベントを取得 | E-03 L180-181 | ○ |
| C-06 | TRUST_THRESHOLD_MSは30分 | E-02 L36 | ○ |
| C-07 | FETCH_LATEST_END_MARGIN_MSは1分 | E-02 L37 | ○ |
| C-08 | バッチ処理モードで100件単位で処理 | E-02 L638-639 | ○ |
| C-09 | 5分ごとまたは5000メンバーで中間集計 | E-02 L385 | ○ |
| C-10 | email_recipientsテーブルを更新 | E-04 L165-178 | ○ |
| C-11 | emailsテーブルの統計を集計 | E-04 L164-178 | ○ |
| C-12 | membersテーブルの統計を更新 | E-04 L181-203 | ○ |
| C-13 | jobsテーブルに実行状態を記録 | E-04 L109-161 | ○ |
| C-14 | MIN_EMAIL_COUNT_FOR_OPEN_RATEは5件 | E-04 L8 | ○ |
| C-15 | 処理モードはBATCHED/SEQUENTIALの2種類 | E-03 L61-62 | ○ |
| C-16 | delivered, opened, failed, unsubscribed, complained イベントを処理 | E-02 L534-617 | ○ |
| C-17 | イベント処理結果をEventProcessingResultで管理 | E-02 L332-334 | ○ |
| C-18 | Mailgun APIからイベントを取得 | E-03 L52-54 | ○ |
| C-19 | キャンセル時は「Fetching canceled」をログ | E-02 L417-422 | ○ |
| C-20 | 高イベント数時は即座に再起動 | E-03 L181-184 | ○ |
| C-21 | _logJobCompletionでスループットをログ | E-03 L76-112 | ○ |
| C-22 | openedJobLagWarningMinutesで遅延警告 | E-03 L117-123 | ○ |
| C-23 | aggregateMemberStatsBatchで100件ずつ処理 | E-02 L638-639 | ○ |
| C-24 | Prometheusクライアントでメトリクス記録 | E-02 L111-114 | ○ |
| C-25 | 約2,500イベント/分の処理性能 | E-03 L177コメント | △ |

## 4) 不足情報（Unknown / Missing）
- C-25：処理性能の数値はソースコード内のコメント（「Data shows we can process ~2500 events per minute」）からの推測であり、実測値ではない
  - 候補：パフォーマンステスト結果 / 本番環境メトリクス / ベンチマーク資料

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的に高い信頼度

## 6) レビュアーチェックリスト（最小）
- [ ] 処理性能の数値（2,500イベント/分）が実環境と整合しているか確認
- [ ] Mailgun APIの設定要件が正しく記載されているか確認
- [ ] エラー時のリカバリ手順が運用要件と合致しているか確認
