---
generated_at: 2026-01-29 21:58:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-external-media-inliner

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ghost/core/core/server/services/media-inliner/service.js`
- E-02: `ghost/core/core/server/services/media-inliner/external-media-inliner.js`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | オンデマンドで手動実行 | E-03 | ○ |
| C-02 | デフォルトドメインはRevue/Substack | E-01 L37-39 | ○ |
| C-03 | jobsService.addJobで非オフロードジョブ登録 | E-01 L47-54 | ○ |
| C-04 | offloaded: false | E-01 L53 | ○ |
| C-05 | PostModel.findAll()で全投稿取得 | E-02 L283 | ○ |
| C-06 | feature_imageをインライン | E-02 L284-286, L295 | ○ |
| C-07 | mobiledocコンテンツをインライン | E-02 L297-303 | ○ |
| C-08 | lexicalコンテンツをインライン | E-02 L305-313 | ○ |
| C-09 | PostMetaModel.findPage()で投稿メタ取得 | E-02 L331-333 | ○ |
| C-10 | og_image, twitter_imageをインライン | E-02 L334-337 | ○ |
| C-11 | TagModel.findPage()で全タグ取得 | E-02 L341-343 | ○ |
| C-12 | UserModel.findPage()で全ユーザー取得 | E-02 L352-354 | ○ |
| C-13 | profile_image, cover_imageをインライン | E-02 L355-358 | ○ |
| C-14 | getRemoteMedia()でHTTPダウンロード | E-02 L45-69 | ○ |
| C-15 | followRedirect: true | E-02 L55-57 | ○ |
| C-16 | extractFileDataFromResponse()でファイル情報抽出 | E-02 L78-126 | ○ |
| C-17 | HEIC/HEIFはJPEGに変換 | E-02 L95-109 | ○ |
| C-18 | heic-convert使用 | E-02 L8 | ○ |
| C-19 | ファイル名は最大248文字 | E-02 L117-119 | ○ |
| C-20 | storeMediaLocally()でローカル保存 | E-02 L133-149 | ○ |
| C-21 | getStorage()で拡張子に応じたストレージ選択 | E-01 L19-28 | ○ |
| C-22 | __GHOST_URL__形式に置換 | E-02 L194, L234 | ○ |
| C-23 | findMatches()で正規表現検索 | E-02 L152-168 | ○ |
| C-24 | DataImportErrorでエラーログ | E-02 L64-66, L106-108, L271-273 | ○ |
| C-25 | context: internalで処理 | E-02 L283, L316-320 | ○ |
| C-26 | 完了ログ出力 | E-02 L362 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから全ての主張が裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] ストレージアダプタが適切に設定されているか確認
- [ ] デフォルトドメイン以外のインライン対象がある場合はパラメータ指定を確認
- [ ] 大量のメディアがある場合のメモリ・ディスク容量を確認
